/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark.internal.conversion.swagger.v2_0;

import com.wordnik.swagger.models.ArrayModel;
import com.wordnik.swagger.models.Contact;
import com.wordnik.swagger.models.Info;
import com.wordnik.swagger.models.Model;
import com.wordnik.swagger.models.ModelImpl;
import com.wordnik.swagger.models.Path;
import com.wordnik.swagger.models.RefModel;
import com.wordnik.swagger.models.Response;
import com.wordnik.swagger.models.Scheme;
import com.wordnik.swagger.models.Swagger;
import com.wordnik.swagger.models.parameters.BodyParameter;
import com.wordnik.swagger.models.parameters.HeaderParameter;
import com.wordnik.swagger.models.parameters.Parameter;
import com.wordnik.swagger.models.parameters.PathParameter;
import com.wordnik.swagger.models.parameters.QueryParameter;
import com.wordnik.swagger.models.properties.AbstractNumericProperty;
import com.wordnik.swagger.models.properties.AbstractProperty;
import com.wordnik.swagger.models.properties.ArrayProperty;
import com.wordnik.swagger.models.properties.BooleanProperty;
import com.wordnik.swagger.models.properties.DateProperty;
import com.wordnik.swagger.models.properties.DoubleProperty;
import com.wordnik.swagger.models.properties.FloatProperty;
import com.wordnik.swagger.models.properties.IntegerProperty;
import com.wordnik.swagger.models.properties.LongProperty;
import com.wordnik.swagger.models.properties.RefProperty;
import com.wordnik.swagger.models.properties.StringProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.logging.Logger;
import org.restlet.engine.util.StringUtils;
import org.restlet.ext.apispark.internal.conversion.swagger.v2_0.SwaggerTypeFormat;
import org.restlet.ext.apispark.internal.conversion.swagger.v2_0.SwaggerTypes;
import org.restlet.ext.apispark.internal.model.Definition;
import org.restlet.ext.apispark.internal.model.Endpoint;
import org.restlet.ext.apispark.internal.model.Header;
import org.restlet.ext.apispark.internal.model.License;
import org.restlet.ext.apispark.internal.model.Operation;
import org.restlet.ext.apispark.internal.model.PathVariable;
import org.restlet.ext.apispark.internal.model.PayLoad;
import org.restlet.ext.apispark.internal.model.Property;
import org.restlet.ext.apispark.internal.model.Representation;
import org.restlet.ext.apispark.internal.model.Resource;
import org.restlet.ext.apispark.internal.model.Types;

public class Swagger2Translator {
    protected static Logger LOGGER = Logger.getLogger(Swagger2Translator.class.getName());
    public static final String SWAGGER_VERSION = "2.0";

    private static void fillDefinitions(Definition definition, Swagger swagger) {
        for (Representation representation : definition.getContract().getRepresentations()) {
            if (representation.isRaw() || Types.isPrimitiveType(representation.getName())) continue;
            if (StringUtils.isNullOrEmpty((String)representation.getIdentifier())) {
                LOGGER.warning("A representation should have an identifier:" + representation.getName());
                continue;
            }
            ModelImpl modelSwagger = new ModelImpl();
            modelSwagger.setName(representation.getIdentifier());
            modelSwagger.setDescription(representation.getDescription());
            for (Property property : representation.getProperties()) {
                com.wordnik.swagger.models.properties.Property propertySwagger;
                if (property.getMaxOccurs() != null && (property.getMaxOccurs() > 1 || property.getMaxOccurs() == -1)) {
                    ArrayProperty arrayProperty = new ArrayProperty();
                    arrayProperty.setItems(Swagger2Translator.newPropertyForType(property.getType()));
                    propertySwagger = arrayProperty;
                } else {
                    propertySwagger = Swagger2Translator.newPropertyForType(property.getType());
                }
                propertySwagger.setName(property.getName());
                propertySwagger.setDescription(property.getDescription());
                if (propertySwagger instanceof AbstractNumericProperty) {
                    AbstractNumericProperty abstractNumericProperty = (AbstractNumericProperty)propertySwagger;
                    try {
                        if (property.getMin() != null) {
                            abstractNumericProperty.setMinimum(Double.valueOf(property.getMin()));
                        }
                    }
                    catch (NumberFormatException e) {
                        LOGGER.warning("Min property is not a number: " + property.getMin());
                    }
                    try {
                        if (property.getMax() != null) {
                            abstractNumericProperty.setMaximum(Double.valueOf(property.getMax()));
                        }
                    }
                    catch (NumberFormatException e) {
                        LOGGER.warning("Max property is not a number: " + property.getMax());
                    }
                }
                modelSwagger.property(property.getName(), propertySwagger);
            }
            swagger.addDefinition(modelSwagger.getName(), (Model)modelSwagger);
        }
    }

    private static void fillInfo(Definition definition, Swagger swagger) {
        Info infoSwagger = new Info();
        infoSwagger.setTitle(definition.getContract().getName());
        infoSwagger.setDescription(definition.getContract().getDescription());
        infoSwagger.setVersion(definition.getVersion());
        Contact contactSwagger = new Contact();
        if (definition.getContact() != null) {
            contactSwagger.setName(definition.getContact().getName());
            contactSwagger.setEmail(definition.getContact().getEmail());
            contactSwagger.setUrl(definition.getContact().getUrl());
        }
        infoSwagger.setContact(contactSwagger);
        com.wordnik.swagger.models.License licenseSwagger = new com.wordnik.swagger.models.License();
        if (definition.getLicense() != null) {
            if (!StringUtils.isNullOrEmpty((String)definition.getLicense().getName())) {
                License license = definition.getLicense();
                licenseSwagger.setName(license.getName());
                licenseSwagger.setUrl(license.getUrl());
                infoSwagger.setLicense(licenseSwagger);
            } else if (!StringUtils.isNullOrEmpty((String)definition.getLicense().getUrl())) {
                LOGGER.warning("You must specify a license name");
            }
        }
        swagger.setInfo(infoSwagger);
    }

    private static void fillMainAttributes(Definition definition, Swagger swagger) {
        if (definition.getEndpoints() != null && !definition.getEndpoints().isEmpty()) {
            Endpoint endpoint = definition.getEndpoints().get(0);
            swagger.setHost(endpoint.getDomain() + (endpoint.getPort() == null ? "" : ":" + endpoint.getPort()));
            swagger.setBasePath(endpoint.getBasePath());
            swagger.setSchemes(Arrays.asList(Scheme.forValue((String)endpoint.getProtocol())));
        }
    }

    private static void fillOperationParameters(Definition definition, Resource resource, Operation operation, com.wordnik.swagger.models.Operation operationSwagger) {
        for (PathVariable pathVariable : resource.getPathVariables()) {
            PathParameter pathParameterSwagger = new PathParameter();
            SwaggerTypeFormat swaggerTypeFormat = SwaggerTypes.toSwaggerType(pathVariable.getType());
            pathParameterSwagger.setType(swaggerTypeFormat.getType());
            pathParameterSwagger.setFormat(swaggerTypeFormat.getFormat());
            pathParameterSwagger.setName(pathVariable.getName());
            pathParameterSwagger.setDescription(pathVariable.getDescription());
            operationSwagger.addParameter((Parameter)pathParameterSwagger);
        }
        if (operation.getInputPayLoad() != null) {
            ModelImpl modelImpl;
            BodyParameter bodyParameterSwagger = new BodyParameter();
            bodyParameterSwagger.setName("body");
            PayLoad inRepr = operation.getInputPayLoad();
            Representation representation = definition.getContract().getRepresentation(inRepr.getType());
            if (representation != null && representation.isRaw()) {
                modelImpl = new ModelImpl();
                modelImpl.setType(representation.getIdentifier());
                modelImpl.setDescription(representation.getDescription());
                bodyParameterSwagger.setSchema((Model)modelImpl);
            } else if (inRepr.isArray()) {
                ArrayModel arrayModel = new ArrayModel();
                arrayModel.setType("array");
                arrayModel.setItems(Swagger2Translator.newPropertyForType(inRepr.getType()));
                bodyParameterSwagger.setSchema((Model)arrayModel);
            } else if (Types.isPrimitiveType(inRepr.getType())) {
                modelImpl = new ModelImpl();
                modelImpl.setType(inRepr.getType());
                bodyParameterSwagger.setSchema((Model)modelImpl);
            } else {
                RefModel refModel = new RefModel();
                refModel.set$ref(inRepr.getType());
                bodyParameterSwagger.setSchema((Model)refModel);
            }
            operationSwagger.addParameter((Parameter)bodyParameterSwagger);
        }
        for (org.restlet.ext.apispark.internal.model.QueryParameter queryParameter : operation.getQueryParameters()) {
            QueryParameter queryParameterSwagger = new QueryParameter();
            queryParameterSwagger.setRequired(queryParameter.isRequired());
            if (queryParameter.isAllowMultiple()) {
                queryParameterSwagger.setType("array");
                queryParameterSwagger.setItems(Swagger2Translator.newPropertyForType(queryParameter.getType()));
            } else {
                queryParameterSwagger.setType(SwaggerTypes.toSwaggerType(queryParameter.getType()).getType());
                queryParameterSwagger.setFormat(SwaggerTypes.toSwaggerType(queryParameter.getType()).getFormat());
            }
            queryParameterSwagger.setName(queryParameter.getName());
            queryParameterSwagger.setDescription(queryParameter.getDescription());
            operationSwagger.addParameter((Parameter)queryParameterSwagger);
        }
        for (Header header : operation.getHeaders()) {
            HeaderParameter headerParameterSwagger = new HeaderParameter();
            headerParameterSwagger.setRequired(header.isRequired());
            headerParameterSwagger.setType(SwaggerTypes.toSwaggerType(header.getType()).getType());
            headerParameterSwagger.setFormat(SwaggerTypes.toSwaggerType(header.getType()).getFormat());
            headerParameterSwagger.setName(header.getName());
            headerParameterSwagger.setDescription(header.getDescription());
            operationSwagger.addParameter((Parameter)headerParameterSwagger);
        }
    }

    private static void fillOperationResponses(Definition definition, Operation operation, com.wordnik.swagger.models.Operation operationSwagger) {
        for (org.restlet.ext.apispark.internal.model.Response response : operation.getResponses()) {
            Response responseSwagger = new Response();
            responseSwagger.setDescription(response.getDescription());
            if (response.getOutputPayLoad() != null && response.getOutputPayLoad().getType() != null) {
                PayLoad entity = response.getOutputPayLoad();
                Representation representation = definition.getContract().getRepresentation(entity.getType());
                if (representation != null && representation.isRaw()) {
                    FileProperty fileProperty = new FileProperty();
                    fileProperty.setDescription(representation.getDescription());
                    responseSwagger.setSchema((com.wordnik.swagger.models.properties.Property)fileProperty);
                } else if (entity.isArray()) {
                    ArrayProperty arrayProperty = new ArrayProperty();
                    arrayProperty.setItems(Swagger2Translator.newPropertyForType(entity.getType()));
                    responseSwagger.setSchema((com.wordnik.swagger.models.properties.Property)arrayProperty);
                } else {
                    responseSwagger.setSchema(Swagger2Translator.newPropertyForType(entity.getType()));
                }
            }
            operationSwagger.addResponse(String.valueOf(response.getCode()), responseSwagger);
        }
    }

    private static void fillPathOperations(Definition definition, Resource resource, Path pathSwagger) {
        for (Operation operation : resource.getOperations()) {
            com.wordnik.swagger.models.Operation operationSwagger = new com.wordnik.swagger.models.Operation();
            operationSwagger.setTags(new ArrayList());
            operationSwagger.getTags().addAll(resource.getSections());
            String method = operation.getMethod().toLowerCase();
            Path setResult = pathSwagger.set(method, operationSwagger);
            if (setResult == null) {
                LOGGER.warning("Method not supported:" + method);
                return;
            }
            String description = operation.getDescription();
            if (description != null) {
                operationSwagger.setSummary(description.length() > 120 ? description.substring(0, 120) : description);
            }
            operationSwagger.setDescription(description);
            operationSwagger.setOperationId(operation.getName());
            operationSwagger.setConsumes(operation.getConsumes());
            operationSwagger.setProduces(operation.getProduces());
            Swagger2Translator.fillOperationParameters(definition, resource, operation, operationSwagger);
            Swagger2Translator.fillOperationResponses(definition, operation, operationSwagger);
        }
    }

    private static void fillPaths(Definition definition, Swagger swagger) {
        LinkedHashMap<String, Path> paths = new LinkedHashMap<String, Path>();
        for (Resource resource : definition.getContract().getResources()) {
            Path pathSwagger = new Path();
            Swagger2Translator.fillPathOperations(definition, resource, pathSwagger);
            paths.put(resource.getResourcePath(), pathSwagger);
        }
        swagger.setPaths(paths);
    }

    public static Swagger getSwagger(Definition definition) {
        Swagger swagger = new Swagger();
        swagger.setSwagger(SWAGGER_VERSION);
        Swagger2Translator.fillMainAttributes(definition, swagger);
        Swagger2Translator.fillInfo(definition, swagger);
        Swagger2Translator.fillPaths(definition, swagger);
        Swagger2Translator.fillDefinitions(definition, swagger);
        return swagger;
    }

    private static com.wordnik.swagger.models.properties.Property newPropertyForType(String type) {
        if ("string".equals(type.toLowerCase())) {
            return new StringProperty();
        }
        if ("byte".equals(type.toLowerCase())) {
            return new ByteProperty();
        }
        if ("short".equals(type.toLowerCase())) {
            return new ShortProperty();
        }
        if ("integer".equals(type.toLowerCase())) {
            return new IntegerProperty();
        }
        if ("long".equals(type.toLowerCase())) {
            return new LongProperty();
        }
        if ("float".equals(type.toLowerCase())) {
            return new FloatProperty();
        }
        if ("double".equals(type.toLowerCase())) {
            return new DoubleProperty();
        }
        if ("date".equals(type.toLowerCase())) {
            return new DateProperty();
        }
        if ("boolean".equals(type.toLowerCase())) {
            return new BooleanProperty();
        }
        return new RefProperty().asDefault(type);
    }

    private static class ShortProperty
    extends AbstractProperty {
        private ShortProperty() {
            this.setType("integer");
            this.setFormat("int32");
        }
    }

    private static class FileProperty
    extends AbstractProperty {
        private FileProperty() {
            this.setType("file");
        }
    }

    private static class ByteProperty
    extends AbstractProperty {
        private ByteProperty() {
            this.setType("string");
            this.setFormat("byte");
        }
    }
}

