/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark.internal.firewall.handler;

import org.restlet.Request;
import org.restlet.Response;
import org.restlet.ext.apispark.internal.firewall.handler.BlockingHandler;
import org.restlet.ext.apispark.internal.firewall.handler.policy.LimitPolicy;
import org.restlet.ext.apispark.internal.firewall.rule.CounterResult;
import org.restlet.util.Series;

public class RateLimitationHandler
extends BlockingHandler {
    public RateLimitationHandler(LimitPolicy limitPolicy) {
        super(limitPolicy);
    }

    @Override
    public int handle(Request request, Response response, CounterResult counterResult) {
        Series headers = response.getHeaders();
        headers.set("X-RateLimit-Remaining", Integer.toString(this.getLimit(request, counterResult.getCountedValue()) - counterResult.getConsumed()));
        headers.set("X-RateLimit-Limit", Integer.toString(this.getLimit(request, counterResult.getCountedValue())));
        headers.set("X-RateLimit-Reset", Long.toString(counterResult.getReset()));
        response.getAttributes().put("org.restlet.http.headers", headers);
        return super.handle(request, response, counterResult);
    }
}

