/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark.internal.firewall.rule.counter;

import com.google.common.base.Stopwatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.ext.apispark.internal.firewall.rule.CounterResult;
import org.restlet.ext.apispark.internal.firewall.rule.counter.Counter;

public class PeriodicCounter
extends Counter {
    protected final AtomicInteger counter = new AtomicInteger();
    private final AtomicLong counterReset;
    private final long period;
    private final Stopwatch stopwatch;

    public PeriodicCounter(long period) {
        this.period = period;
        this.stopwatch = Stopwatch.createStarted();
        this.counterReset = new AtomicLong();
    }

    @Override
    public void decrement() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CounterResult increment() {
        long reset;
        long elapsed;
        Stopwatch stopwatch = this.stopwatch;
        synchronized (stopwatch) {
            elapsed = this.stopwatch.elapsed(TimeUnit.SECONDS);
            if (elapsed > this.period) {
                Context.getCurrentLogger().log(Level.FINE, "Period reinitialized.");
                this.stopwatch.reset();
                this.stopwatch.start();
                this.counter.getAndSet(0);
                reset = System.currentTimeMillis() / 1000L + this.period;
                this.counterReset.getAndSet(reset);
                elapsed = 0L;
            } else {
                reset = this.counterReset.get();
            }
        }
        int consumed = this.counter.incrementAndGet();
        CounterResult counterResult = new CounterResult();
        counterResult.setConsumed(consumed);
        counterResult.setElapsed(elapsed);
        counterResult.setReset(reset);
        return counterResult;
    }
}

