/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark.internal.introspection.application;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.restlet.data.ChallengeScheme;
import org.restlet.ext.apispark.internal.model.Representation;
import org.restlet.ext.apispark.internal.model.Resource;
import org.restlet.ext.apispark.internal.model.Section;

public class CollectInfo {
    private Map<String, Representation> representations = new HashMap<String, Representation>();
    private List<Resource> resources = new ArrayList<Resource>();
    private List<ChallengeScheme> schemes = new ArrayList<ChallengeScheme>();
    private Map<String, Section> sections = new HashMap<String, Section>();

    public void addRepresentation(Representation representation) {
        this.representations.put(representation.getIdentifier(), representation);
    }

    public void addResource(Resource resource) {
        this.resources.add(resource);
    }

    public boolean addSchemeIfNotExists(ChallengeScheme scheme) {
        if (!this.schemes.contains(scheme)) {
            return this.schemes.add(scheme);
        }
        return false;
    }

    public void addSection(Section section) {
        this.sections.put(section.getName(), section);
    }

    public Representation getRepresentation(String identifier) {
        return this.representations.get(identifier);
    }

    public List<Representation> getRepresentations() {
        return new ArrayList<Representation>(this.representations.values());
    }

    public List<Resource> getResources() {
        return new ArrayList<Resource>(this.resources);
    }

    public List<ChallengeScheme> getSchemes() {
        return new ArrayList<ChallengeScheme>(this.schemes);
    }

    public Section getSection(String identifier) {
        return this.sections.get(identifier);
    }

    public List<Section> getSections() {
        return new ArrayList<Section>(this.sections.values());
    }

    public void setSections(Map<String, Section> sections) {
        this.sections = sections;
    }
}

