/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark.internal.introspection.application;

import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Type;
import java.util.List;
import org.restlet.engine.util.BeanInfoUtils;
import org.restlet.ext.apispark.internal.introspection.IntrospectionHelper;
import org.restlet.ext.apispark.internal.introspection.application.CollectInfo;
import org.restlet.ext.apispark.internal.model.Property;
import org.restlet.ext.apispark.internal.model.Representation;
import org.restlet.ext.apispark.internal.model.Section;
import org.restlet.ext.apispark.internal.model.Types;
import org.restlet.ext.apispark.internal.reflect.ReflectUtils;

public class RepresentationCollector {
    public static String addRepresentation(CollectInfo collectInfo, Class<?> clazz, Type type, List<? extends IntrospectionHelper> introspectionHelper) {
        boolean notInCache;
        Representation representation = new Representation();
        representation.setDescription("");
        Class<?> c = ReflectUtils.getSimpleClass(type);
        Class<?> representationType = c == null ? clazz : c;
        boolean generic = c != null && !c.getCanonicalName().equals(clazz.getCanonicalName());
        boolean isList = ReflectUtils.isListType(clazz);
        if (generic || isList) {
            RepresentationCollector.addRepresentation(collectInfo, representationType, representationType.getGenericSuperclass(), introspectionHelper);
            return null;
        }
        if (Types.isPrimitiveType(representationType) || ReflectUtils.isJdkClass(representationType)) {
            return null;
        }
        boolean isFile = org.restlet.representation.Representation.class.isAssignableFrom(clazz);
        if (isFile) {
            representation.setIdentifier("file");
            representation.setName("file");
        } else {
            representation.setIdentifier(Types.convertPrimitiveType(representationType));
            String packageName = clazz.getPackage().getName();
            representation.getSections().add(packageName);
            if (collectInfo.getSection(packageName) == null) {
                collectInfo.addSection(new Section(packageName));
            }
            representation.setName(representationType.getSimpleName());
        }
        boolean isRaw = isFile || ReflectUtils.isJdkClass(representationType);
        representation.setRaw(isRaw);
        boolean bl = notInCache = collectInfo.getRepresentation(representation.getIdentifier()) == null;
        if (notInCache) {
            collectInfo.addRepresentation(representation);
            if (!isRaw) {
                BeanInfo beanInfo = BeanInfoUtils.getBeanInfo(representationType);
                for (PropertyDescriptor pd : beanInfo.getPropertyDescriptors()) {
                    Class<?> propertyClazz = pd.getReadMethod().getReturnType();
                    Type propertyType = pd.getReadMethod().getGenericReturnType();
                    Property property = new Property();
                    property.setName(pd.getName());
                    property.setDescription("");
                    property.setType(Types.convertPrimitiveType(ReflectUtils.getSimpleClass(propertyType)));
                    property.setMinOccurs(0);
                    boolean isCollection = ReflectUtils.isListType(propertyClazz);
                    property.setMaxOccurs(isCollection ? -1 : 1);
                    RepresentationCollector.addRepresentation(collectInfo, propertyClazz, propertyType, introspectionHelper);
                    for (IntrospectionHelper introspectionHelper2 : introspectionHelper) {
                        introspectionHelper2.processProperty(property, pd.getReadMethod());
                    }
                    representation.getProperties().add(property);
                }
            }
            for (IntrospectionHelper introspectionHelper3 : introspectionHelper) {
                introspectionHelper3.processRepresentation(representation, representationType);
            }
        }
        return representation.getIdentifier();
    }
}

