/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark.internal.introspection.application;

import java.util.List;
import java.util.logging.Logger;
import org.restlet.Restlet;
import org.restlet.data.ChallengeScheme;
import org.restlet.ext.apispark.internal.introspection.IntrospectionHelper;
import org.restlet.ext.apispark.internal.introspection.application.CollectInfo;
import org.restlet.ext.apispark.internal.introspection.application.ResourceCollector;
import org.restlet.resource.Directory;
import org.restlet.resource.Finder;
import org.restlet.resource.ServerResource;
import org.restlet.routing.Filter;
import org.restlet.routing.Route;
import org.restlet.routing.Router;
import org.restlet.routing.TemplateRoute;
import org.restlet.security.ChallengeAuthenticator;

public class RestletCollector {
    private static Logger LOGGER = Logger.getLogger(RestletCollector.class.getName());

    public static void collect(CollectInfo collectInfo, String basePath, Restlet restlet, ChallengeScheme scheme, List<? extends IntrospectionHelper> introspectorHelpers) {
        if (restlet instanceof Router) {
            RestletCollector.collectForRouter(collectInfo, basePath, (Router)restlet, scheme, introspectorHelpers);
        } else if (restlet instanceof Route) {
            RestletCollector.collectForRoute(collectInfo, basePath, (Route)restlet, scheme, introspectorHelpers);
        } else if (restlet instanceof Filter) {
            RestletCollector.collectForFilter(collectInfo, basePath, (Filter)restlet, scheme, introspectorHelpers);
        } else if (restlet instanceof Finder) {
            RestletCollector.collectForFinder(collectInfo, basePath, (Finder)restlet, scheme, introspectorHelpers);
        } else {
            LOGGER.fine("Restlet type ignored. Class " + restlet.getClass());
        }
    }

    private static void collectForFilter(CollectInfo collectInfo, String basePath, Filter filter, ChallengeScheme scheme, List<? extends IntrospectionHelper> introspectionHelper) {
        if (filter instanceof ChallengeAuthenticator) {
            scheme = ((ChallengeAuthenticator)filter).getScheme();
            collectInfo.addSchemeIfNotExists(scheme);
        }
        RestletCollector.collect(collectInfo, basePath, filter.getNext(), scheme, introspectionHelper);
    }

    private static void collectForFinder(CollectInfo collectInfo, String basePath, Finder finder, ChallengeScheme scheme, List<? extends IntrospectionHelper> introspectionHelper) {
        if (finder instanceof Directory) {
            ResourceCollector.collectResourceForDirectory(collectInfo, (Directory)finder, basePath, scheme, introspectionHelper);
        } else {
            ServerResource serverResource = finder.find(null, null);
            if (serverResource != null) {
                ResourceCollector.collectResourceForServletResource(collectInfo, serverResource, basePath, scheme, introspectionHelper);
            } else {
                LOGGER.fine("Finder has no server resource. Class " + finder.getClass());
            }
        }
    }

    private static void collectForRoute(CollectInfo collectInfo, String basePath, Route route, ChallengeScheme scheme, List<? extends IntrospectionHelper> introspectionHelper) {
        if (route instanceof TemplateRoute) {
            TemplateRoute templateRoute = (TemplateRoute)route;
            String path = templateRoute.getTemplate().getPattern();
            RestletCollector.collect(collectInfo, basePath + path, route.getNext(), scheme, introspectionHelper);
        } else {
            LOGGER.fine("Route type ignored. Class " + route.getClass());
        }
    }

    private static void collectForRouter(CollectInfo collectInfo, String basePath, Router router, ChallengeScheme scheme, List<? extends IntrospectionHelper> introspectionHelper) {
        for (Route route : router.getRoutes()) {
            RestletCollector.collectForRoute(collectInfo, basePath, route, scheme, introspectionHelper);
        }
        if (router.getDefaultRoute() != null) {
            RestletCollector.collectForRoute(collectInfo, basePath, router.getDefaultRoute(), scheme, introspectionHelper);
        }
    }
}

