/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark.internal.introspection.jaxrs;

import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Consumes;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.engine.util.BeanInfoUtils;
import org.restlet.engine.util.StringUtils;
import org.restlet.ext.apispark.DocumentedApplication;
import org.restlet.ext.apispark.internal.introspection.IntrospectionHelper;
import org.restlet.ext.apispark.internal.model.Contract;
import org.restlet.ext.apispark.internal.model.Definition;
import org.restlet.ext.apispark.internal.model.Endpoint;
import org.restlet.ext.apispark.internal.model.Header;
import org.restlet.ext.apispark.internal.model.Operation;
import org.restlet.ext.apispark.internal.model.PathVariable;
import org.restlet.ext.apispark.internal.model.PayLoad;
import org.restlet.ext.apispark.internal.model.Property;
import org.restlet.ext.apispark.internal.model.QueryParameter;
import org.restlet.ext.apispark.internal.model.Resource;
import org.restlet.ext.apispark.internal.model.Section;
import org.restlet.ext.apispark.internal.model.Types;
import org.restlet.ext.apispark.internal.reflect.ReflectUtils;
import org.restlet.ext.apispark.internal.utils.IntrospectionUtils;
import org.restlet.representation.Representation;

public class JaxRsIntrospector
extends IntrospectionUtils {
    protected static Logger LOGGER = Logger.getLogger(JaxRsIntrospector.class.getName());
    private static final String SUFFIX_RESOURCE = "Resource";
    private static final String SUFFIX_SERVER_RESOURCE = "ServerResource";

    private static void addEndpoints(Application application, Reference baseRef, Definition definition) {
        Endpoint endpoint;
        ApplicationPath ap = application.getClass().getAnnotation(ApplicationPath.class);
        if (ap != null) {
            endpoint = new Endpoint(ap.value());
            definition.getEndpoints().add(endpoint);
        }
        if (baseRef != null) {
            endpoint = new Endpoint(baseRef.getHostDomain(), baseRef.getHostPort(), baseRef.getSchemeProtocol().getSchemeName(), baseRef.getPath(), null);
            definition.getEndpoints().add(endpoint);
        }
    }

    private static void addRepresentation(CollectInfo collectInfo, Class<?> clazz, Type type, List<? extends IntrospectionHelper> introspectionHelper) {
        boolean notInCache;
        org.restlet.ext.apispark.internal.model.Representation representation = new org.restlet.ext.apispark.internal.model.Representation();
        representation.setDescription("");
        Class<?> c = ReflectUtils.getSimpleClass(type);
        Class<?> representationType = c == null ? clazz : c;
        boolean generic = c != null && !c.getCanonicalName().equals(clazz.getCanonicalName());
        boolean isList = ReflectUtils.isListType(clazz);
        if (generic || isList) {
            JaxRsIntrospector.addRepresentation(collectInfo, representationType, representationType.getGenericSuperclass(), introspectionHelper);
            return;
        }
        if (Types.isPrimitiveType(representationType) || ReflectUtils.isJdkClass(representationType)) {
            return;
        }
        boolean isFile = Representation.class.isAssignableFrom(clazz);
        if (isFile) {
            representation.setIdentifier("file");
            representation.setName("file");
        } else {
            representation.setIdentifier(Types.convertPrimitiveType(representationType));
            String packageName = clazz.getPackage().getName();
            representation.getSections().add(packageName);
            if (collectInfo.getSection(packageName) == null) {
                collectInfo.addSection(new Section(packageName));
            }
            representation.setName(representationType.getSimpleName());
        }
        boolean isRaw = isFile || ReflectUtils.isJdkClass(representationType);
        representation.setRaw(isRaw);
        boolean bl = notInCache = collectInfo.getRepresentation(representation.getIdentifier()) == null;
        if (notInCache) {
            collectInfo.addRepresentation(representation);
            if (!isRaw) {
                BeanInfo beanInfo = BeanInfoUtils.getBeanInfo(representationType);
                for (PropertyDescriptor pd : beanInfo.getPropertyDescriptors()) {
                    Class<?> propertyClazz = pd.getReadMethod().getReturnType();
                    Type propertyType = pd.getReadMethod().getGenericReturnType();
                    Property property = new Property();
                    property.setName(pd.getName());
                    property.setDescription("");
                    property.setType(Types.convertPrimitiveType(ReflectUtils.getSimpleClass(propertyType)));
                    property.setMinOccurs(0);
                    boolean isCollection = ReflectUtils.isListType(propertyClazz);
                    property.setMaxOccurs(isCollection ? -1 : 1);
                    JaxRsIntrospector.addRepresentation(collectInfo, propertyClazz, propertyType, introspectionHelper);
                    for (IntrospectionHelper introspectionHelper2 : introspectionHelper) {
                        introspectionHelper2.processProperty(property, pd.getReadMethod());
                    }
                    representation.getProperties().add(property);
                }
            }
            for (IntrospectionHelper introspectionHelper3 : introspectionHelper) {
                introspectionHelper3.processRepresentation(representation, representationType);
            }
        }
    }

    private static String cleanPath(String path) {
        if (path != null) {
            StringBuilder sb = new StringBuilder();
            boolean inVariable = false;
            boolean endVariable = false;
            StringBuilder varBuffer = null;
            for (int i = 0; i < path.length(); ++i) {
                char next = path.charAt(i);
                if (inVariable) {
                    if (next == '}') {
                        if (varBuffer.length() == 0) {
                            LOGGER.warning("Empty pattern variables are not allowed : " + path);
                        } else {
                            sb.append(varBuffer.toString());
                            varBuffer = new StringBuilder();
                        }
                        endVariable = false;
                        inVariable = false;
                        sb.append(next);
                        continue;
                    }
                    if (endVariable) continue;
                    if (Reference.isUnreserved((int)next)) {
                        varBuffer.append(next);
                        continue;
                    }
                    if (next != ':') continue;
                    endVariable = true;
                    continue;
                }
                sb.append(next);
                if (next == '{') {
                    inVariable = true;
                    varBuffer = new StringBuilder();
                    continue;
                }
                if (next != '}') continue;
                LOGGER.warning("An invalid character was detected inside a pattern variable : " + path);
            }
            return sb.toString();
        }
        return null;
    }

    public static Application getApplication(String className) {
        return ReflectUtils.newInstance(className, Application.class);
    }

    public static Definition getDefinition(Application application, Reference baseRef, List<? extends IntrospectionHelper> introspectionHelpers) {
        if (introspectionHelpers == null) {
            introspectionHelpers = new ArrayList<IntrospectionHelper>();
        }
        Definition definition = new Definition();
        CollectInfo collectInfo = new CollectInfo();
        ApplicationPath applicationPath = application.getClass().getAnnotation(ApplicationPath.class);
        if (applicationPath != null) {
            collectInfo.setApplicationPath(applicationPath.value());
        }
        JaxRsIntrospector.scanResources(collectInfo, application, introspectionHelpers);
        JaxRsIntrospector.updateDefinitionContract(application, definition);
        Contract contract = definition.getContract();
        contract.setResources(collectInfo.getResources());
        contract.setRepresentations(collectInfo.getRepresentations());
        contract.setSections(collectInfo.getSections());
        JaxRsIntrospector.addEndpoints(application, baseRef, definition);
        JaxRsIntrospector.sortDefinition(definition);
        JaxRsIntrospector.updateRepresentationsSectionsFromResources(definition);
        for (IntrospectionHelper introspectionHelper : introspectionHelpers) {
            introspectionHelper.processDefinition(definition, application.getClass());
        }
        return definition;
    }

    private static Header getHeader(Class<?> elementClazz, Type elementType, String defaultValue, HeaderParam headerParam) {
        Header header = new Header();
        header.setName(headerParam.value());
        header.setType(Types.convertPrimitiveType(ReflectUtils.getSimpleClass(elementType)));
        header.setAllowMultiple(ReflectUtils.isListType(elementClazz));
        header.setRequired(false);
        header.setDescription(StringUtils.isNullOrEmpty((String)defaultValue) ? "" : "Value: " + defaultValue);
        header.setDefaultValue(defaultValue);
        return header;
    }

    private static String getPathOrNull(Path path) {
        if (path != null) {
            return path.value();
        }
        return null;
    }

    private static PathVariable getPathVariable(Class<?> elementClazz, Type elementType, PathParam pathParam) {
        PathVariable pathVariable = new PathVariable();
        pathVariable.setName(pathParam.value());
        pathVariable.setType(Types.convertPrimitiveType(ReflectUtils.getSimpleClass(elementType)));
        return pathVariable;
    }

    private static QueryParameter getQueryParameter(Class<?> elementClazz, Type elementType, String defaultValue, QueryParam queryParam) {
        QueryParameter queryParameter = new QueryParameter();
        queryParameter.setName(queryParam.value());
        queryParameter.setType(Types.convertPrimitiveType(ReflectUtils.getSimpleClass(elementType)));
        queryParameter.setAllowMultiple(ReflectUtils.isListType(elementClazz));
        queryParameter.setRequired(false);
        queryParameter.setDescription(StringUtils.isNullOrEmpty((String)defaultValue) ? "" : "Value: " + defaultValue);
        queryParameter.setDefaultValue(defaultValue);
        return queryParameter;
    }

    private static String getResourceMethod(Method method) {
        if (method.getAnnotation(HEAD.class) != null) {
            return org.restlet.data.Method.HEAD.getName();
        }
        if (method.getAnnotation(OPTIONS.class) != null) {
            return org.restlet.data.Method.OPTIONS.getName();
        }
        if (method.getAnnotation(GET.class) != null) {
            return org.restlet.data.Method.GET.getName();
        }
        if (method.getAnnotation(PUT.class) != null) {
            return org.restlet.data.Method.PUT.getName();
        }
        if (method.getAnnotation(POST.class) != null) {
            return org.restlet.data.Method.POST.getName();
        }
        if (method.getAnnotation(DELETE.class) != null) {
            return org.restlet.data.Method.DELETE.getName();
        }
        if (method.getAnnotation(HttpMethod.class) != null) {
            return method.getAnnotation(HttpMethod.class).value();
        }
        return null;
    }

    private static boolean isResourceMethod(Method method) {
        return method.getAnnotation(HEAD.class) != null || method.getAnnotation(OPTIONS.class) != null || method.getAnnotation(GET.class) != null || method.getAnnotation(PUT.class) != null || method.getAnnotation(POST.class) != null || method.getAnnotation(DELETE.class) != null || method.getAnnotation(HttpMethod.class) != null;
    }

    private static String joinPaths(String ... nullablePaths) {
        StringBuilder result = new StringBuilder();
        ArrayList<String> paths = new ArrayList<String>();
        for (String path : nullablePaths) {
            if (StringUtils.isNullOrEmpty((String)path)) continue;
            paths.add(path);
        }
        int lastPathIndex = paths.size() - 1;
        for (int i = 0; i < paths.size(); ++i) {
            String path = (String)paths.get(i);
            if (!path.startsWith("/")) {
                result.append("/");
            }
            if (i != lastPathIndex && path.endsWith("/")) {
                result.append(path.substring(0, path.length() - 1));
                continue;
            }
            result.append(path);
        }
        if (result.length() == 0) {
            result.append("/");
        }
        return result.toString();
    }

    private static void scanClazz(CollectInfo collectInfo, Class<?> clazz, List<? extends IntrospectionHelper> introspectionHelper) {
        Method[] methods;
        ClazzInfo clazzInfo = new ClazzInfo();
        clazzInfo.setClazz(clazz);
        Path path = clazz.getAnnotation(Path.class);
        clazzInfo.setPath(path);
        Consumes consumes = clazz.getAnnotation(Consumes.class);
        clazzInfo.setConsumes(consumes);
        Produces produces = clazz.getAnnotation(Produces.class);
        clazzInfo.setProduces(produces);
        Constructor<?>[] constructors = clazz.getConstructors();
        if (constructors.length == 1) {
            JaxRsIntrospector.scanConstructor(constructors[0], clazzInfo);
        } else if (constructors.length > 1) {
            Constructor<?> selectedConstructor = null;
            int fieldsCount = -1;
            for (Constructor<?> constructor : constructors) {
                if (constructor.getParameterTypes().length <= fieldsCount) continue;
                selectedConstructor = constructor;
                fieldsCount = constructor.getParameterTypes().length;
            }
            JaxRsIntrospector.scanConstructor(selectedConstructor, clazzInfo);
        }
        Field[] fields = ReflectUtils.getAllDeclaredFields(clazz);
        if (fields != null) {
            for (Field field : fields) {
                JaxRsIntrospector.scanField(field, clazzInfo);
            }
        }
        ArrayList<Method> resourceMethods = new ArrayList<Method>();
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (!Modifier.isPublic(method.getModifiers())) continue;
            if (JaxRsIntrospector.isResourceMethod(method)) {
                resourceMethods.add(method);
                continue;
            }
            JaxRsIntrospector.scanSimpleMethod(collectInfo, method, clazzInfo);
        }
        for (Method resourceMethod : resourceMethods) {
            JaxRsIntrospector.scanResourceMethod(collectInfo, clazzInfo, resourceMethod, introspectionHelper);
        }
    }

    private static void scanConstructor(Constructor<?> constructor, ClazzInfo clazzInfo) {
        Annotation[][] parameterAnnotations = constructor.getParameterAnnotations();
        Class[] parameterTypes = constructor.getParameterTypes();
        Type[] genericParameterTypes = constructor.getGenericParameterTypes();
        JaxRsIntrospector.scanParameters(clazzInfo, parameterAnnotations, parameterTypes, genericParameterTypes);
    }

    private static void scanField(Field field, ClazzInfo clazzInfo) {
        QueryParam queryParam;
        PathParam pathParam;
        Class<?> elementClazz = field.getType();
        Type elementType = field.getGenericType();
        DefaultValue defaultvalue = field.getAnnotation(DefaultValue.class);
        String defaultValueString = defaultvalue != null ? defaultvalue.value() : null;
        HeaderParam headerParam = field.getAnnotation(HeaderParam.class);
        if (headerParam != null) {
            Header header = JaxRsIntrospector.getHeader(elementClazz, elementType, defaultValueString, headerParam);
            clazzInfo.addHeader(header);
        }
        if ((pathParam = field.getAnnotation(PathParam.class)) != null) {
            PathVariable pathVariable = JaxRsIntrospector.getPathVariable(elementClazz, elementType, pathParam);
            clazzInfo.addPathVariable(pathVariable);
        }
        if ((queryParam = field.getAnnotation(QueryParam.class)) != null) {
            QueryParameter queryParameter = JaxRsIntrospector.getQueryParameter(elementClazz, elementType, defaultValueString, queryParam);
            clazzInfo.addQueryParameter(queryParameter);
        }
    }

    private static void scanParameters(ClazzInfo clazzInfo, Annotation[][] parameterAnnotations, Class[] parameterTypes, Type[] genericParameterTypes) {
        for (int i = 0; i < parameterTypes.length; ++i) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = parameterAnnotations[i]) {
                String defaultValue = null;
                if (annotation instanceof DefaultValue) {
                    defaultValue = ((DefaultValue)annotation).value();
                }
                if (annotation instanceof HeaderParam) {
                    Header header = JaxRsIntrospector.getHeader(parameterTypes[i], genericParameterTypes[i], defaultValue, (HeaderParam)annotation);
                    clazzInfo.addHeader(header);
                }
                if (annotation instanceof PathParam) {
                    PathVariable pathVariable = JaxRsIntrospector.getPathVariable(parameterTypes[i], genericParameterTypes[i], (PathParam)annotation);
                    clazzInfo.addPathVariable(pathVariable);
                }
                if (!(annotation instanceof QueryParam)) continue;
                QueryParameter queryParameter = JaxRsIntrospector.getQueryParameter(parameterTypes[i], genericParameterTypes[i], defaultValue, (QueryParam)annotation);
                clazzInfo.addQueryParameter(queryParameter);
            }
        }
    }

    private static void scanResourceMethod(CollectInfo collectInfo, ClazzInfo clazzInfo, Method method, List<? extends IntrospectionHelper> introspectionHelper) {
        Consumes consumes;
        Path path = method.getAnnotation(Path.class);
        String fullPath = JaxRsIntrospector.joinPaths(collectInfo.getApplicationPath(), JaxRsIntrospector.getPathOrNull(clazzInfo.getPath()), JaxRsIntrospector.getPathOrNull(path));
        String cleanPath = JaxRsIntrospector.cleanPath(fullPath);
        Operation operation = new Operation();
        operation.setMethod(JaxRsIntrospector.getResourceMethod(method));
        if (StringUtils.isNullOrEmpty((String)operation.getName())) {
            LOGGER.warning("Java method " + method.getName() + " has no Method name.");
            operation.setName(method.getName());
        }
        if ((consumes = method.getAnnotation(Consumes.class)) != null) {
            operation.setConsumes(Arrays.asList(consumes.value()));
        } else if (clazzInfo.getConsumes() != null) {
            operation.setConsumes(Arrays.asList(clazzInfo.getConsumes().value()));
        }
        Produces produces = method.getAnnotation(Produces.class);
        if (produces != null) {
            operation.setProduces(Arrays.asList(produces.value()));
        } else if (clazzInfo.getProduces() != null) {
            operation.setProduces(Arrays.asList(clazzInfo.getProduces().value()));
        }
        Map<String, Header> headers = clazzInfo.getHeadersCopy();
        Map<String, PathVariable> pathVariables = clazzInfo.getPathVariablesCopy();
        Map<String, QueryParameter> queryParameters = clazzInfo.getQueryParametersCopy();
        ArrayList representations = new ArrayList();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        Class<?>[] parameterTypes = method.getParameterTypes();
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = parameterAnnotations[i]) {
                String defaultValue = null;
                boolean bl = true;
                if (annotation instanceof DefaultValue) {
                    defaultValue = ((DefaultValue)annotation).value();
                }
                if (annotation instanceof FormParam) {
                    bl = false;
                    JaxRsIntrospector.addRepresentation(collectInfo, parameterTypes[i], genericParameterTypes[i], introspectionHelper);
                }
                if (annotation instanceof HeaderParam) {
                    bl = false;
                    Header header = JaxRsIntrospector.getHeader(parameterTypes[i], genericParameterTypes[i], defaultValue, (HeaderParam)annotation);
                    headers.put(header.getName(), header);
                }
                if (annotation instanceof PathParam) {
                    bl = false;
                    PathVariable pathVariable = JaxRsIntrospector.getPathVariable(parameterTypes[i], genericParameterTypes[i], (PathParam)annotation);
                    pathVariables.put(pathVariable.getName(), pathVariable);
                }
                if (annotation instanceof QueryParam) {
                    bl = false;
                    QueryParameter queryParameter = JaxRsIntrospector.getQueryParameter(parameterTypes[i], genericParameterTypes[i], defaultValue, (QueryParam)annotation);
                    queryParameters.put(queryParameter.getName(), queryParameter);
                }
                if (annotation instanceof MatrixParam) {
                    bl = false;
                }
                if (annotation instanceof CookieParam) {
                    bl = false;
                }
                if (annotation instanceof Context) {
                    bl = false;
                }
                if (!bl) continue;
                JaxRsIntrospector.addRepresentation(collectInfo, parameterTypes[i], genericParameterTypes[i], introspectionHelper);
                PayLoad inputEntity = new PayLoad();
                inputEntity.setType(Types.convertPrimitiveType(ReflectUtils.getSimpleClass(genericParameterTypes[i])));
                inputEntity.setArray(ReflectUtils.isListType(parameterTypes[i]));
                operation.setInputPayLoad(inputEntity);
            }
        }
        operation.getQueryParameters().addAll(queryParameters.values());
        org.restlet.ext.apispark.internal.model.Response response = new org.restlet.ext.apispark.internal.model.Response();
        Class<?> outputClass = method.getReturnType();
        Type outputType = method.getGenericReturnType();
        if (outputClass != Void.TYPE) {
            JaxRsIntrospector.addRepresentation(collectInfo, outputClass, outputType, introspectionHelper);
            PayLoad outputEntity = new PayLoad();
            Class<?> simpleClass = ReflectUtils.getSimpleClass(outputType);
            if (Response.class.isAssignableFrom(simpleClass)) {
                outputEntity.setType("file");
            } else {
                outputEntity.setType(Types.convertPrimitiveType(simpleClass));
            }
            outputEntity.setArray(ReflectUtils.isListType(outputClass));
            response.setOutputPayLoad(outputEntity);
        }
        response.setCode(Status.SUCCESS_OK.getCode());
        response.setName("Success");
        response.setDescription("");
        response.setMessage(Status.SUCCESS_OK.getDescription());
        operation.getResponses().add(response);
        Resource resource = collectInfo.getResource(cleanPath);
        if (resource == null) {
            resource = new Resource();
            resource.setResourcePath(cleanPath);
            String name = clazzInfo.getClazz().getSimpleName();
            if (name.endsWith(SUFFIX_SERVER_RESOURCE) && name.length() > SUFFIX_SERVER_RESOURCE.length()) {
                name = name.substring(0, name.length() - SUFFIX_SERVER_RESOURCE.length());
            }
            if (name.endsWith(SUFFIX_RESOURCE) && name.length() > SUFFIX_RESOURCE.length()) {
                name = name.substring(0, name.length() - SUFFIX_RESOURCE.length());
            }
            resource.setName(name);
            resource.getPathVariables().addAll(pathVariables.values());
            String string = clazzInfo.getClazz().getPackage().getName();
            resource.getSections().add(string);
            collectInfo.addResource(resource);
            for (IntrospectionHelper introspectionHelper2 : introspectionHelper) {
                introspectionHelper2.processResource(resource, clazzInfo.getClazz());
            }
        }
        resource.getOperations().add(operation);
        for (IntrospectionHelper introspectionHelper3 : introspectionHelper) {
            introspectionHelper3.processOperation(resource, operation, clazzInfo.getClazz(), method);
        }
    }

    public static void scanResources(CollectInfo collectInfo, Application application, List<? extends IntrospectionHelper> introspectionHelper) {
        for (Class clazz : application.getClasses()) {
            JaxRsIntrospector.scanClazz(collectInfo, clazz, introspectionHelper);
        }
        for (Object singleton : application.getSingletons()) {
            if (singleton == null) continue;
            JaxRsIntrospector.scanClazz(collectInfo, singleton.getClass(), introspectionHelper);
        }
    }

    private static void scanSimpleMethod(CollectInfo collectInfo, Method method, ClazzInfo clazzInfo) {
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        Class[] parameterTypes = method.getParameterTypes();
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        JaxRsIntrospector.scanParameters(clazzInfo, parameterAnnotations, parameterTypes, genericParameterTypes);
    }

    private static void updateDefinitionContract(Application application, Definition definition) {
        Contract contract = new Contract();
        contract.setName(application.getClass().getName());
        org.restlet.ext.apispark.internal.introspection.application.CollectInfo collectInfo = new org.restlet.ext.apispark.internal.introspection.application.CollectInfo();
        if (application instanceof DocumentedApplication) {
            DocumentedApplication documentedApplication = (DocumentedApplication)application;
            collectInfo.setSections(documentedApplication.getSections());
        }
        definition.setContract(contract);
    }

    public static class CollectInfo {
        private String applicationPath;
        private Map<String, org.restlet.ext.apispark.internal.model.Representation> representations = new HashMap<String, org.restlet.ext.apispark.internal.model.Representation>();
        private Map<String, Resource> resourcesByPath = new LinkedHashMap<String, Resource>();
        private List<ChallengeScheme> schemes = new ArrayList<ChallengeScheme>();
        private Map<String, Section> sections = new HashMap<String, Section>();

        public void addRepresentation(org.restlet.ext.apispark.internal.model.Representation representation) {
            this.representations.put(representation.getIdentifier(), representation);
        }

        public void addResource(Resource resource) {
            this.resourcesByPath.put(resource.getResourcePath(), resource);
        }

        public boolean addSchemeIfNotExists(ChallengeScheme scheme) {
            if (!this.schemes.contains(scheme)) {
                return this.schemes.add(scheme);
            }
            return false;
        }

        public void addSection(Section section) {
            this.sections.put(section.getName(), section);
        }

        public String getApplicationPath() {
            return this.applicationPath;
        }

        public org.restlet.ext.apispark.internal.model.Representation getRepresentation(String identifier) {
            return this.representations.get(identifier);
        }

        public List<org.restlet.ext.apispark.internal.model.Representation> getRepresentations() {
            return new ArrayList<org.restlet.ext.apispark.internal.model.Representation>(this.representations.values());
        }

        public Resource getResource(String operationPath) {
            return this.resourcesByPath.get(operationPath);
        }

        public List<Resource> getResources() {
            return new ArrayList<Resource>(this.resourcesByPath.values());
        }

        public List<ChallengeScheme> getSchemes() {
            return new ArrayList<ChallengeScheme>(this.schemes);
        }

        public Section getSection(String identifier) {
            return this.sections.get(identifier);
        }

        public List<Section> getSections() {
            return new ArrayList<Section>(this.sections.values());
        }

        public void setApplicationPath(String applicationPath) {
            this.applicationPath = applicationPath;
        }

        public void setSections(Map<String, Section> sections) {
            this.sections = sections;
        }
    }

    private static class ClazzInfo {
        private Class<?> clazz;
        private Consumes consumes;
        private Map<String, Header> headers = new LinkedHashMap<String, Header>();
        private Path path;
        private Map<String, PathVariable> pathVariables = new LinkedHashMap<String, PathVariable>();
        private Produces produces;
        private Map<String, QueryParameter> queryParameters = new LinkedHashMap<String, QueryParameter>();
        private Resource resource;

        private ClazzInfo() {
        }

        public void addHeader(Header header) {
            this.headers.put(header.getName(), header);
        }

        public void addPathVariable(PathVariable pathVariable) {
            this.pathVariables.put(pathVariable.getName(), pathVariable);
        }

        public void addQueryParameter(QueryParameter queryParameter) {
            this.queryParameters.put(queryParameter.getName(), queryParameter);
        }

        public Class<?> getClazz() {
            return this.clazz;
        }

        public Consumes getConsumes() {
            return this.consumes;
        }

        public Map<String, Header> getHeadersCopy() {
            return new LinkedHashMap<String, Header>(this.headers);
        }

        public Path getPath() {
            return this.path;
        }

        public Map<String, PathVariable> getPathVariablesCopy() {
            return new LinkedHashMap<String, PathVariable>(this.pathVariables);
        }

        public Produces getProduces() {
            return this.produces;
        }

        public Map<String, QueryParameter> getQueryParametersCopy() {
            return new LinkedHashMap<String, QueryParameter>(this.queryParameters);
        }

        public Resource getResource() {
            return this.resource;
        }

        public void setClazz(Class<?> clazz) {
            this.clazz = clazz;
        }

        public void setConsumes(Consumes consumes) {
            this.consumes = consumes;
        }

        public void setPath(Path path) {
            this.path = path;
        }

        public void setProduces(Produces produces) {
            this.produces = produces;
        }

        public void setResource(Resource resource) {
            this.resource = resource;
        }
    }
}

