/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.restlet.Context;
import org.restlet.engine.util.StringUtils;
import org.restlet.ext.apispark.FirewallConfig;
import org.restlet.ext.apispark.internal.ApiSparkConfig;
import org.restlet.ext.apispark.internal.ApiSparkFilter;
import org.restlet.ext.apispark.internal.firewall.rule.FirewallRule;
import org.restlet.routing.Filter;
import org.restlet.service.Service;

public class ApiSparkService
extends Service {
    public static final String DEFAULT_AGENT_SERVICE_URL = "https://apispark.restlet.com";
    public static final String CONFIGURATION_FILE_SYSTEM_PROPERTY_KEY = "apiSparkServiceConfig";
    private boolean agentEnabled;
    private char[] agentPassword;
    private String agentServiceUrl = "https://apispark.restlet.com";
    private String agentLogin;
    private Integer agentCellId;
    private Integer agentCellVersion;
    private List<FirewallRule> firewallRules = new ArrayList<FirewallRule>();
    private boolean firewallEnabled;
    private FirewallConfig firewallConfig = new FirewallConfig(this.firewallRules);
    private boolean reverseProxyEnabled;
    private String reverseProxyTargetUrl;

    public ApiSparkService() {
        super(true);
    }

    public ApiSparkService(String agentLogin, char[] agentPassword, Integer agentCellId, Integer agentCellVersion, boolean reverseProxyEnabled, String reverseProxyTargetUrl) {
        this(DEFAULT_AGENT_SERVICE_URL, agentLogin, agentPassword, agentCellId, agentCellVersion, reverseProxyEnabled, reverseProxyTargetUrl);
    }

    public ApiSparkService(String agentServiceUrl, String agentLogin, char[] agentPassword, Integer agentCellId, Integer agentCellVersion, boolean reverseProxyEnabled, String reverseProxyTargetUrl) {
        super(true);
        this.agentPassword = agentPassword;
        this.agentServiceUrl = agentServiceUrl;
        this.agentLogin = agentLogin;
        this.agentCellId = agentCellId;
        this.agentCellVersion = agentCellVersion;
        this.reverseProxyEnabled = reverseProxyEnabled;
        this.reverseProxyTargetUrl = reverseProxyTargetUrl;
    }

    public Filter createInboundFilter(Context context) {
        ApiSparkConfig apiSparkConfig = new ApiSparkConfig();
        apiSparkConfig.setAgentCellId(this.agentCellId);
        apiSparkConfig.setAgentCellVersion(this.agentCellVersion);
        apiSparkConfig.setAgentServiceUrl(this.agentServiceUrl);
        apiSparkConfig.setAgentLogin(this.agentLogin);
        apiSparkConfig.setAgentPassword(this.agentPassword);
        apiSparkConfig.setReverseProxyEnabled(this.reverseProxyEnabled);
        apiSparkConfig.setReverseProxyTargetUrl(this.reverseProxyTargetUrl);
        return new ApiSparkFilter(context, apiSparkConfig, this.agentEnabled, this.firewallEnabled, this.firewallRules, this.firewallConfig);
    }

    public String getAgentPassword() {
        return new String(this.agentPassword);
    }

    public String getAgentServiceUrl() {
        return this.agentServiceUrl;
    }

    public String getAgentLogin() {
        return this.agentLogin;
    }

    public Integer getAgentCellId() {
        return this.agentCellId;
    }

    public Integer getAgentCellVersion() {
        return this.agentCellVersion;
    }

    public FirewallConfig getFirewallConfig() {
        return this.firewallConfig;
    }

    public String getReverseProxyTargetUrl() {
        return this.reverseProxyTargetUrl;
    }

    public boolean isAgentEnabled() {
        return this.agentEnabled;
    }

    public boolean isFirewallEnabled() {
        return this.firewallEnabled;
    }

    public boolean isReverseProxyEnabled() {
        return this.reverseProxyEnabled;
    }

    public void loadConfiguration() {
        String configurationFile = System.getProperty(CONFIGURATION_FILE_SYSTEM_PROPERTY_KEY);
        if (configurationFile == null) {
            throw new IllegalArgumentException("Agent configuration file is not set. Use system property 'apiSparkServiceConfig' to define it.");
        }
        this.loadConfiguration(new File(configurationFile));
    }

    public void loadConfiguration(File configurationFile) {
        if (configurationFile == null) {
            throw new IllegalArgumentException("APISpark configuration file is null.");
        }
        if (!configurationFile.exists()) {
            throw new IllegalArgumentException("APISpark configuration file does not exist: " + configurationFile.getAbsolutePath());
        }
        try {
            this.loadConfiguration(new FileInputStream(configurationFile));
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("APISpark configuration file error. See exception for details.", e);
        }
    }

    public void loadConfiguration(InputStream inputStream) {
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("APISpark configuration file error. See exception for details.", e);
        }
        this.agentServiceUrl = properties.getProperty("agent.serviceUrl", DEFAULT_AGENT_SERVICE_URL);
        this.agentLogin = properties.getProperty("agent.login");
        this.agentPassword = this.getRequiredProperty(properties, "agent.password").toCharArray();
        this.agentCellId = this.getRequiredIntegerProperty(properties, "agent.cellId");
        this.agentCellVersion = this.getRequiredIntegerProperty(properties, "agent.cellVersion");
        this.reverseProxyEnabled = Boolean.valueOf(this.getRequiredProperty(properties, "reverseProxy.enabled"));
        if (this.reverseProxyEnabled) {
            this.reverseProxyTargetUrl = this.getRequiredProperty(properties, "reverseProxy.targetUrl");
        }
    }

    private String getRequiredProperty(Properties properties, String key) {
        String value = properties.getProperty(key);
        if (StringUtils.isNullOrEmpty((String)value)) {
            throw new IllegalArgumentException("APISpark configuration file error. The property '" + key + "' is required");
        }
        return value;
    }

    private Integer getRequiredIntegerProperty(Properties properties, String key) {
        String value = this.getRequiredProperty(properties, key);
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("APISpark configuration file error. The property '" + key + "' should be a number", e);
        }
    }

    public void setAgentPassword(String agentPassword) {
        this.agentPassword = agentPassword != null ? agentPassword.toCharArray() : null;
    }

    public void setAgentServiceUrl(String agentServiceUrl) {
        this.agentServiceUrl = agentServiceUrl;
    }

    public void setAgentLogin(String agentLogin) {
        this.agentLogin = agentLogin;
    }

    public void setAgentCellId(Integer agentCellId) {
        this.agentCellId = agentCellId;
    }

    public void setAgentCellVersion(Integer agentCellVersion) {
        this.agentCellVersion = agentCellVersion;
    }

    public void setAgentEnabled(boolean agentEnabled) {
        this.agentEnabled = agentEnabled;
    }

    public void setFirewallEnabled(boolean firewallEnabled) {
        this.firewallEnabled = firewallEnabled;
    }

    public void setReverseProxyEnabled(boolean reverseProxyEnabled) {
        this.reverseProxyEnabled = reverseProxyEnabled;
    }

    public void setReverseProxyTargetUrl(String reverseProxyTargetUrl) {
        this.reverseProxyTargetUrl = reverseProxyTargetUrl;
    }
}

