/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark.internal;

import java.util.List;
import java.util.logging.Logger;
import org.restlet.Context;
import org.restlet.Restlet;
import org.restlet.engine.util.StringUtils;
import org.restlet.ext.apispark.FirewallConfig;
import org.restlet.ext.apispark.internal.ApiSparkConfig;
import org.restlet.ext.apispark.internal.agent.AgentConfigurationException;
import org.restlet.ext.apispark.internal.agent.bean.ModulesSettings;
import org.restlet.ext.apispark.internal.agent.module.AuthenticationModule;
import org.restlet.ext.apispark.internal.agent.module.AuthorizationModule;
import org.restlet.ext.apispark.internal.agent.module.FirewallModule;
import org.restlet.ext.apispark.internal.agent.module.ModulesSettingsModule;
import org.restlet.ext.apispark.internal.agent.module.ReverseProxyModule;
import org.restlet.ext.apispark.internal.firewall.FirewallFilter;
import org.restlet.ext.apispark.internal.firewall.rule.FirewallRule;
import org.restlet.ext.apispark.internal.utils.RestletChain;
import org.restlet.routing.Filter;

public class ApiSparkFilter
extends Filter {
    protected static Logger LOGGER = Logger.getLogger(ApiSparkFilter.class.getName());
    private Restlet agentFirstRestlet;
    private Restlet filterNext;
    private Restlet agentLastRestlet;

    public ApiSparkFilter(Context context, ApiSparkConfig apiSparkConfig, boolean agentEnabled, boolean firewallEnabled, List<FirewallRule> firewallRules, FirewallConfig firewallConfig) {
        super(context);
        boolean authenticationEnabled = false;
        RestletChain restletChain = new RestletChain();
        this.validateRedirection(apiSparkConfig);
        if (agentEnabled) {
            this.validateAgentConfiguration(apiSparkConfig);
            ModulesSettings modulesSettings = this.getAgentSettings(apiSparkConfig);
            if (modulesSettings.isAuthenticationModuleEnabled()) {
                LOGGER.info("Add authentication module");
                authenticationEnabled = true;
                restletChain.add((Restlet)new AuthenticationModule(apiSparkConfig, modulesSettings, context));
            }
            if (modulesSettings.isAuthorizationModuleEnabled()) {
                if (!modulesSettings.isAuthenticationModuleEnabled()) {
                    throw new AgentConfigurationException("The authorization module requires the authentication module which is not enabled");
                }
                LOGGER.info("Add authorization module");
                restletChain.add((Restlet)new AuthorizationModule(apiSparkConfig, modulesSettings, context));
            }
            if (modulesSettings.isFirewallModuleEnabled()) {
                firewallEnabled = true;
                FirewallModule firewallModule = new FirewallModule(apiSparkConfig, modulesSettings);
                firewallModule.updateFirewallConfig(firewallConfig);
            }
        }
        if (firewallEnabled) {
            LOGGER.info("Add firewall module");
            restletChain.add((Restlet)new FirewallFilter(context, firewallRules));
        }
        if (apiSparkConfig.isReverserProxyEnabled()) {
            LOGGER.info("Add redirection module");
            String redirectorUrl = apiSparkConfig.getReverseProxyTargetUrl() + "{rr}";
            ReverseProxyModule redirector = new ReverseProxyModule(context, redirectorUrl, authenticationEnabled);
            restletChain.add((Restlet)redirector);
        }
        if (restletChain.getFirst() == null) {
            LOGGER.warning("No modules are enabled.");
        }
        this.agentFirstRestlet = restletChain.getFirst();
        this.agentLastRestlet = restletChain.getLast();
    }

    public ModulesSettings getAgentSettings(ApiSparkConfig apiSparkConfig) {
        ModulesSettingsModule modulesSettingsModule = new ModulesSettingsModule(apiSparkConfig);
        return modulesSettingsModule.getModulesSettings();
    }

    public Restlet getNext() {
        return this.agentFirstRestlet != null ? this.agentFirstRestlet : this.filterNext;
    }

    public void setNext(Restlet next) {
        this.filterNext = next;
        if (this.agentLastRestlet != null && this.agentLastRestlet instanceof Filter) {
            Filter filter = (Filter)this.agentLastRestlet;
            filter.setNext(next);
        }
    }

    public void validateAgentConfiguration(ApiSparkConfig config) {
        if (config.getAgentCellId() == null) {
            throw new IllegalArgumentException("The cell identifier is mandatory");
        }
        if (config.getAgentCellId() == null) {
            throw new IllegalArgumentException("The cell version identifier is mandatory");
        }
        if (StringUtils.isNullOrEmpty((String)config.getAgentServiceUrl())) {
            throw new IllegalArgumentException("The agent service url is mandatory");
        }
        if (StringUtils.isNullOrEmpty((String)config.getAgentLogin())) {
            throw new IllegalArgumentException("The agent login is mandatory");
        }
        if (StringUtils.isNullOrEmpty((String)config.getAgentPassword())) {
            throw new IllegalArgumentException("The agent password key is mandatory");
        }
    }

    public void validateRedirection(ApiSparkConfig config) {
        if (config.isReverserProxyEnabled() && StringUtils.isNullOrEmpty((String)config.getReverseProxyTargetUrl())) {
            throw new IllegalArgumentException("The redirection url is mandatory when redirection is enabled");
        }
    }
}

