/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark.internal.agent.module;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.restlet.Application;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Status;
import org.restlet.ext.apispark.internal.ApiSparkConfig;
import org.restlet.ext.apispark.internal.agent.AgentException;
import org.restlet.ext.apispark.internal.agent.AgentUtils;
import org.restlet.ext.apispark.internal.agent.bean.AuthenticationSettings;
import org.restlet.ext.apispark.internal.agent.bean.Credentials;
import org.restlet.ext.apispark.internal.agent.bean.ModulesSettings;
import org.restlet.ext.apispark.internal.agent.bean.User;
import org.restlet.ext.apispark.internal.agent.resource.AuthenticationAuthenticateResource;
import org.restlet.resource.ResourceException;
import org.restlet.security.ChallengeAuthenticator;
import org.restlet.security.Role;
import org.restlet.security.Verifier;

public class AuthenticationModule
extends ChallengeAuthenticator {
    public static final String AUTHENTICATE_PATH = "/authentication/authenticate";
    protected static Logger LOGGER = Logger.getLogger(AuthenticationModule.class.getName());
    private AuthenticationAuthenticateResource authenticateClientResource;
    private AuthenticationSettings authenticationSettings = new AuthenticationSettings();
    private LoadingCache<UserIdentifier, UserInfo> userLoadingCache;

    public AuthenticationModule(ApiSparkConfig apiSparkConfig, ModulesSettings modulesSettings) {
        this(apiSparkConfig, modulesSettings, null);
    }

    public AuthenticationModule(ApiSparkConfig apiSparkConfig, ModulesSettings modulesSettings, Context context) {
        super(context, ChallengeScheme.HTTP_BASIC, "realm");
        this.authenticateClientResource = AgentUtils.getClientResource(apiSparkConfig, modulesSettings, AuthenticationAuthenticateResource.class, AUTHENTICATE_PATH);
        this.setOptional(this.authenticationSettings.isOptional());
        this.setVerifier(new AgentVerifier());
        this.initializeCache();
    }

    private void initializeCache() {
        CacheLoader<UserIdentifier, UserInfo> userLoader = new CacheLoader<UserIdentifier, UserInfo>(){

            public UserInfo load(UserIdentifier userIdentifier) {
                Credentials credentials = new Credentials(userIdentifier.getIdentifier(), userIdentifier.getSecret());
                User user = AuthenticationModule.this.authenticateClientResource.authenticate(credentials);
                if (user == null) {
                    throw new AgentException("Authentication should not return null");
                }
                return new UserInfo(user, userIdentifier.getSecret());
            }
        };
        this.userLoadingCache = CacheBuilder.newBuilder().maximumSize((long)this.authenticationSettings.getCacheSize()).expireAfterWrite(this.authenticationSettings.getCacheTimeToLiveSeconds(), TimeUnit.SECONDS).build((CacheLoader)userLoader);
    }

    private static class UserInfo {
        private char[] secret;
        private User user;

        private UserInfo(User user, char[] secret) {
            this.user = user;
            this.secret = secret;
        }

        public char[] getSecret() {
            return this.secret;
        }

        public User getUser() {
            return this.user;
        }
    }

    public static class UserIdentifier {
        private String identifier;
        private char[] secret;

        public UserIdentifier(String identifier, char[] secret) {
            this.identifier = identifier;
            this.secret = secret;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof UserIdentifier) {
                UserIdentifier userIdentifier = (UserIdentifier)obj;
                return Objects.equals(this.identifier, userIdentifier.identifier);
            }
            return false;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public char[] getSecret() {
            return this.secret;
        }

        public int hashCode() {
            return Objects.hash(this.identifier);
        }

        public void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        public void setSecret(char[] secret) {
            this.secret = secret;
        }
    }

    private class AgentVerifier
    implements Verifier {
        private AgentVerifier() {
        }

        public int verify(Request request, Response response) {
            int result;
            if (request.getChallengeResponse() == null) {
                result = 0;
            } else {
                String identifier = request.getChallengeResponse().getIdentifier();
                char[] secret = request.getChallengeResponse().getSecret();
                UserIdentifier userIdentifier = new UserIdentifier(identifier, secret);
                try {
                    UserInfo userInfo = (UserInfo)AuthenticationModule.this.userLoadingCache.getUnchecked((Object)userIdentifier);
                    if (userInfo == null) {
                        throw new AgentException("User could not be null");
                    }
                    if (!Arrays.equals(secret, userInfo.getSecret())) {
                        result = -1;
                    } else {
                        User user = userInfo.getUser();
                        org.restlet.security.User securityUser = new org.restlet.security.User(identifier, (char[])null, user.getFirstName(), user.getLastName(), user.getEmail());
                        request.getClientInfo().setUser(securityUser);
                        ArrayList<Role> securityRoles = new ArrayList<Role>();
                        Application application = Application.getCurrent();
                        if (user.getGroups() != null) {
                            for (String role : user.getGroups()) {
                                securityRoles.add(new Role(application, role));
                            }
                        }
                        request.getClientInfo().setRoles(securityRoles);
                        result = 4;
                    }
                }
                catch (UncheckedExecutionException e) {
                    if (e.getCause() instanceof ResourceException) {
                        ResourceException rex = (ResourceException)e.getCause();
                        if (Status.CLIENT_ERROR_UNAUTHORIZED.equals((Object)rex.getStatus())) {
                            response.setStatus(Status.CLIENT_ERROR_UNAUTHORIZED);
                            result = -1;
                        }
                        throw new ResourceException(Status.SERVER_ERROR_INTERNAL, "Agent service error during user authentication of user: " + identifier, (Throwable)rex);
                    }
                    throw new AgentException("Unexpected error during user authentication error of user: " + identifier, e);
                }
            }
            return result;
        }
    }
}

