/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark.internal.agent.module;

import java.util.List;
import java.util.logging.Logger;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.Status;
import org.restlet.ext.apispark.internal.ApiSparkConfig;
import org.restlet.ext.apispark.internal.agent.AgentConfigurationException;
import org.restlet.ext.apispark.internal.agent.AgentUtils;
import org.restlet.ext.apispark.internal.agent.bean.ModulesSettings;
import org.restlet.ext.apispark.internal.agent.bean.OperationAuthorization;
import org.restlet.ext.apispark.internal.agent.bean.OperationsAuthorization;
import org.restlet.ext.apispark.internal.agent.resource.AuthorizationOperationsResource;
import org.restlet.routing.Filter;
import org.restlet.routing.Router;
import org.restlet.routing.TemplateRoute;
import org.restlet.security.Role;

public class AuthorizationModule
extends Filter {
    protected static Logger LOGGER = Logger.getLogger(AuthorizationModule.class.getName());
    public static final String MODULE_PATH = "/authorization";
    public static final String OPERATIONS_AUTHORIZATIONS_PATH = "/authorization/operations";
    private Router router;

    public AuthorizationModule(ApiSparkConfig apiSparkConfig, ModulesSettings modulesSettings) {
        this(apiSparkConfig, modulesSettings, null);
    }

    public AuthorizationModule(ApiSparkConfig apiSparkConfig, ModulesSettings modulesSettings, Context context) {
        super(context);
        OperationsAuthorization operationAuthorizations;
        AuthorizationOperationsResource authorizationOperationsClientResource = AgentUtils.getClientResource(apiSparkConfig, modulesSettings, AuthorizationOperationsResource.class, OPERATIONS_AUTHORIZATIONS_PATH);
        try {
            operationAuthorizations = authorizationOperationsClientResource.getAuthorizations();
        }
        catch (Exception e) {
            throw new AgentConfigurationException("Could not get authorization module configuration from APISpark connector service", e);
        }
        this.router = new Router();
        for (OperationAuthorization operationAuthorization : operationAuthorizations) {
            this.router.attach(operationAuthorization.getPathTemplate(), (Restlet)new RestletOperationAuthorization(operationAuthorization));
        }
    }

    protected int beforeHandle(Request request, Response response) {
        TemplateRoute templateRoute = (TemplateRoute)this.router.getNext(request, response);
        if (templateRoute == null) {
            response.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
            return 2;
        }
        RestletOperationAuthorization restletOperationAuthorization = (RestletOperationAuthorization)templateRoute.getNext();
        List userRoles = request.getClientInfo().getRoles();
        boolean authorized = false;
        List<String> groupsAllowed = restletOperationAuthorization.getOperationAuthorization().getGroupsAllowed();
        for (String groupAllowed : groupsAllowed) {
            if (!this.hasRole(userRoles, groupAllowed)) continue;
            authorized = true;
            break;
        }
        if (authorized) {
            return 0;
        }
        response.setStatus(Status.CLIENT_ERROR_FORBIDDEN);
        return 2;
    }

    protected boolean hasRole(List<Role> roles, String roleName) {
        for (Role role : roles) {
            if (!role.getName().equals(roleName)) continue;
            return true;
        }
        return false;
    }

    private static class RestletOperationAuthorization
    extends Restlet {
        private OperationAuthorization operationAuthorization;

        private RestletOperationAuthorization(OperationAuthorization operationAuthorization) {
            this.operationAuthorization = operationAuthorization;
        }

        public OperationAuthorization getOperationAuthorization() {
            return this.operationAuthorization;
        }

        public void setOperationAuthorization(OperationAuthorization operationAuthorization) {
            this.operationAuthorization = operationAuthorization;
        }
    }
}

