/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark.internal.agent.module;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimaps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.restlet.ext.apispark.FirewallConfig;
import org.restlet.ext.apispark.internal.ApiSparkConfig;
import org.restlet.ext.apispark.internal.agent.AgentConfigurationException;
import org.restlet.ext.apispark.internal.agent.AgentUtils;
import org.restlet.ext.apispark.internal.agent.bean.FirewallIpFilter;
import org.restlet.ext.apispark.internal.agent.bean.FirewallRateLimit;
import org.restlet.ext.apispark.internal.agent.bean.FirewallSettings;
import org.restlet.ext.apispark.internal.agent.bean.ModulesSettings;
import org.restlet.ext.apispark.internal.agent.resource.FirewallSettingsResource;

public class FirewallModule {
    public static final String MODULE_PATH = "/firewall";
    public static final String SETTINGS_PATH = "/firewall/settings";
    FirewallSettings firewallSettings;

    public FirewallModule(ApiSparkConfig apiSparkConfig, ModulesSettings modulesSettings) {
        FirewallSettingsResource firewallSettingsClientResource = AgentUtils.getClientResource(apiSparkConfig, modulesSettings, FirewallSettingsResource.class, SETTINGS_PATH);
        try {
            this.firewallSettings = firewallSettingsClientResource.getSettings();
        }
        catch (Exception e) {
            throw new AgentConfigurationException("Could not get firewall module configuration from APISpark connector service", e);
        }
    }

    public void updateFirewallConfig(FirewallConfig firewallConfig) {
        this.addIpFilterRules(this.firewallSettings, firewallConfig);
        this.addRateLimitationRules(this.firewallSettings, firewallConfig);
    }

    private void addIpFilterRules(FirewallSettings firewallSettings, FirewallConfig firewallConfig) {
        if (firewallSettings.getIpFilters() != null) {
            for (FirewallIpFilter ipFilter : firewallSettings.getIpFilters()) {
                if (ipFilter.isWhiteList()) {
                    firewallConfig.addIpAddressesWhiteList(ipFilter.getIps());
                    continue;
                }
                firewallConfig.addIpAddressesBlackList(ipFilter.getIps());
            }
        }
    }

    private void addRateLimitationRules(FirewallSettings firewallSettings, FirewallConfig firewallConfig) {
        if (firewallSettings.getRateLimits() != null) {
            List<FirewallRateLimit> rateLimits = firewallSettings.getRateLimits();
            Map<Integer, Collection<FirewallRateLimit>> rateLimitsByPeriod = this.sortRateLimitsByPeriod(rateLimits);
            for (Integer period : rateLimitsByPeriod.keySet()) {
                HashMap<String, Integer> limitsPerRole = new HashMap<String, Integer>();
                int defaultRateLimit = Integer.MAX_VALUE;
                for (FirewallRateLimit firewallRateLimit : rateLimitsByPeriod.get(period)) {
                    if (firewallRateLimit.isDefaultRateLimit()) {
                        defaultRateLimit = firewallRateLimit.getRateLimit();
                        continue;
                    }
                    limitsPerRole.put(firewallRateLimit.getGroup(), firewallRateLimit.getRateLimit());
                }
                firewallConfig.addRolesPeriodicCounter(period, TimeUnit.SECONDS, limitsPerRole, defaultRateLimit);
            }
        }
    }

    private Map<Integer, Collection<FirewallRateLimit>> sortRateLimitsByPeriod(List<FirewallRateLimit> rateLimits) {
        ImmutableListMultimap rateLimitsByPeriod = Multimaps.index(rateLimits, (Function)new Function<FirewallRateLimit, Integer>(){

            public Integer apply(FirewallRateLimit firewallRateLimit) {
                return firewallRateLimit.getPeriod();
            }
        });
        return rateLimitsByPeriod.asMap();
    }
}

