/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark.internal.conversion.raml;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.jsonSchema.types.SimpleTypeSchema;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.raml.model.Action;
import org.raml.model.ActionType;
import org.raml.model.MimeType;
import org.raml.model.Raml;
import org.raml.model.Resource;
import org.raml.model.Response;
import org.raml.model.SecurityScheme;
import org.raml.model.parameter.QueryParameter;
import org.raml.model.parameter.UriParameter;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Status;
import org.restlet.ext.apispark.internal.conversion.TranslationException;
import org.restlet.ext.apispark.internal.conversion.raml.RamlUtils;
import org.restlet.ext.apispark.internal.introspection.util.Types;
import org.restlet.ext.apispark.internal.model.Contract;
import org.restlet.ext.apispark.internal.model.Definition;
import org.restlet.ext.apispark.internal.model.Endpoint;
import org.restlet.ext.apispark.internal.model.Operation;
import org.restlet.ext.apispark.internal.model.PathVariable;
import org.restlet.ext.apispark.internal.model.PayLoad;
import org.restlet.ext.apispark.internal.model.Property;
import org.restlet.ext.apispark.internal.model.Representation;
import org.restlet.ext.apispark.internal.utils.SampleUtils;

public abstract class RamlTranslator {
    protected static Logger LOGGER = Logger.getLogger(RamlTranslator.class.getName());

    private static PathVariable getPathVariable(String paramName, UriParameter uriParameter) {
        PathVariable pathVariable = new PathVariable();
        pathVariable.setName(paramName);
        pathVariable.setDescription(uriParameter.getDescription());
        return pathVariable;
    }

    private static List<PathVariable> getPathVariables(Resource resource) {
        ArrayList<PathVariable> pathVariables = new ArrayList<PathVariable>();
        for (Map.Entry entry : resource.getUriParameters().entrySet()) {
            pathVariables.add(RamlTranslator.getPathVariable((String)entry.getKey(), (UriParameter)entry.getValue()));
        }
        if (resource.getParentResource() != null) {
            pathVariables.addAll(RamlTranslator.getPathVariables(resource.getParentResource()));
        }
        return pathVariables;
    }

    private static Map<String, Map<String, Object>> getSamples(Contract contract) {
        HashMap<String, Map<String, Object>> samples = new HashMap<String, Map<String, Object>>();
        for (Representation representation : contract.getRepresentations()) {
            samples.put(representation.getName(), SampleUtils.getRepresentationSample(representation));
        }
        return samples;
    }

    public static Raml getRaml(Definition definition) {
        Raml raml = new Raml();
        ObjectMapper m = new ObjectMapper();
        if (definition.getVersion() != null) {
            raml.setVersion(definition.getVersion());
        }
        Contract contract = definition.getContract();
        Map<String, Map<String, Object>> representationSamples = RamlTranslator.getSamples(contract);
        Endpoint endpoint = null;
        if (!definition.getEndpoints().isEmpty()) {
            endpoint = definition.getEndpoints().get(0);
            raml.setBaseUri(endpoint.computeUrl());
        } else {
            raml.setBaseUri("http://example.com/v1");
        }
        raml.setSecuritySchemes(new ArrayList());
        HashMap<String, SecurityScheme> securitySchemes = new HashMap<String, SecurityScheme>();
        SecurityScheme securityScheme = new SecurityScheme();
        if (endpoint != null) {
            if (ChallengeScheme.HTTP_BASIC.equals((Object)endpoint.getAuthenticationProtocol())) {
                securityScheme.setType(ChallengeScheme.HTTP_BASIC.getName());
                securitySchemes.put(ChallengeScheme.HTTP_BASIC.getName(), securityScheme);
            } else if (ChallengeScheme.HTTP_OAUTH.equals((Object)endpoint.getAuthenticationProtocol()) || ChallengeScheme.HTTP_OAUTH_BEARER.equals((Object)endpoint.getAuthenticationProtocol()) || ChallengeScheme.HTTP_OAUTH_MAC.equals((Object)endpoint.getAuthenticationProtocol())) {
                securityScheme.setType("Oauth 2.0");
                securitySchemes.put("oauth_2_0", securityScheme);
            } else if (ChallengeScheme.HTTP_DIGEST.equals((Object)endpoint.getAuthenticationProtocol())) {
                securityScheme.setType(ChallengeScheme.HTTP_DIGEST.getName());
                securitySchemes.put(ChallengeScheme.HTTP_DIGEST.getName(), securityScheme);
            } else if (ChallengeScheme.CUSTOM.equals((Object)endpoint.getAuthenticationProtocol())) {
                securityScheme.setType(ChallengeScheme.CUSTOM.getName());
                securitySchemes.put(ChallengeScheme.CUSTOM.getName(), securityScheme);
            }
            raml.getSecuritySchemes().add(securitySchemes);
        }
        raml.setTitle(contract.getName());
        raml.setResources(new HashMap());
        ArrayList<String> paths = new ArrayList<String>();
        for (org.restlet.ext.apispark.internal.model.Resource resource : contract.getResources()) {
            Resource ramlResource = new Resource();
            if (resource.getName() != null) {
                ramlResource.setDisplayName(resource.getName());
            } else {
                ramlResource.setDisplayName(RamlUtils.processResourceName(resource.getResourcePath()));
            }
            ramlResource.setDescription(resource.getDescription());
            ramlResource.setParentUri("");
            ramlResource.setRelativeUri(resource.getResourcePath());
            UriParameter uiParam = new UriParameter();
            ramlResource.setUriParameters(new HashMap());
            for (PathVariable pathVariable : resource.getPathVariables()) {
                uiParam.setDisplayName(pathVariable.getName());
                uiParam.setDescription(pathVariable.getDescription());
                uiParam.setType(RamlUtils.getParamType(pathVariable.getType()));
                uiParam.setExample(pathVariable.getExample());
                ramlResource.getUriParameters().put(pathVariable.getName(), uiParam);
            }
            ramlResource.setActions(new HashMap());
            for (Operation operation : resource.getOperations()) {
                Action action = new Action();
                action.setDescription(operation.getDescription());
                action.setResource(ramlResource);
                MimeType ramlInRepresentation = new MimeType();
                if (operation.getInputPayLoad() != null) {
                    ramlInRepresentation.setType(operation.getInputPayLoad().getType());
                    if (RamlUtils.isPrimitiveType(operation.getInputPayLoad().getType())) {
                        Property inRepresentationPrimitive = new Property();
                        inRepresentationPrimitive.setName("");
                        inRepresentationPrimitive.setType(operation.getInputPayLoad().getType());
                        SimpleTypeSchema inRepresentationSchema = RamlUtils.generatePrimitiveSchema(inRepresentationPrimitive);
                        try {
                            ramlInRepresentation.setSchema(m.writeValueAsString((Object)inRepresentationSchema));
                        }
                        catch (JsonProcessingException e) {
                            LOGGER.log(Level.WARNING, "Error when setting mime type schema.", e);
                        }
                    } else {
                        ramlInRepresentation.setSchema(operation.getInputPayLoad().getType());
                    }
                    action.setBody(new HashMap());
                    for (String mediaType : operation.getConsumes()) {
                        MimeType ramlInRepresentationWithMediaType = new MimeType();
                        ramlInRepresentationWithMediaType.setSchema(ramlInRepresentation.getSchema());
                        try {
                            ramlInRepresentationWithMediaType.setExample(RamlTranslator.getExampleFromPayLoad(operation.getInputPayLoad(), representationSamples, mediaType));
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.WARNING, "Error when writting sample.", e);
                        }
                        action.getBody().put(mediaType, ramlInRepresentationWithMediaType);
                    }
                }
                action.setQueryParameters(new HashMap());
                for (org.restlet.ext.apispark.internal.model.QueryParameter queryParameter : operation.getQueryParameters()) {
                    QueryParameter ramlQueryParameter = new QueryParameter();
                    ramlQueryParameter.setDisplayName(queryParameter.getName());
                    ramlQueryParameter.setDescription(queryParameter.getDescription());
                    ramlQueryParameter.setRequired(queryParameter.isRequired());
                    ramlQueryParameter.setExample(queryParameter.getExample());
                    ramlQueryParameter.setDefaultValue(queryParameter.getDefaultValue());
                    ramlQueryParameter.setRepeat(queryParameter.isAllowMultiple());
                    action.getQueryParameters().put(queryParameter.getName(), ramlQueryParameter);
                }
                Response ramlResponse = new Response();
                action.setResponses(new HashMap());
                for (org.restlet.ext.apispark.internal.model.Response response : operation.getResponses()) {
                    ramlResponse = new Response();
                    ramlResponse.setDescription(response.getDescription());
                    ramlResponse.setBody(new HashMap());
                    MimeType ramlOutRepresentation = new MimeType();
                    if (Status.isSuccess((int)response.getCode()) && response.getOutputPayLoad() != null && response.getOutputPayLoad().getType() != null) {
                        if (RamlUtils.isPrimitiveType(response.getOutputPayLoad().getType())) {
                            Property outRepresentationPrimitive = new Property();
                            outRepresentationPrimitive.setName("");
                            outRepresentationPrimitive.setType(response.getOutputPayLoad().getType());
                            SimpleTypeSchema outRepresentationSchema = RamlUtils.generatePrimitiveSchema(outRepresentationPrimitive);
                            try {
                                ramlOutRepresentation.setSchema(m.writeValueAsString((Object)outRepresentationSchema));
                            }
                            catch (JsonProcessingException e) {
                                LOGGER.log(Level.WARNING, "Error when setting mime type schema.", e);
                            }
                        } else {
                            ramlOutRepresentation.setSchema(response.getOutputPayLoad().getType());
                        }
                    }
                    if (response.getOutputPayLoad() != null) {
                        for (String mediaType : operation.getProduces()) {
                            MimeType ramlOutRepresentationWithMediaType = new MimeType();
                            ramlOutRepresentationWithMediaType.setSchema(ramlOutRepresentation.getSchema());
                            try {
                                ramlOutRepresentationWithMediaType.setExample(RamlTranslator.getExampleFromPayLoad(response.getOutputPayLoad(), representationSamples, mediaType));
                            }
                            catch (Exception e) {
                                LOGGER.log(Level.WARNING, "Error when writting sample.", e);
                            }
                            ramlResponse.getBody().put(mediaType, ramlOutRepresentationWithMediaType);
                        }
                    }
                    action.getResponses().put(Integer.toString(response.getCode()), ramlResponse);
                }
                ramlResource.getActions().put(RamlUtils.getActionType(operation.getMethod()), action);
            }
            paths.add(resource.getResourcePath());
            raml.getResources().put(ramlResource.getRelativeUri(), ramlResource);
        }
        raml.setSchemas(new ArrayList());
        HashMap<String, String> schemas = new HashMap<String, String>();
        raml.getSchemas().add(schemas);
        for (Representation representation : contract.getRepresentations()) {
            if (RamlUtils.isPrimitiveType(representation.getName())) continue;
            try {
                schemas.put(representation.getName(), m.writeValueAsString((Object)RamlUtils.generateSchema(representation)));
            }
            catch (JsonProcessingException e) {
                LOGGER.log(Level.WARNING, "Error when putting mime type schema for representation: " + representation.getName(), e);
            }
        }
        return raml;
    }

    public static Representation getRepresentationByName(List<Representation> representations, String name) {
        if (name != null) {
            for (Representation repr : representations) {
                if (!name.equals(repr.getName())) continue;
                return repr;
            }
        }
        return null;
    }

    private static List<org.restlet.ext.apispark.internal.model.Resource> getResource(String resourceName, Resource resource, List<PathVariable> rootPathVariables) {
        ArrayList<org.restlet.ext.apispark.internal.model.Resource> rwadResources = new ArrayList<org.restlet.ext.apispark.internal.model.Resource>();
        org.restlet.ext.apispark.internal.model.Resource rwadResource = new org.restlet.ext.apispark.internal.model.Resource();
        rwadResource.setDescription(resource.getDescription());
        rwadResource.setName(resourceName);
        rwadResource.setResourcePath(resource.getUri());
        rwadResource.setPathVariables(RamlTranslator.getPathVariables(resource));
        rwadResource.getPathVariables().addAll(rootPathVariables);
        for (Map.Entry entry : resource.getActions().entrySet()) {
            Action action = (Action)entry.getValue();
            Operation operation = new Operation();
            operation.setDescription(action.getDescription());
            operation.setMethod(((ActionType)entry.getKey()).name().toString());
        }
        rwadResources.add(rwadResource);
        for (Map.Entry entry : resource.getResources().entrySet()) {
            rwadResources.addAll(RamlTranslator.getResource(RamlUtils.processResourceName(((Resource)entry.getValue()).getUri()), (Resource)entry.getValue(), rootPathVariables));
        }
        return rwadResources;
    }

    public static Definition translate(Raml raml) throws TranslationException {
        Definition definition = new Definition();
        if (raml.getVersion() != null) {
            definition.setVersion(raml.getVersion().substring(1));
        }
        Contract contract = new Contract();
        definition.setContract(contract);
        contract.setName(raml.getTitle());
        ArrayList<PathVariable> rootPathVariables = new ArrayList<PathVariable>();
        for (Map.Entry entry : raml.getBaseUriParameters().entrySet()) {
            rootPathVariables.add(RamlTranslator.getPathVariable((String)entry.getKey(), (UriParameter)entry.getValue()));
        }
        for (Map schema : raml.getSchemas()) {
            for (Map.Entry entry : schema.entrySet()) {
                Representation representation = new Representation();
                representation.setName((String)entry.getKey());
                representation.setDescription((String)entry.getValue());
                contract.getRepresentations().add(representation);
            }
        }
        for (Map.Entry entry : raml.getResources().entrySet()) {
            Resource resource = (Resource)entry.getValue();
            contract.getResources().addAll(RamlTranslator.getResource(RamlUtils.processResourceName(resource.getUri()), resource, rootPathVariables));
        }
        return definition;
    }

    private static String getExampleFromPayLoad(PayLoad payLoad, Map<String, Map<String, Object>> representationSamples, String mediaType) {
        if (Types.isPrimitiveType(payLoad.getType())) {
            Object sample = SampleUtils.getPropertyDefaultSampleValue(payLoad.getType(), "value");
            return sample == null ? null : sample.toString();
        }
        Object sample = representationSamples.get(payLoad.getType());
        if (payLoad.isArray()) {
            sample = Arrays.asList(sample);
        }
        return SampleUtils.convertSampleAccordingToMediaType(sample, mediaType, payLoad.getType());
    }

    private RamlTranslator() {
    }
}

