/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark.internal.conversion.swagger.v1_2;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Status;
import org.restlet.ext.apispark.internal.conversion.TranslationException;
import org.restlet.ext.apispark.internal.conversion.swagger.v1_2.SwaggerTypeFormat;
import org.restlet.ext.apispark.internal.conversion.swagger.v1_2.SwaggerTypes;
import org.restlet.ext.apispark.internal.conversion.swagger.v1_2.model.ApiDeclaration;
import org.restlet.ext.apispark.internal.conversion.swagger.v1_2.model.ApiInfo;
import org.restlet.ext.apispark.internal.conversion.swagger.v1_2.model.AuthorizationsDeclaration;
import org.restlet.ext.apispark.internal.conversion.swagger.v1_2.model.BasicAuthorizationDeclaration;
import org.restlet.ext.apispark.internal.conversion.swagger.v1_2.model.ItemsDeclaration;
import org.restlet.ext.apispark.internal.conversion.swagger.v1_2.model.ModelDeclaration;
import org.restlet.ext.apispark.internal.conversion.swagger.v1_2.model.OAuth2AuthorizationDeclaration;
import org.restlet.ext.apispark.internal.conversion.swagger.v1_2.model.ResourceDeclaration;
import org.restlet.ext.apispark.internal.conversion.swagger.v1_2.model.ResourceListing;
import org.restlet.ext.apispark.internal.conversion.swagger.v1_2.model.ResourceListingApi;
import org.restlet.ext.apispark.internal.conversion.swagger.v1_2.model.ResourceOperationDeclaration;
import org.restlet.ext.apispark.internal.conversion.swagger.v1_2.model.ResourceOperationParameterDeclaration;
import org.restlet.ext.apispark.internal.conversion.swagger.v1_2.model.ResponseMessageDeclaration;
import org.restlet.ext.apispark.internal.conversion.swagger.v1_2.model.TypePropertyDeclaration;
import org.restlet.ext.apispark.internal.introspection.util.Types;
import org.restlet.ext.apispark.internal.model.Contact;
import org.restlet.ext.apispark.internal.model.Contract;
import org.restlet.ext.apispark.internal.model.Definition;
import org.restlet.ext.apispark.internal.model.Endpoint;
import org.restlet.ext.apispark.internal.model.License;
import org.restlet.ext.apispark.internal.model.Operation;
import org.restlet.ext.apispark.internal.model.PathVariable;
import org.restlet.ext.apispark.internal.model.PayLoad;
import org.restlet.ext.apispark.internal.model.Property;
import org.restlet.ext.apispark.internal.model.QueryParameter;
import org.restlet.ext.apispark.internal.model.Representation;
import org.restlet.ext.apispark.internal.model.Resource;
import org.restlet.ext.apispark.internal.model.Response;
import org.restlet.ext.apispark.internal.model.Section;
import org.restlet.ext.apispark.internal.reflect.ReflectUtils;

public abstract class SwaggerTranslator {
    protected static Logger LOGGER = Logger.getLogger(SwaggerTranslator.class.getName());
    public static final String SWAGGER_VERSION = "1.2";

    private static void fillApiDeclarationInRepresentation(Operation operation, ResourceOperationDeclaration rod, Contract contract, Collection<String> usedModels) {
        PayLoad inRepr = operation.getInputPayLoad();
        if (inRepr != null) {
            Representation representation = contract.getRepresentation(inRepr.getType());
            ResourceOperationParameterDeclaration ropd = new ResourceOperationParameterDeclaration();
            ropd.setParamType("body");
            ropd.setName("body");
            ropd.setRequired(true);
            ropd.setType(inRepr.getType());
            if (representation != null) {
                usedModels.add(inRepr.getType());
            }
            rod.getParameters().add(ropd);
        }
    }

    private static void fillApiDeclarationMainAttributes(Definition definition, ApiDeclaration apiDeclaration, String sectionName) {
        Endpoint endpoint;
        apiDeclaration.setApiVersion(definition.getVersion());
        if (!definition.getEndpoints().isEmpty()) {
            endpoint = definition.getEndpoints().get(0);
            apiDeclaration.setBasePath(endpoint.computeUrl());
        } else {
            endpoint = new Endpoint("http://example.com");
        }
        AuthorizationsDeclaration authorizations = new AuthorizationsDeclaration();
        if (ChallengeScheme.HTTP_BASIC.getName().equals(endpoint.getAuthenticationProtocol())) {
            authorizations.setBasicAuth(new BasicAuthorizationDeclaration());
            apiDeclaration.setAuthorizations(authorizations);
        } else if (ChallengeScheme.HTTP_OAUTH.getName().equals(endpoint.getAuthenticationProtocol()) || ChallengeScheme.HTTP_OAUTH_BEARER.getName().equals(endpoint.getAuthenticationProtocol()) || ChallengeScheme.HTTP_OAUTH_MAC.getName().equals(endpoint.getAuthenticationProtocol())) {
            authorizations.setOauth2(new OAuth2AuthorizationDeclaration());
        }
        apiDeclaration.setInfo(new ApiInfo());
        apiDeclaration.setSwaggerVersion(SWAGGER_VERSION);
        apiDeclaration.setResourcePath("/" + sectionName);
    }

    private static void fillApiDeclarationOperations(Resource resource, Contract contract, Collection<String> usedModels, ResourceDeclaration rd) {
        for (Operation operation : resource.getOperations()) {
            ResourceOperationDeclaration rod = new ResourceOperationDeclaration();
            rod.setMethod(operation.getMethod());
            rod.setSummary(operation.getDescription());
            rod.setNickname(operation.getName());
            rod.setProduces(operation.getProduces());
            rod.setConsumes(operation.getConsumes());
            SwaggerTranslator.fillApiDeclarationPathVariables(resource, rod);
            SwaggerTranslator.fillApiDeclarationQueryParameters(operation, rod);
            SwaggerTranslator.fillApiDeclarationInRepresentation(operation, rod, contract, usedModels);
            SwaggerTranslator.fillApiDeclarationOutRepresentation(operation, rod, contract, usedModels);
            SwaggerTranslator.fillApiDeclarationResponses(operation, usedModels, rod);
            rd.getOperations().add(rod);
        }
    }

    private static void fillApiDeclarationOutRepresentation(Operation operation, ResourceOperationDeclaration rod, Contract contract, Collection<String> usedModels) {
        PayLoad outRepr = null;
        for (Response response : operation.getResponses()) {
            if (!Status.isSuccess((int)response.getCode())) continue;
            outRepr = response.getOutputPayLoad();
        }
        if (outRepr != null && outRepr.getType() != null) {
            if (outRepr.isArray()) {
                rod.setType("array");
                if (!Types.isPrimitiveType(outRepr.getType())) {
                    rod.getItems().setRef(outRepr.getType());
                }
            } else {
                rod.setType(outRepr.getType());
            }
            usedModels.add(outRepr.getType());
        } else {
            rod.setType("void");
        }
    }

    private static void fillApiDeclarationPathVariables(Resource resource, ResourceOperationDeclaration rod) {
        for (PathVariable pv : resource.getPathVariables()) {
            ResourceOperationParameterDeclaration ropd = new ResourceOperationParameterDeclaration();
            ropd.setParamType("path");
            SwaggerTypeFormat swaggerTypeFormat = SwaggerTypes.toSwaggerType(pv.getType());
            ropd.setType(swaggerTypeFormat.getType());
            ropd.setFormat(swaggerTypeFormat.getFormat());
            ropd.setRequired(true);
            ropd.setName(pv.getName());
            ropd.setAllowMultiple(false);
            ropd.setDescription(pv.getDescription());
            rod.getParameters().add(ropd);
        }
    }

    private static void fillApiDeclarationQueryParameters(Operation operation, ResourceOperationDeclaration rod) {
        for (QueryParameter qp : operation.getQueryParameters()) {
            ResourceOperationParameterDeclaration ropd = new ResourceOperationParameterDeclaration();
            ropd.setParamType("query");
            SwaggerTypeFormat swaggerTypeFormat = SwaggerTypes.toSwaggerType(qp.getType());
            ropd.setType(swaggerTypeFormat.getType());
            ropd.setFormat(swaggerTypeFormat.getFormat());
            ropd.setName(qp.getName());
            ropd.setAllowMultiple(true);
            ropd.setDescription(qp.getDescription());
            ropd.setEnum_(qp.getEnumeration());
            ropd.setDefaultValue(qp.getDefaultValue());
            rod.getParameters().add(ropd);
        }
    }

    private static void fillApiDeclarationRepresentations(Definition definition, ApiDeclaration apiDeclaration, Collection<String> usedModels) {
        Contract contract = definition.getContract();
        apiDeclaration.setModels(new TreeMap<String, ModelDeclaration>());
        ArrayList<String> usedModelsList = new ArrayList<String>(usedModels);
        for (int i = 0; i < usedModelsList.size(); ++i) {
            String model = (String)usedModelsList.get(i);
            Representation repr = contract.getRepresentation(model);
            if (repr == null || Types.isPrimitiveType(model)) continue;
            ModelDeclaration md = new ModelDeclaration();
            md.setId(model);
            md.setDescription(repr.getDescription());
            for (Property prop : repr.getProperties()) {
                SwaggerTypeFormat swaggerTypeFormat;
                if (prop.getMinOccurs() > 0) {
                    md.getRequired().add(prop.getName());
                }
                if (!Types.isPrimitiveType(prop.getType()) && !usedModelsList.contains(prop.getType())) {
                    usedModelsList.add(prop.getType());
                }
                TypePropertyDeclaration tpd = new TypePropertyDeclaration();
                tpd.setDescription(prop.getDescription());
                tpd.setEnum_(prop.getEnumeration());
                if (prop.getMaxOccurs() > 1 || prop.getMaxOccurs() == -1) {
                    tpd.setType("array");
                    tpd.setItems(new ItemsDeclaration());
                    if (Types.isPrimitiveType(prop.getType())) {
                        swaggerTypeFormat = SwaggerTypes.toSwaggerType(prop.getType());
                        tpd.getItems().setType(swaggerTypeFormat.getType());
                        tpd.setFormat(swaggerTypeFormat.getFormat());
                    } else {
                        tpd.getItems().setRef(prop.getType());
                    }
                } else if (Types.isPrimitiveType(prop.getType())) {
                    swaggerTypeFormat = SwaggerTypes.toSwaggerType(prop.getType());
                    tpd.setType(swaggerTypeFormat.getType());
                    tpd.setFormat(swaggerTypeFormat.getFormat());
                } else {
                    tpd.setRef(prop.getType());
                }
                tpd.setMaximum(prop.getMax());
                tpd.setMinimum(prop.getMin());
                tpd.setUniqueItems(prop.isUniqueItems());
                md.getProperties().put(prop.getName(), tpd);
            }
            apiDeclaration.getModels().put(md.getId(), md);
        }
    }

    private static Collection<String> fillApiDeclarationResources(Definition definition, ApiDeclaration apiDeclaration, String sectionName) {
        HashSet<String> usedModels = new HashSet<String>();
        Contract contract = definition.getContract();
        ArrayList<Resource> resources = new ArrayList<Resource>();
        boolean allResources = contract.getSections().isEmpty();
        for (Resource resource : contract.getResources()) {
            if (allResources) {
                resources.add(resource);
                continue;
            }
            if (!resource.getSections().contains(sectionName)) continue;
            resources.add(resource);
        }
        for (Resource resource : resources) {
            if (allResources && !resource.getResourcePath().startsWith("/" + sectionName)) continue;
            ResourceDeclaration rd = new ResourceDeclaration();
            rd.setPath(resource.getResourcePath());
            rd.setDescription(resource.getDescription());
            SwaggerTranslator.fillApiDeclarationOperations(resource, contract, usedModels, rd);
            apiDeclaration.getApis().add(rd);
        }
        Collections.sort(apiDeclaration.getApis(), new Comparator<ResourceDeclaration>(){

            @Override
            public int compare(ResourceDeclaration o1, ResourceDeclaration o2) {
                return o1.getPath().compareTo(o2.getPath());
            }
        });
        return usedModels;
    }

    private static void fillApiDeclarationResponses(Operation operation, Collection<String> usedModels, ResourceOperationDeclaration rod) {
        for (Response response : operation.getResponses()) {
            if (Status.isSuccess((int)response.getCode())) continue;
            ResponseMessageDeclaration rmd = new ResponseMessageDeclaration();
            rmd.setCode(response.getCode());
            rmd.setMessage(response.getMessage());
            if (response.getOutputPayLoad() != null) {
                rmd.setResponseModel(response.getOutputPayLoad().getType());
                usedModels.add(response.getOutputPayLoad().getType());
            }
            rod.getResponseMessages().add(rmd);
        }
    }

    private static void fillContract(Contract contract, ResourceListing listing, Map<String, ApiDeclaration> apiDeclarations) {
        ArrayList<String> declaredTypes = new ArrayList<String>();
        for (Map.Entry<String, ApiDeclaration> entry : apiDeclarations.entrySet()) {
            ApiDeclaration apiDeclaration = entry.getValue();
            Section section = new Section();
            if (entry.getKey().startsWith("/")) {
                section.setName(entry.getKey().substring(1));
            } else {
                section.setName(entry.getKey());
            }
            section.setDescription(listing.getApi(entry.getKey()).getDescription());
            contract.getSections().add(section);
            for (ResourceDeclaration api : apiDeclaration.getApis()) {
                Resource resource = new Resource();
                resource.setResourcePath(api.getPath());
                ArrayList<String> declaredPathVariables = new ArrayList<String>();
                SwaggerTranslator.fillOperations(resource, apiDeclaration, api, contract, section, declaredPathVariables, declaredTypes);
                resource.getSections().add(section.getName());
                contract.getResources().add(resource);
                LOGGER.log(Level.FINE, "Resource " + api.getPath() + " added.");
            }
        }
    }

    private static void fillContract(Contract contract, ApiDeclaration apiDeclaration) {
        ArrayList<String> declaredTypes = new ArrayList<String>();
        Section section = new Section();
        if (apiDeclaration.getResourcePath().startsWith("/")) {
            section.setName(apiDeclaration.getResourcePath().substring(1));
        } else {
            section.setName(apiDeclaration.getResourcePath());
        }
        contract.getSections().add(section);
        for (ResourceDeclaration api : apiDeclaration.getApis()) {
            Resource resource = new Resource();
            resource.setResourcePath(api.getPath());
            ArrayList<String> declaredPathVariables = new ArrayList<String>();
            SwaggerTranslator.fillOperations(resource, apiDeclaration, api, contract, section, declaredPathVariables, declaredTypes);
            resource.getSections().add(section.getName());
            contract.getResources().add(resource);
            LOGGER.log(Level.FINE, "Resource " + api.getPath() + " added.");
        }
    }

    private static void fillMainAttributes(Definition definition, ResourceListing listing, String basePath) {
        definition.setVersion(listing.getApiVersion());
        Contact contact = new Contact();
        contact.setEmail(listing.getInfo().getContact());
        definition.setContact(contact);
        License license = new License();
        license.setUrl(listing.getInfo().getLicenseUrl());
        definition.setLicense(license);
        Contract contract = new Contract();
        contract.setName(listing.getInfo().getTitle());
        LOGGER.log(Level.FINE, "Contract " + contract.getName() + " added.");
        contract.setDescription(listing.getInfo().getDescription());
        definition.setContract(contract);
        if (definition.getEndpoints().isEmpty()) {
            Endpoint endpoint = new Endpoint(basePath);
            definition.getEndpoints().add(endpoint);
            if (listing.getAuthorizations().getBasicAuth() != null) {
                endpoint.setAuthenticationProtocol(ChallengeScheme.HTTP_BASIC.getName());
            } else if (listing.getAuthorizations().getOauth2() != null) {
                endpoint.setAuthenticationProtocol(ChallengeScheme.HTTP_OAUTH.getName());
            } else if (listing.getAuthorizations().getApiKey() != null) {
                endpoint.setAuthenticationProtocol(ChallengeScheme.CUSTOM.getName());
            }
        }
    }

    private static void fillOperations(Resource resource, ApiDeclaration apiDeclaration, ResourceDeclaration api, Contract contract, Section section, List<String> declaredPathVariables, List<String> declaredTypes) {
        List<String> apiProduces = apiDeclaration.getProduces();
        List<String> apiConsumes = apiDeclaration.getConsumes();
        HashMap<String, List<String>> subtypes = new HashMap<String, List<String>>();
        for (ResourceOperationDeclaration swaggerOperation : api.getOperations()) {
            String methodName = swaggerOperation.getMethod();
            Operation operation = new Operation();
            operation.setMethod(swaggerOperation.getMethod());
            operation.setName(swaggerOperation.getNickname());
            operation.setDescription(swaggerOperation.getSummary());
            SwaggerTranslator.fillVariants(contract, section, operation, swaggerOperation, apiProduces, apiConsumes);
            Response success = new Response();
            success.setCode(Status.SUCCESS_OK.getCode());
            success.setDescription("Success");
            success.setMessage(Status.SUCCESS_OK.getDescription());
            success.setName("Success");
            SwaggerTranslator.fillOutPayLoad(success, swaggerOperation);
            operation.getResponses().add(success);
            SwaggerTranslator.fillParameters(resource, operation, swaggerOperation, declaredPathVariables);
            SwaggerTranslator.fillResponseMessages(operation, swaggerOperation);
            resource.getOperations().add(operation);
            LOGGER.log(Level.FINE, "Method " + methodName + " added.");
            SwaggerTranslator.fillRepresentations(contract, section, apiDeclaration, subtypes, declaredTypes);
            for (Map.Entry subtypesPair : subtypes.entrySet()) {
                List subtypesOf = (List)subtypesPair.getValue();
                for (String subtypeOf : subtypesOf) {
                    Representation representation = contract.getRepresentation(subtypeOf);
                    representation.setExtendedType((String)subtypesPair.getKey());
                }
            }
        }
    }

    private static void fillOutPayLoad(Response success, ResourceOperationDeclaration swaggerOperation) {
        PayLoad rwadOutRepr = new PayLoad();
        if ("array".equals(swaggerOperation.getType())) {
            LOGGER.log(Level.FINER, "Operation: " + swaggerOperation.getNickname() + " returns an array");
            rwadOutRepr.setArray(true);
            if (swaggerOperation.getItems().getType() != null) {
                rwadOutRepr.setType(swaggerOperation.getItems().getType());
            } else {
                rwadOutRepr.setType(swaggerOperation.getItems().getRef());
            }
        } else {
            LOGGER.log(Level.FINER, "Operation: " + swaggerOperation.getNickname() + " returns a single Representation");
            rwadOutRepr.setArray(false);
            if (swaggerOperation.getType() != null) {
                rwadOutRepr.setType(swaggerOperation.getType());
            } else {
                rwadOutRepr.setType(swaggerOperation.getRef());
            }
        }
        success.setOutputPayLoad(rwadOutRepr);
    }

    private static void fillParameters(Resource resource, Operation operation, ResourceOperationDeclaration swaggerOperation, List<String> declaredPathVariables) {
        for (ResourceOperationParameterDeclaration param : swaggerOperation.getParameters()) {
            if ("path".equals(param.getParamType())) {
                if (declaredPathVariables.contains(param.getName())) continue;
                declaredPathVariables.add(param.getName());
                PathVariable pathVariable = SwaggerTranslator.toPathVariable(param);
                resource.getPathVariables().add(pathVariable);
                continue;
            }
            if ("body".equals(param.getParamType())) {
                if (operation.getInputPayLoad() != null) continue;
                PayLoad rwadInRepr = SwaggerTranslator.toEntity(param);
                operation.setInputPayLoad(rwadInRepr);
                continue;
            }
            if (!"query".equals(param.getParamType())) continue;
            QueryParameter rwadQueryParam = SwaggerTranslator.toQueryParameter(param);
            operation.getQueryParameters().add(rwadQueryParam);
        }
    }

    private static void fillRepresentations(Contract contract, Section section, ApiDeclaration apiDeclaration, Map<String, List<String>> subtypes, List<String> declaredTypes) {
        for (Map.Entry<String, ModelDeclaration> modelEntry : apiDeclaration.getModels().entrySet()) {
            ModelDeclaration model = modelEntry.getValue();
            if (model.getSubTypes() != null && !model.getSubTypes().isEmpty()) {
                subtypes.put(model.getId(), model.getSubTypes());
            }
            if (declaredTypes.contains(modelEntry.getKey())) continue;
            declaredTypes.add(modelEntry.getKey());
            Representation representation = SwaggerTranslator.toRepresentation(model, modelEntry.getKey());
            representation.getSections().add(section.getName());
            contract.getRepresentations().add(representation);
            LOGGER.log(Level.FINE, "Representation " + modelEntry.getKey() + " added.");
        }
    }

    private static void fillResourceListingApis(Definition definition, ResourceListing listing) {
        Contract contract = definition.getContract();
        boolean allResources = contract.getSections().isEmpty();
        ArrayList<String> addedApis = new ArrayList<String>();
        if (definition.getContract() != null && contract.getResources() != null) {
            listing.setApis(new ArrayList<ResourceListingApi>());
            for (Resource resource : contract.getResources()) {
                if (allResources) {
                    ResourceListingApi rd = new ResourceListingApi();
                    rd.setDescription(resource.getDescription());
                    rd.setPath(ReflectUtils.getFirstSegment(resource.getResourcePath()));
                    if (addedApis.contains(rd.getPath())) continue;
                    addedApis.add(rd.getPath());
                    listing.getApis().add(rd);
                    continue;
                }
                for (String sectionName : resource.getSections()) {
                    Section section = contract.getSection(sectionName);
                    ResourceListingApi rd = new ResourceListingApi();
                    rd.setDescription(section.getDescription());
                    rd.setPath("/" + sectionName);
                    if (addedApis.contains(rd.getPath())) continue;
                    addedApis.add(rd.getPath());
                    listing.getApis().add(rd);
                }
            }
        }
        Collections.sort(listing.getApis(), new Comparator<ResourceListingApi>(){

            @Override
            public int compare(ResourceListingApi o1, ResourceListingApi o2) {
                return o1.getPath().compareTo(o2.getPath());
            }
        });
    }

    private static void fillResourceListingMainAttributes(Definition definition, ResourceListing listing) {
        String authenticationProtocol;
        listing.setApiVersion(definition.getVersion());
        listing.setInfo(new ApiInfo());
        listing.setSwaggerVersion(SWAGGER_VERSION);
        if (definition.getContact() != null) {
            listing.getInfo().setContact(definition.getContact().getEmail());
        }
        if (definition.getLicense() != null) {
            listing.getInfo().setLicenseUrl(definition.getLicense().getUrl());
        }
        if (definition.getContract() != null) {
            listing.getInfo().setTitle(definition.getContract().getName());
            listing.getInfo().setDescription(definition.getContract().getDescription());
        }
        if (!definition.getEndpoints().isEmpty() && (authenticationProtocol = definition.getEndpoints().get(0).getAuthenticationProtocol()) != null) {
            AuthorizationsDeclaration authorizations = new AuthorizationsDeclaration();
            if (ChallengeScheme.HTTP_BASIC.getName().equals(authenticationProtocol)) {
                authorizations.setBasicAuth(new BasicAuthorizationDeclaration());
                listing.setAuthorizations(authorizations);
            } else if (ChallengeScheme.HTTP_OAUTH.getName().equals(authenticationProtocol) || ChallengeScheme.HTTP_OAUTH_BEARER.getName().equals(authenticationProtocol) || ChallengeScheme.HTTP_OAUTH_MAC.getName().equals(authenticationProtocol)) {
                authorizations.setOauth2(new OAuth2AuthorizationDeclaration());
            }
        }
    }

    private static void fillResponseMessages(Operation operation, ResourceOperationDeclaration swaggerOperation) {
        if (swaggerOperation.getResponseMessages() != null) {
            for (ResponseMessageDeclaration swagResponse : swaggerOperation.getResponseMessages()) {
                Response response = new Response();
                PayLoad outputPayLoad = new PayLoad();
                outputPayLoad.setType(swagResponse.getResponseModel());
                response.setOutputPayLoad(outputPayLoad);
                response.setName("Error " + swagResponse.getCode());
                response.setCode(swagResponse.getCode());
                response.setMessage(swagResponse.getMessage());
                operation.getResponses().add(response);
            }
        }
    }

    private static void fillVariants(Contract contract, Section section, Operation operation, ResourceOperationDeclaration swaggerOperation, List<String> apiProduces, List<String> apiConsumes) {
        for (String produced : apiProduces.isEmpty() ? swaggerOperation.getProduces() : apiProduces) {
            operation.getProduces().add(produced);
        }
        for (String consumed : apiConsumes.isEmpty() ? swaggerOperation.getConsumes() : apiConsumes) {
            operation.getConsumes().add(consumed);
        }
    }

    public static ApiDeclaration getApiDeclaration(String sectionName, Definition definition) {
        ApiDeclaration result = new ApiDeclaration();
        SwaggerTranslator.fillApiDeclarationMainAttributes(definition, result, sectionName);
        Collection<String> usedModels = SwaggerTranslator.fillApiDeclarationResources(definition, result, sectionName);
        SwaggerTranslator.fillApiDeclarationRepresentations(definition, result, usedModels);
        return result;
    }

    public static ResourceListing getResourcelisting(Definition definition) {
        ResourceListing result = new ResourceListing();
        SwaggerTranslator.fillResourceListingMainAttributes(definition, result);
        SwaggerTranslator.fillResourceListingApis(definition, result);
        return result;
    }

    private static PayLoad toEntity(ResourceOperationParameterDeclaration parameter) {
        PayLoad result = new PayLoad();
        if ("array".equals(parameter.getType())) {
            result.setArray(true);
            if (parameter.getItems() != null && parameter.getItems().getType() != null) {
                result.setType(parameter.getItems().getType());
            } else if (parameter.getItems() != null) {
                result.setType(parameter.getItems().getRef());
            }
        } else {
            result.setArray(false);
            result.setType(parameter.getType());
        }
        return result;
    }

    private static PathVariable toPathVariable(ResourceOperationParameterDeclaration parameter) {
        PathVariable result = new PathVariable();
        result.setName(parameter.getName());
        result.setDescription(parameter.getDescription());
        result.setType(SwaggerTypes.toDefinitionType(new SwaggerTypeFormat(parameter.getType(), parameter.getFormat())));
        return result;
    }

    private static QueryParameter toQueryParameter(ResourceOperationParameterDeclaration parameter) {
        QueryParameter result = new QueryParameter();
        result.setName(parameter.getName());
        result.setDescription(parameter.getDescription());
        result.setRequired(parameter.isRequired());
        result.setAllowMultiple(parameter.isAllowMultiple());
        result.setDefaultValue(parameter.getDefaultValue());
        if (parameter.getEnum_() != null && !parameter.getEnum_().isEmpty()) {
            result.setEnumeration(new ArrayList<String>());
            for (String value : parameter.getEnum_()) {
                result.getEnumeration().add(value);
            }
        }
        return result;
    }

    private static Representation toRepresentation(ModelDeclaration model, String name) {
        Representation result = new Representation();
        result.setName(name);
        result.setDescription(model.getDescription());
        for (Map.Entry<String, TypePropertyDeclaration> swagProperties : model.getProperties().entrySet()) {
            TypePropertyDeclaration swagProperty = swagProperties.getValue();
            Property property = new Property();
            property.setName(swagProperties.getKey());
            boolean isArray = "array".equals(swagProperty.getType());
            if (isArray) {
                property.setType(swagProperty.getItems().getType() != null ? swagProperty.getItems().getType() : swagProperty.getItems().getRef());
            } else if (swagProperty.getType() != null) {
                property.setType(swagProperty.getType());
            } else if (swagProperty.getRef() != null) {
                property.setType(swagProperty.getRef());
            }
            if (model.getRequired() != null) {
                property.setMinOccurs(model.getRequired().contains(swagProperties.getKey()) ? 1 : 0);
            } else {
                property.setMinOccurs(0);
            }
            property.setMaxOccurs(isArray ? -1 : 1);
            property.setDescription(swagProperty.getDescription());
            property.setMin(swagProperty.getMinimum());
            property.setMax(swagProperty.getMaximum());
            property.setUniqueItems(swagProperty.isUniqueItems());
            result.getProperties().add(property);
            LOGGER.log(Level.FINE, "Property " + property.getName() + " added.");
        }
        return result;
    }

    public static Definition translate(ResourceListing listing, Map<String, ApiDeclaration> apiDeclarations) throws TranslationException {
        SwaggerTranslator.validate(listing, apiDeclarations);
        try {
            Definition definition = new Definition();
            String basePath = apiDeclarations.get(listing.getApis().get(0).getPath()).getBasePath();
            SwaggerTranslator.fillMainAttributes(definition, listing, basePath);
            SwaggerTranslator.fillContract(definition.getContract(), listing, apiDeclarations);
            LOGGER.log(Level.FINE, "Definition successfully retrieved from Swagger definition");
            return definition;
        }
        catch (Exception e) {
            if (e instanceof FileNotFoundException) {
                throw new TranslationException("file", e.getMessage(), e);
            }
            throw new TranslationException("compliance", "Impossible to read your API definition, check your Swagger specs compliance", e);
        }
    }

    public static Definition translate(ApiDeclaration apiDeclaration) throws TranslationException {
        try {
            Definition definition = new Definition();
            definition.setContract(new Contract());
            definition.getEndpoints().add(new Endpoint(apiDeclaration.getBasePath()));
            SwaggerTranslator.fillContract(definition.getContract(), apiDeclaration);
            LOGGER.log(Level.FINE, "Definition successfully retrieved from Swagger definition");
            return definition;
        }
        catch (Exception e) {
            if (e instanceof FileNotFoundException) {
                throw new TranslationException("file", e.getMessage(), e);
            }
            throw new TranslationException("compliance", "Impossible to read your API definition, check your Swagger specs compliance", e);
        }
    }

    private static void validate(ResourceListing resourceListing, Map<String, ApiDeclaration> apiDeclarations) throws TranslationException {
        int adSize;
        int rlSize = resourceListing.getApis().size();
        if (rlSize < (adSize = apiDeclarations.size())) {
            throw new TranslationException("file", "One of your API declarations is not mapped in your resource listing");
        }
        if (rlSize > adSize) {
            throw new TranslationException("file", "Some API declarations are missing");
        }
    }

    private SwaggerTranslator() {
    }
}

