/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark.internal.conversion.swagger.v1_2;

import org.restlet.ext.apispark.internal.conversion.swagger.v1_2.SwaggerTypeFormat;

public class SwaggerTypes {
    public static String toDefinitionType(SwaggerTypeFormat dataType) {
        if ("string".equals(dataType.getType())) {
            if ("date".equals(dataType.getFormat())) {
                return "date";
            }
            if ("byte".equals(dataType.getFormat())) {
                return "byte";
            }
            return "string";
        }
        if ("integer".equals(dataType.getType())) {
            if ("int64".equals(dataType.getFormat())) {
                return "long";
            }
            return "integer";
        }
        if ("number".equals(dataType.getType())) {
            if ("float".equals(dataType.getFormat())) {
                return "Float";
            }
            return "double";
        }
        if ("boolean".equals(dataType.getType())) {
            return "boolean";
        }
        return dataType.getType();
    }

    public static SwaggerTypeFormat toSwaggerType(String dataType) {
        if ("string".equals(dataType)) {
            return new SwaggerTypeFormat("string");
        }
        if ("byte".equals(dataType)) {
            return new SwaggerTypeFormat("string", "byte");
        }
        if ("short".equals(dataType)) {
            return new SwaggerTypeFormat("integer", "int32");
        }
        if ("integer".equals(dataType)) {
            return new SwaggerTypeFormat("integer", "int32");
        }
        if ("long".equals(dataType)) {
            return new SwaggerTypeFormat("integer", "int64");
        }
        if ("float".equals(dataType)) {
            return new SwaggerTypeFormat("number", "float");
        }
        if ("double".equals(dataType)) {
            return new SwaggerTypeFormat("number", "double");
        }
        if ("boolean".equals(dataType)) {
            return new SwaggerTypeFormat("boolean");
        }
        if ("date".equals(dataType)) {
            return new SwaggerTypeFormat("string", "date");
        }
        return new SwaggerTypeFormat(dataType);
    }
}

