/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark.internal.firewall.rule;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Status;
import org.restlet.ext.apispark.internal.firewall.rule.FirewallRule;

public class FirewallIpFilteringRule
extends FirewallRule {
    private Set<String> filteredAddresses;
    private boolean whiteList;

    public FirewallIpFilteringRule() {
    }

    public FirewallIpFilteringRule(Collection<String> filteredAddresses, boolean whiteList) {
        this.filteredAddresses = new HashSet<String>(filteredAddresses);
        this.whiteList = whiteList;
    }

    @Override
    public int beforeHandle(Request request, Response response) {
        String address = request.getClientInfo().getUpstreamAddress();
        if (this.filteredAddresses.contains(address)) {
            if (!this.whiteList) {
                Context.getCurrentLogger().log(Level.FINE, "The current request has been blocked because \"" + address + "\" is in the black list.");
                response.setStatus(Status.CLIENT_ERROR_FORBIDDEN);
                return 2;
            }
        } else if (this.whiteList) {
            Context.getCurrentLogger().log(Level.FINE, "The current request has been blocked because \"" + address + "\" is not in the white list.");
            response.setStatus(Status.CLIENT_ERROR_FORBIDDEN);
            return 2;
        }
        return 0;
    }

    public Set<String> getFilteredAddresses() {
        return this.filteredAddresses;
    }

    public boolean isWhiteList() {
        return this.whiteList;
    }

    public void setFilteredAddresses(Set<String> filteredAddresses) {
        this.filteredAddresses = filteredAddresses;
    }

    public void setWhiteList(boolean whiteList) {
        this.whiteList = whiteList;
    }
}

