/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark.internal.firewall.rule;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.TimeUnit;
import org.restlet.ext.apispark.internal.firewall.rule.CounterResult;
import org.restlet.ext.apispark.internal.firewall.rule.FirewallCounterRule;
import org.restlet.ext.apispark.internal.firewall.rule.counter.PeriodicCounter;
import org.restlet.ext.apispark.internal.firewall.rule.policy.CountingPolicy;

public class PeriodicFirewallCounterRule
extends FirewallCounterRule {
    private LoadingCache<String, PeriodicCounter> cache;
    private long period;

    public PeriodicFirewallCounterRule(int period, TimeUnit periodUnit, CountingPolicy countingPolicy) {
        super(countingPolicy);
        this.period = periodUnit.toSeconds(period);
        this.initializeCache();
    }

    @Override
    protected void decrementCounter(String countedValue) {
    }

    @Override
    protected CounterResult incrementCounter(String countedValue) {
        PeriodicCounter individualCounter = (PeriodicCounter)this.cache.getUnchecked((Object)countedValue);
        return individualCounter.increment();
    }

    private void initializeCache() {
        CacheLoader<String, PeriodicCounter> loader = new CacheLoader<String, PeriodicCounter>(){

            public PeriodicCounter load(String key) {
                return new PeriodicCounter(PeriodicFirewallCounterRule.this.period);
            }
        };
        long cacheExpiration = 2L * this.period < TimeUnit.MINUTES.toSeconds(1L) ? TimeUnit.MINUTES.toSeconds(1L) : 2L * this.period;
        this.cache = CacheBuilder.newBuilder().expireAfterAccess(cacheExpiration, TimeUnit.SECONDS).build((CacheLoader)loader);
    }
}

