/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark.internal.introspection.application;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.restlet.Application;
import org.restlet.Component;
import org.restlet.data.Protocol;
import org.restlet.data.Reference;
import org.restlet.engine.util.StringUtils;
import org.restlet.ext.apispark.internal.introspection.DocumentedApplication;
import org.restlet.ext.apispark.internal.introspection.IntrospectionHelper;
import org.restlet.ext.apispark.internal.introspection.application.CollectInfo;
import org.restlet.ext.apispark.internal.introspection.application.ComponentIntrospector;
import org.restlet.ext.apispark.internal.introspection.application.RestletCollector;
import org.restlet.ext.apispark.internal.model.Contract;
import org.restlet.ext.apispark.internal.model.Definition;
import org.restlet.ext.apispark.internal.model.Endpoint;
import org.restlet.ext.apispark.internal.reflect.ReflectUtils;
import org.restlet.ext.apispark.internal.utils.IntrospectionUtils;
import org.restlet.routing.VirtualHost;

public class ApplicationIntrospector
extends IntrospectionUtils {
    protected static Logger LOGGER = Logger.getLogger(ApplicationIntrospector.class.getName());

    private static void addEnpoints(Application application, Reference baseRef, Component component, Definition definition, Contract contract, CollectInfo collectInfo) {
        Endpoint endpoint;
        String scheme;
        String string = scheme = collectInfo.getSchemes().isEmpty() ? null : collectInfo.getSchemes().get(0).getName();
        if (baseRef != null) {
            endpoint = new Endpoint(baseRef.getHostDomain(), baseRef.getHostPort(), baseRef.getSchemeProtocol().getSchemeName(), baseRef.getPath(), scheme);
            definition.getEndpoints().add(endpoint);
        }
        if (component != null) {
            LOGGER.fine("Look for the endpoint.");
            endpoint = ComponentIntrospector.getEndpoint(component.getDefaultHost(), application, scheme);
            contract.setSections(collectInfo.getSections());
            if (endpoint != null) {
                definition.getEndpoints().add(endpoint);
            }
            for (VirtualHost virtualHost : component.getHosts()) {
                endpoint = ComponentIntrospector.getEndpoint(virtualHost, application, scheme);
                if (endpoint == null) continue;
                definition.getEndpoints().add(endpoint);
            }
        }
        if (definition.getEndpoints().isEmpty()) {
            endpoint = new Endpoint("example.com", 80, Protocol.HTTP.getSchemeName(), "/v1", scheme);
            definition.getEndpoints().add(endpoint);
        }
    }

    public static Application getApplication(String className) {
        return ReflectUtils.newInstance(className, Application.class);
    }

    public static Definition getDefinition(Application application) {
        return ApplicationIntrospector.getDefinition(application, null, null, false);
    }

    public static Definition getDefinition(Application application, Reference baseRef, Component component, boolean useSectionNamingPackageStrategy) {
        DocumentedApplication documentedApplication;
        List<IntrospectionHelper> introspectionHelpers = IntrospectionUtils.getIntrospectionHelpers();
        if (introspectionHelpers == null) {
            introspectionHelpers = new ArrayList<IntrospectionHelper>();
        }
        Definition definition = new Definition();
        Contract contract = new Contract();
        contract.setDescription(StringUtils.nullToEmpty((String)application.getDescription()));
        if (StringUtils.isNullOrEmpty((String)application.getName())) {
            LOGGER.log(Level.WARNING, "Please provide a name to your application, used " + contract.getName() + " by default.");
            contract.setName(application.getClass().getName());
        } else {
            contract.setName(application.getName());
        }
        CollectInfo collectInfo = new CollectInfo();
        collectInfo.setUseSectionNamingPackageStrategy(useSectionNamingPackageStrategy);
        if (application instanceof DocumentedApplication && (documentedApplication = (DocumentedApplication)application).getSections() != null) {
            collectInfo.setSections(documentedApplication.getSections());
        }
        definition.setContract(contract);
        RestletCollector.collect(collectInfo, "", application.getInboundRoot(), null, introspectionHelpers);
        contract.setResources(collectInfo.getResources());
        contract.setRepresentations(collectInfo.getRepresentations());
        contract.setSections(collectInfo.getSections());
        ApplicationIntrospector.addEnpoints(application, baseRef, component, definition, contract, collectInfo);
        ApplicationIntrospector.sortDefinition(definition);
        ApplicationIntrospector.updateRepresentationsSectionsFromResources(definition);
        for (IntrospectionHelper helper : introspectionHelpers) {
            helper.processDefinition(definition, application.getClass());
        }
        return definition;
    }
}

