/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark.internal.introspection.util;

import java.io.File;
import java.lang.reflect.Type;
import org.restlet.ext.apispark.internal.introspection.util.Types;
import org.restlet.ext.apispark.internal.introspection.util.UnsupportedTypeException;
import org.restlet.ext.apispark.internal.reflect.ReflectUtils;
import org.restlet.representation.Representation;

public class TypeInfo {
    private final Class<?> clazz;
    private final Type type;
    private final String representationName;
    private final Class<?> representationClazz;
    private final boolean isList;
    private final TypeInfo componentTypeInfo;
    private final boolean isPrimitive;
    private final boolean isJdkClass;
    private final boolean isFile;
    private final boolean isRaw;

    protected TypeInfo(Class<?> clazz, Type type) {
        this.clazz = clazz;
        this.type = type;
        Class<?> componentClazz = ReflectUtils.getComponentClass(type);
        this.representationClazz = componentClazz != null ? componentClazz : clazz;
        this.representationName = Types.convertPrimitiveType(this.representationClazz);
        this.isList = ReflectUtils.isListType(clazz);
        if (this.isList) {
            if (componentClazz == null || !Types.isPrimitiveType(componentClazz) && ReflectUtils.isJdkClass(componentClazz)) {
                throw new UnsupportedTypeException("Type " + Types.toString(clazz, type) + " is a list/array and its component type is unknown or not supported");
            }
            this.componentTypeInfo = Types.getTypeInfo(componentClazz, null);
        } else {
            this.componentTypeInfo = null;
        }
        this.isPrimitive = Types.isPrimitiveType(this.representationClazz);
        this.isJdkClass = ReflectUtils.isJdkClass(this.representationClazz);
        this.isFile = Representation.class.isAssignableFrom(this.representationClazz) || File.class.isAssignableFrom(this.representationClazz);
        this.isRaw = this.isFile || this.isJdkClass;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isList() {
        return this.isList;
    }

    public TypeInfo getComponentTypeInfo() {
        return this.componentTypeInfo;
    }

    public Class<?> getRepresentationClazz() {
        return this.representationClazz;
    }

    public String getRepresentationName() {
        return this.representationName;
    }

    public boolean isPrimitive() {
        return this.isPrimitive;
    }

    public boolean isJdkClass() {
        return this.isJdkClass;
    }

    public boolean isFile() {
        return this.isFile;
    }

    public boolean isRaw() {
        return this.isRaw;
    }
}

