/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark.internal.introspection.util;

import java.io.File;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.restlet.ext.apispark.internal.introspection.util.TypeInfo;
import org.restlet.ext.apispark.internal.model.Representation;

public abstract class Types {
    private static final ConcurrentMap<TypeInfoKey, TypeInfo> cache = new ConcurrentHashMap<TypeInfoKey, TypeInfo>();
    private static final List<String> primitivesTypes = Arrays.asList("byte", "short", "integer", "long", "float", "double", "boolean", "string", "date", "file");
    private static final Map<Class<?>, String> primitiveTypesByClass = new HashMap();

    public static TypeInfo getTypeInfo(Class<?> clazz, Type type) {
        TypeInfoKey key = new TypeInfoKey(clazz, type);
        TypeInfo typeInfo = (TypeInfo)cache.get(key);
        if (typeInfo == null) {
            typeInfo = new TypeInfo(clazz, type);
            cache.put(key, typeInfo);
        }
        return typeInfo;
    }

    public static String convertPrimitiveType(Class<?> type) {
        String primitiveName = primitiveTypesByClass.get(type);
        if (primitiveName != null) {
            return primitiveName;
        }
        if (CharSequence.class.isAssignableFrom(type)) {
            return "string";
        }
        if (Date.class.isAssignableFrom(type)) {
            return "date";
        }
        if (Representation.class.isAssignableFrom(type) || File.class.isAssignableFrom(type)) {
            return "file";
        }
        return type.getSimpleName();
    }

    public static boolean isPrimitiveType(Class<?> type) {
        return primitiveTypesByClass.get(type) != null || CharSequence.class.isAssignableFrom(type) || Date.class.isAssignableFrom(type) || Representation.class.isAssignableFrom(type);
    }

    public static boolean isPrimitiveType(String typename) {
        return primitivesTypes.contains(typename);
    }

    public static String toString(Class<?> clazz, Type type) {
        if (type == null) {
            return clazz.toString();
        }
        return type.toString();
    }

    static {
        primitiveTypesByClass.put(Byte.TYPE, "byte");
        primitiveTypesByClass.put(Byte.class, "byte");
        primitiveTypesByClass.put(Short.TYPE, "short");
        primitiveTypesByClass.put(Short.class, "short");
        primitiveTypesByClass.put(Integer.TYPE, "integer");
        primitiveTypesByClass.put(Integer.class, "integer");
        primitiveTypesByClass.put(Long.TYPE, "long");
        primitiveTypesByClass.put(Long.class, "long");
        primitiveTypesByClass.put(Float.TYPE, "float");
        primitiveTypesByClass.put(Float.class, "float");
        primitiveTypesByClass.put(Double.TYPE, "double");
        primitiveTypesByClass.put(Double.class, "double");
        primitiveTypesByClass.put(Boolean.TYPE, "boolean");
        primitiveTypesByClass.put(Boolean.class, "boolean");
        primitiveTypesByClass.put(Double.TYPE, "double");
        primitiveTypesByClass.put(Double.class, "double");
        primitiveTypesByClass.put(String.class, "string");
        primitiveTypesByClass.put(Date.class, "date");
    }

    private static class TypeInfoKey {
        private final Class<?> clazz;
        private final Type type;

        public TypeInfoKey(Class<?> clazz, Type type) {
            this.clazz = clazz;
            this.type = type;
        }

        public boolean equals(Object obj) {
            if (obj instanceof TypeInfoKey) {
                TypeInfoKey that = (TypeInfoKey)obj;
                return Objects.equals(this.clazz, that.clazz) && Objects.equals(this.type, that.type);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.clazz, this.type);
        }
    }
}

