/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark.internal.model;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Endpoint {
    private String authenticationProtocol;
    private String basePath;
    private String domain;
    private Integer port;
    private String protocol;

    public Endpoint() {
    }

    public Endpoint(String url) {
        Pattern p = Pattern.compile("([a-z]*)://([^:^/]*)(:([0-9]*))?([a-zA-Z0-9+&@#/%=~_|]*)");
        Matcher m = p.matcher(url);
        if (m.matches()) {
            this.domain = m.group(2);
            this.protocol = m.group(1);
            this.basePath = m.group(5);
            if (m.group(4) != null) {
                this.port = Integer.parseInt(m.group(4));
            }
        } else {
            throw new RuntimeException("url does not match URL pattern: " + url);
        }
    }

    public Endpoint(String domain, Integer port, String protocol, String basePath, String authenticationProtocol) {
        this.domain = domain;
        this.setPort(port);
        this.protocol = protocol;
        this.basePath = basePath;
        this.authenticationProtocol = authenticationProtocol;
    }

    public String computeUrl() {
        return this.protocol + "://" + this.domain + (this.port != null ? ":" + this.port : "") + (this.basePath != null ? this.basePath : "");
    }

    public String getAuthenticationProtocol() {
        return this.authenticationProtocol;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String getDomain() {
        return this.domain;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setAuthenticationProtocol(String authenticationProtocol) {
        this.authenticationProtocol = authenticationProtocol;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setPort(Integer port) {
        if (port != null && port != -1) {
            this.port = port;
        } else {
            port = null;
        }
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }
}

