/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark.internal.utils;

import java.io.PrintStream;

public class CliUtils {
    private final PrintStream o;
    private int columnSize;
    private int indentSize = 7;

    public CliUtils(PrintStream o, int columnSize) {
        this.o = o;
        this.columnSize = columnSize;
    }

    public void print() {
        this.o.println();
    }

    public void print0(String ... strings) {
        this.printSentences(0, strings);
    }

    public void print1(String ... strings) {
        this.printSentences(1, strings);
    }

    public void print2(String ... strings) {
        this.printSentences(2, strings);
    }

    public void print12(String string1, String ... strings) {
        this.print1(string1);
        this.print2(strings);
    }

    public void printSentences(int indent, String ... strings) {
        for (String string : strings) {
            this.printSentence(indent, string);
        }
    }

    public void printSentence(int indent, String string) {
        int shift = indent * this.indentSize;
        int blockLength = this.columnSize - shift - 1;
        String tab = "";
        for (int i = 0; i < shift; ++i) {
            tab = tab.concat(" ");
        }
        String sentence = string.replace("\n", "\n" + tab);
        int index = 0;
        while (index < sentence.length() - 1) {
            this.o.print(tab);
            int length = Math.min(index + blockLength, sentence.length() - 1);
            if (length - index < blockLength) {
                this.o.println(sentence.substring(index));
                index = length + 1;
                continue;
            }
            if (sentence.charAt(length) == ' ') {
                this.o.println(sentence.substring(index, length));
                index = length + 1;
                continue;
            }
            if ((length = sentence.substring(index, length - 1).lastIndexOf(32)) != -1) {
                this.o.println(sentence.substring(index, index + length));
                index += length + 1;
                continue;
            }
            length = sentence.substring(index).indexOf(32);
            if (length != -1) {
                this.o.println(sentence.substring(index, index + length));
                index += length + 1;
                continue;
            }
            this.o.println(sentence.substring(index));
            index = sentence.length();
        }
    }
}

