/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark.internal.utils;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.ext.apispark.internal.model.Property;
import org.restlet.ext.apispark.internal.model.Representation;
import org.restlet.ext.jackson.JacksonRepresentation;
import org.restlet.service.MetadataService;

public class SampleUtils {
    private static final List<String> supportedExtensions = Arrays.asList("xml", "yaml", "json", "jsonsmile");
    private static final List<String> numberTypes = Arrays.asList("byte", "short", "integer", "long");
    private static final List<String> decimalTypes = Arrays.asList("float", "double");

    public static String convertSampleAccordingToMediaType(Object content, String mediaTypeAsString, String representationName) {
        String text;
        MetadataService ms = new MetadataService();
        MediaType mediaType = MediaType.valueOf((String)mediaTypeAsString);
        if (!supportedExtensions.contains(ms.getExtension((Metadata)mediaType))) {
            return null;
        }
        try {
            text = new JacksonRepresentation(mediaType, content).getText();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (ms.getAllMediaTypes("xml").contains(mediaType)) {
            text = text.replaceAll("HashMap", representationName);
        }
        return text;
    }

    public static Map<String, Object> getRepresentationSample(Representation representation) {
        List<Property> properties = representation.getProperties();
        HashMap<String, Object> content = new HashMap<String, Object>();
        for (Property property : properties) {
            content.put(property.getName(), SampleUtils.getFieldSampleValue(property));
        }
        return content;
    }

    public static Object getFieldSampleValue(Property property) {
        List<Object> sampleValue;
        List<Object> list = sampleValue = property.getExample() != null ? SampleUtils.convertSampleValue(property.getType(), property.getExample()) : SampleUtils.getPropertyDefaultSampleValue(property.getType(), property.getName());
        if (property.getMaxOccurs() != null && property.getMaxOccurs() != 1) {
            sampleValue = sampleValue != null ? Arrays.asList(sampleValue) : Arrays.asList(new Object[0]);
        }
        return sampleValue;
    }

    public static Object getPropertyDefaultSampleValue(String propertyType, String propertyName) {
        if ("string".equals(propertyType)) {
            return "sample " + propertyName;
        }
        if (numberTypes.contains(propertyType)) {
            return 1;
        }
        if (decimalTypes.contains(propertyType)) {
            return Float.valueOf(1.1f);
        }
        if ("boolean".equals(propertyType)) {
            return false;
        }
        if ("date".equals(propertyType)) {
            return null;
        }
        return null;
    }

    public static Object convertSampleValue(String propertyType, String sampleValue) {
        if ("string".equals(propertyType)) {
            return sampleValue;
        }
        if (numberTypes.contains(propertyType)) {
            return Long.parseLong(sampleValue);
        }
        if (decimalTypes.contains(propertyType)) {
            return Double.parseDouble(sampleValue);
        }
        if ("boolean".equals(propertyType)) {
            return Boolean.parseBoolean(sampleValue);
        }
        if ("date".equals(propertyType)) {
            return sampleValue;
        }
        return null;
    }
}

