/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark.internal;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.restlet.Context;
import org.restlet.Restlet;
import org.restlet.engine.util.StringUtils;
import org.restlet.ext.apispark.FirewallConfig;
import org.restlet.ext.apispark.internal.ApiSparkConfig;
import org.restlet.ext.apispark.internal.agent.AgentConfigurationException;
import org.restlet.ext.apispark.internal.agent.bean.ModulesSettings;
import org.restlet.ext.apispark.internal.agent.module.AnalyticsModule;
import org.restlet.ext.apispark.internal.agent.module.AuthenticationModule;
import org.restlet.ext.apispark.internal.agent.module.AuthorizationModule;
import org.restlet.ext.apispark.internal.agent.module.FirewallModule;
import org.restlet.ext.apispark.internal.agent.module.ModulesSettingsModule;
import org.restlet.ext.apispark.internal.agent.module.ReverseProxyModule;
import org.restlet.ext.apispark.internal.firewall.FirewallFilter;
import org.restlet.ext.apispark.internal.firewall.rule.FirewallRule;
import org.restlet.ext.apispark.internal.utils.RestletChain;
import org.restlet.routing.Filter;

public class ApiSparkFilter
extends Filter {
    protected static Logger LOGGER = Logger.getLogger(ApiSparkFilter.class.getName());
    private Restlet agentFirstRestlet;
    private Restlet filterNext;
    private Restlet agentLastRestlet;
    private ModulesSettings modulesSettings;
    private List<FirewallRule> firewallRules;
    private boolean firewallEnabled;
    private ApiSparkConfig apiSparkConfig;
    private boolean agentEnabled;
    private Context context;

    public ApiSparkFilter(Context context, ApiSparkConfig apiSparkConfig, boolean agentEnabled, boolean firewallEnabled, List<FirewallRule> firewallRules) {
        super(context);
        this.firewallRules = firewallRules;
        this.firewallEnabled = firewallEnabled;
        this.apiSparkConfig = apiSparkConfig;
        this.agentEnabled = agentEnabled;
        this.context = context;
        this.validateRedirection(apiSparkConfig);
        if (agentEnabled) {
            this.validateAgentConfiguration(apiSparkConfig);
            this.modulesSettings = ModulesSettingsModule.getModulesSettings(apiSparkConfig, null);
        }
        this.refreshApiSparkFilter();
    }

    public void refreshApiSparkFilterIfRevisionChanged() {
        try {
            ModulesSettings newModulesSettings = ModulesSettingsModule.getModulesSettings(this.apiSparkConfig, this.modulesSettings);
            if (newModulesSettings != null) {
                this.modulesSettings = newModulesSettings;
                LOGGER.info("Updating modules settings");
                this.refreshApiSparkFilter();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unable to retrieve agent settings from apispark", e);
        }
    }

    public void refreshApiSparkFilter() {
        boolean authenticationEnabled = false;
        RestletChain restletChain = new RestletChain();
        if (this.agentEnabled) {
            if (this.modulesSettings.isAuthenticationModuleEnabled()) {
                LOGGER.info("Add authentication module");
                authenticationEnabled = true;
                restletChain.add((Restlet)new AuthenticationModule(this.apiSparkConfig, this.modulesSettings, this.context));
            }
            if (this.modulesSettings.isAuthorizationModuleEnabled()) {
                if (!this.modulesSettings.isAuthenticationModuleEnabled()) {
                    throw new AgentConfigurationException("The authorization module requires the authentication module which is not enabled");
                }
                LOGGER.info("Add authorization module");
                restletChain.add((Restlet)new AuthorizationModule(this.apiSparkConfig, this.modulesSettings, this.context));
            }
            if (this.modulesSettings.isFirewallModuleEnabled()) {
                this.firewallEnabled = true;
                FirewallModule firewallModule = new FirewallModule(this.apiSparkConfig, this.modulesSettings);
                FirewallConfig firewallConfig = new FirewallConfig(this.firewallRules);
                firewallModule.updateFirewallConfig(firewallConfig);
            }
            if (this.modulesSettings.isAnalyticsModuleEnabled()) {
                LOGGER.info("Add analytics module");
                restletChain.add((Restlet)new AnalyticsModule(this.apiSparkConfig, this.modulesSettings, this.context));
            }
        }
        if (this.firewallEnabled) {
            LOGGER.info("Add firewall module");
            restletChain.add((Restlet)new FirewallFilter(this.context, this.firewallRules));
        }
        if (this.apiSparkConfig.isReverseProxyEnabled()) {
            LOGGER.info("Add redirection module");
            String redirectorUrl = this.apiSparkConfig.getReverseProxyTargetUrl() + "{rr}";
            ReverseProxyModule redirector = new ReverseProxyModule(this.context, redirectorUrl, authenticationEnabled);
            restletChain.add((Restlet)redirector);
        }
        if (restletChain.getFirst() == null) {
            LOGGER.warning("No modules are enabled.");
        }
        this.agentFirstRestlet = restletChain.getFirst();
        this.agentLastRestlet = restletChain.getLast();
    }

    public Restlet getNext() {
        return this.agentFirstRestlet != null ? this.agentFirstRestlet : this.filterNext;
    }

    public void setNext(Restlet next) {
        this.filterNext = next;
        if (this.agentLastRestlet != null && this.agentLastRestlet instanceof Filter) {
            Filter filter = (Filter)this.agentLastRestlet;
            filter.setNext(next);
        }
    }

    public void validateAgentConfiguration(ApiSparkConfig config) {
        if (config.getAgentCellId() == null) {
            throw new IllegalArgumentException("The cell identifier is mandatory");
        }
        if (config.getAgentCellId() == null) {
            throw new IllegalArgumentException("The cell version identifier is mandatory");
        }
        if (StringUtils.isNullOrEmpty((String)config.getAgentServiceUrl())) {
            throw new IllegalArgumentException("The agent service url is mandatory");
        }
        if (StringUtils.isNullOrEmpty((String)config.getAgentLogin())) {
            throw new IllegalArgumentException("The agent login is mandatory");
        }
        if (StringUtils.isNullOrEmpty((String)config.getAgentPassword())) {
            throw new IllegalArgumentException("The agent password key is mandatory");
        }
    }

    public void validateRedirection(ApiSparkConfig config) {
        if (config.isReverseProxyEnabled() && StringUtils.isNullOrEmpty((String)config.getReverseProxyTargetUrl())) {
            throw new IllegalArgumentException("The redirection url is mandatory when redirection is enabled");
        }
    }
}

