/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark.internal.agent.module;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.ext.apispark.internal.ApiSparkConfig;
import org.restlet.ext.apispark.internal.agent.AgentUtils;
import org.restlet.ext.apispark.internal.agent.bean.CallLog;
import org.restlet.ext.apispark.internal.agent.bean.CallLogs;
import org.restlet.ext.apispark.internal.agent.bean.ModulesSettings;
import org.restlet.ext.apispark.internal.agent.resource.AnalyticsResource;

public class AnalyticsHandler {
    protected static Logger LOGGER = Logger.getLogger(AnalyticsHandler.class.getName());
    private static final int THREAD_MAX_NUMBER = 3;
    private int bufferSize = 100;
    private long postPeriodInSecond = 60L;
    private static final long RETRY_AFTER = 500L;
    private static final int MAX_ATTEMPTS = 5;
    private static final long MAX_TIME = TimeUnit.SECONDS.toMillis(10L);
    private Timer asyncPostTimer;
    private AnalyticsResource analyticsClientResource;
    private ExecutorService executorService;
    private final List<CallLog> callLogs;

    public AnalyticsHandler(ApiSparkConfig apiSparkConfig, ModulesSettings modulesSettings) {
        this.analyticsClientResource = AgentUtils.getClientResource(apiSparkConfig, modulesSettings, AnalyticsResource.class, "/analytics");
        this.callLogs = Collections.synchronizedList(Lists.newArrayListWithExpectedSize((int)this.bufferSize));
        this.bufferSize = apiSparkConfig.getAgentAnalyticsBufferSize();
        this.executorService = new ThreadPoolExecutor(1, 3, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(this.bufferSize), new ThreadFactoryBuilder().setNameFormat("analytics-poster-%d").build());
        this.postPeriodInSecond = apiSparkConfig.getAgentAnalyticsPostPeriodInSecond();
        long postPeriodInMs = TimeUnit.SECONDS.toMillis(this.postPeriodInSecond);
        this.asyncPostTimer = new Timer();
        this.asyncPostTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                AnalyticsHandler.this.flushLogs();
            }
        }, postPeriodInMs, postPeriodInMs);
    }

    public void addCallLogToBuffer(Request request, Response response, int duration, long startTime) {
        CallLog callLog = new CallLog();
        callLog.setDate(new Date(startTime));
        callLog.setDuration(duration);
        callLog.setMethod(request.getMethod().getName());
        callLog.setPath(request.getResourceRef().getPath());
        callLog.setRemoteIp(request.getClientInfo().getUpstreamAddress());
        callLog.setStatusCode(response.getStatus().getCode());
        callLog.setUserAgent(request.getClientInfo().getAgent());
        callLog.setUserToken(request.getClientInfo().getUser() == null ? "" : request.getClientInfo().getUser().getIdentifier());
        this.callLogs.add(callLog);
        if (this.callLogs.size() >= this.bufferSize) {
            this.flushLogs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushLogs() {
        CallLogs logsToPost;
        if (this.callLogs.isEmpty()) {
            return;
        }
        List<CallLog> list = this.callLogs;
        synchronized (list) {
            if (this.callLogs.isEmpty()) {
                return;
            }
            logsToPost = new CallLogs(this.callLogs.size());
            logsToPost.addAll(this.callLogs);
            this.callLogs.clear();
        }
        this.postLogs(logsToPost);
    }

    private void postLogs(CallLogs logsToPost) {
        try {
            this.executorService.execute(new AsyncCallLogsPostTask(logsToPost));
        }
        catch (RejectedExecutionException e) {
            LOGGER.severe("Posting " + logsToPost.size() + " call logs failed permanently due to \"" + e.getCause().getMessage() + "\".");
            this.errorSendLog(logsToPost);
        }
    }

    protected void errorSendLog(CallLogs logsToPost) {
    }

    public synchronized void stop() throws Exception {
        this.asyncPostTimer.cancel();
        this.executorService.shutdown();
    }

    private class AsyncCallLogsPostTask
    implements Runnable {
        private CallLogs logsToPost;

        public AsyncCallLogsPostTask(CallLogs logsToPost) {
            this.logsToPost = logsToPost;
        }

        @Override
        public void run() {
            for (int attemptNumber = 1; attemptNumber <= 6; ++attemptNumber) {
                try {
                    AnalyticsHandler.this.analyticsClientResource.postLogs(this.logsToPost);
                    LOGGER.fine(this.logsToPost.size() + " call logs sent to the analytics service.");
                    break;
                }
                catch (Exception e) {
                    if (attemptNumber == 5) {
                        LOGGER.severe("Posting " + this.logsToPost.size() + " call logs failed permanently after " + 5 + " attempts.");
                        AnalyticsHandler.this.errorSendLog(this.logsToPost);
                        continue;
                    }
                    LOGGER.warning("Error sending " + this.logsToPost.size() + " call logs to the analytics service during attempt n??" + attemptNumber + " because \"" + e.getMessage() + "\".");
                    try {
                        Thread.sleep(this.getRetryTime(attemptNumber));
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
        }

        private long getRetryTime(int attemptNumber) {
            long newTime = 500L * (long)((int)Math.pow(2.0, attemptNumber - 1));
            return Math.min(newTime, MAX_TIME);
        }
    }
}

