/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark.internal.agent.module;

import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.ext.apispark.internal.ApiSparkConfig;
import org.restlet.ext.apispark.internal.agent.bean.ModulesSettings;
import org.restlet.ext.apispark.internal.agent.module.AnalyticsHandler;
import org.restlet.routing.Filter;

public class AnalyticsModule
extends Filter {
    protected static Logger LOGGER = Logger.getLogger(AnalyticsModule.class.getName());
    private AnalyticsHandler analyticsHandler;
    public static final String ANALYTICS_PATH = "/analytics";

    public AnalyticsModule(ApiSparkConfig apiSparkConfig, ModulesSettings modulesSettings) {
        this(apiSparkConfig, modulesSettings, null);
    }

    public AnalyticsModule(ApiSparkConfig apiSparkConfig, ModulesSettings modulesSettings, Context context) {
        super(context);
        this.analyticsHandler = new AnalyticsHandler(apiSparkConfig, modulesSettings);
    }

    protected int beforeHandle(Request request, Response response) {
        request.getAttributes().put("org.restlet.startTime", this.getTimeMillis());
        return 0;
    }

    protected void afterHandle(Request request, Response response) {
        long startTime = (Long)request.getAttributes().get("org.restlet.startTime");
        int duration = (int)(this.getTimeMillis() - startTime);
        this.analyticsHandler.addCallLogToBuffer(request, response, duration, startTime);
    }

    private long getTimeMillis() {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
    }

    public synchronized void stop() throws Exception {
        this.analyticsHandler.stop();
        super.stop();
    }
}

