/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark.internal.firewall.handler;

import org.restlet.Request;
import org.restlet.Response;
import org.restlet.ext.apispark.internal.firewall.handler.policy.LimitPolicy;
import org.restlet.ext.apispark.internal.firewall.rule.CounterResult;

public abstract class ThresholdHandler {
    private LimitPolicy limitPolicy;

    public ThresholdHandler(LimitPolicy limitPolicy) {
        this.setLimitPolicy(limitPolicy);
    }

    public int getLimit(Request request, String countedValue) {
        return this.limitPolicy.getLimit(request, countedValue);
    }

    public int handle(Request request, Response response, CounterResult counterResult) {
        if (this.getLimit(request, counterResult.getCountedValue()) < counterResult.getConsumed()) {
            return this.thresholdReached(request, response, counterResult);
        }
        return 0;
    }

    public void setLimitPolicy(LimitPolicy limitPolicy) {
        this.limitPolicy = limitPolicy;
    }

    protected abstract int thresholdReached(Request var1, Response var2, CounterResult var3);
}

