/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark.internal.firewall.handler.policy;

import java.util.HashMap;
import java.util.Map;
import org.restlet.Request;
import org.restlet.ext.apispark.internal.firewall.handler.policy.LimitPolicy;

public class PerGroupLimitPolicy
extends LimitPolicy {
    public int defaultLimit;
    private Map<String, String> groups;
    private Map<String, Integer> limitsPerGroup;

    public PerGroupLimitPolicy() {
        this(0);
    }

    public PerGroupLimitPolicy(int defaultLimit) {
        this(new HashMap<String, Integer>(), new HashMap<String, String>(), defaultLimit);
    }

    public PerGroupLimitPolicy(Map<String, Integer> limitsPerGroup, Map<String, String> groups, int defaultLimit) {
        this.defaultLimit = defaultLimit;
        this.limitsPerGroup = limitsPerGroup;
        this.groups = groups;
    }

    public void addCountedValue(String countedValue, String group) {
        this.groups.put(countedValue, group);
    }

    public void addGroup(String group, int limit) {
        this.limitsPerGroup.put(group, limit);
    }

    @Override
    public int getLimit(Request request, String countedValue) {
        int result = this.defaultLimit;
        String group = this.groups.get(countedValue);
        if (group != null && this.limitsPerGroup.containsKey(group)) {
            result = this.limitsPerGroup.get(group);
        }
        return result;
    }
}

