/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark.internal.firewall.rule;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.ext.apispark.internal.firewall.handler.ThresholdHandler;
import org.restlet.ext.apispark.internal.firewall.rule.CounterResult;
import org.restlet.ext.apispark.internal.firewall.rule.FirewallRule;
import org.restlet.ext.apispark.internal.firewall.rule.policy.CountingPolicy;

public abstract class FirewallCounterRule
extends FirewallRule {
    private boolean blockingUnknownCountedValue = true;
    private CountingPolicy countingPolicy;
    private List<ThresholdHandler> handlers = new ArrayList<ThresholdHandler>();

    public FirewallCounterRule(CountingPolicy countingPolicy) {
        this.setCountingPolicy(countingPolicy);
    }

    public void addHandler(ThresholdHandler handler) {
        this.handlers.add(handler);
    }

    @Override
    public void afterHandle(Request request, Response response) {
        this.decrement(request);
    }

    @Override
    public int beforeHandle(Request request, Response response) {
        String countedValue = this.countingPolicy.getCountedValue(request);
        if (countedValue == null) {
            return this.isBlockingUnknownCountedValue() ? 1 : 0;
        }
        CounterResult counterResult = this.incrementCounter(countedValue);
        counterResult.setCountedValue(countedValue);
        Context.getCurrentLogger().log(Level.FINE, "Counter " + ((Object)((Object)this)).getClass() + " incremented for value: " + countedValue);
        for (ThresholdHandler handler : this.handlers) {
            int result = handler.handle(request, response, counterResult);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    public void decrement(Request request) {
        String countedValue = this.countingPolicy.getCountedValue(request);
        if (countedValue != null) {
            this.decrementCounter(countedValue);
        }
    }

    protected abstract void decrementCounter(String var1);

    protected abstract CounterResult incrementCounter(String var1);

    public boolean isBlockingUnknownCountedValue() {
        return this.blockingUnknownCountedValue;
    }

    public void setBlockingUnknownCountedValue(boolean blockingUnknownCountedValue) {
        this.blockingUnknownCountedValue = blockingUnknownCountedValue;
    }

    public void setCountingPolicy(CountingPolicy countingPolicy) {
        this.countingPolicy = countingPolicy;
    }
}

