/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark.internal.introspection.application;

import java.util.Iterator;
import org.restlet.Application;
import org.restlet.Component;
import org.restlet.Restlet;
import org.restlet.data.Protocol;
import org.restlet.data.Reference;
import org.restlet.ext.apispark.internal.model.Endpoint;
import org.restlet.ext.apispark.internal.reflect.ReflectUtils;
import org.restlet.ext.apispark.internal.utils.IntrospectionUtils;
import org.restlet.routing.Filter;
import org.restlet.routing.Route;
import org.restlet.routing.Router;
import org.restlet.routing.TemplateRoute;
import org.restlet.routing.VirtualHost;

public class ComponentIntrospector
extends IntrospectionUtils {
    public static Component getComponent(String className) {
        return ReflectUtils.newInstance(className, Component.class);
    }

    public static Endpoint getEndpoint(VirtualHost virtualHost, Application application, String challengeScheme) {
        Endpoint result = null;
        for (Route route : virtualHost.getRoutes()) {
            Application app;
            if (route.getNext() == null || (app = ComponentIntrospector.getNextApplication(route.getNext())) == null || !application.getClass().equals(app.getClass())) continue;
            String hostDomain = null;
            if (virtualHost.getHostDomain() != null && !".*".equals(virtualHost.getHostDomain())) {
                hostDomain = virtualHost.getHostDomain().contains("|") ? virtualHost.getHostDomain().split("|")[0] : virtualHost.getHostDomain();
            }
            if (hostDomain == null) continue;
            Protocol scheme = null;
            if (!".*".equals(virtualHost.getHostScheme())) {
                scheme = Protocol.valueOf((String)virtualHost.getHostScheme());
            }
            if (scheme == null) {
                scheme = Protocol.HTTP;
            }
            Reference ref = new Reference();
            ref.setProtocol(scheme);
            ref.setHostDomain(hostDomain);
            if (route instanceof TemplateRoute) {
                ref.addSegment(((TemplateRoute)route).getTemplate().getPattern());
            }
            try {
                ref.setHostPort(Integer.valueOf(Integer.parseInt(virtualHost.getHostPort())));
            }
            catch (Exception e) {
                // empty catch block
            }
            result = new Endpoint(ref.getHostDomain(), ref.getHostPort(), ref.getSchemeProtocol().getSchemeName(), ref.getPath(), challengeScheme);
        }
        return result;
    }

    private static Application getNextApplication(Restlet current) {
        Application result;
        block2: {
            Route route;
            block3: {
                block1: {
                    result = null;
                    if (!(current instanceof Application)) break block1;
                    result = (Application)current;
                    break block2;
                }
                if (!(current instanceof Filter)) break block3;
                result = ComponentIntrospector.getNextApplication(((Filter)current).getNext());
                break block2;
            }
            if (!(current instanceof Router)) break block2;
            Router router = (Router)current;
            Iterator i$ = router.getRoutes().iterator();
            while (i$.hasNext() && (result = ComponentIntrospector.getNextApplication((route = (Route)i$.next()).getNext())) == null) {
            }
        }
        return result;
    }
}

