/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark.internal.introspection.application;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.restlet.engine.Engine;
import org.restlet.engine.util.BeanInfoUtils;
import org.restlet.engine.util.StringUtils;
import org.restlet.ext.apispark.Introspector;
import org.restlet.ext.apispark.internal.introspection.IntrospectionHelper;
import org.restlet.ext.apispark.internal.introspection.application.CollectInfo;
import org.restlet.ext.apispark.internal.introspection.util.TypeInfo;
import org.restlet.ext.apispark.internal.introspection.util.Types;
import org.restlet.ext.apispark.internal.introspection.util.UnsupportedTypeException;
import org.restlet.ext.apispark.internal.model.Property;
import org.restlet.ext.apispark.internal.model.Representation;
import org.restlet.ext.apispark.internal.model.Section;

public class RepresentationCollector {
    private static Logger LOGGER = Engine.getLogger(Introspector.class);

    public static void addRepresentation(CollectInfo collectInfo, TypeInfo typeInfo, List<? extends IntrospectionHelper> introspectionHelper) {
        boolean notInCache;
        JsonRootName jsonType;
        Representation representation = new Representation();
        representation.setDescription("");
        if (typeInfo.isList()) {
            RepresentationCollector.addRepresentation(collectInfo, typeInfo.getComponentTypeInfo(), introspectionHelper);
            return;
        }
        if (typeInfo.isPrimitive() || typeInfo.isFile()) {
            return;
        }
        representation.setDescription("Java type: " + typeInfo.getRepresentationClazz().getName());
        if (collectInfo.isUseSectionNamingPackageStrategy()) {
            String packageName = typeInfo.getClazz().getPackage().getName();
            representation.getSections().add(packageName);
            if (collectInfo.getSection(packageName) == null) {
                collectInfo.addSection(new Section(packageName));
            }
        }
        String typeName = (jsonType = typeInfo.getClazz().getAnnotation(JsonRootName.class)) == null ? typeInfo.getRepresentationClazz().getSimpleName() : jsonType.value();
        representation.setName(typeName);
        representation.setRaw(false);
        boolean bl = notInCache = collectInfo.getRepresentation(representation.getName()) == null;
        if (notInCache) {
            collectInfo.addRepresentation(representation);
            if (typeInfo.isPojo()) {
                BeanInfo beanInfo = BeanInfoUtils.getBeanInfo(typeInfo.getRepresentationClazz());
                JsonIgnoreProperties jsonIgnoreProperties = (JsonIgnoreProperties)AnnotatedClass.construct(typeInfo.getRepresentationClazz(), (AnnotationIntrospector)new JacksonAnnotationIntrospector(), null).getAnnotation(JsonIgnoreProperties.class);
                List<String> jsonIgnoreProperties2 = jsonIgnoreProperties == null ? null : Arrays.asList(jsonIgnoreProperties.value());
                for (PropertyDescriptor pd : beanInfo.getPropertyDescriptors()) {
                    TypeInfo propertyTypeInfo;
                    JsonIgnore jsonIgnore;
                    if (jsonIgnoreProperties2 != null && jsonIgnoreProperties2.contains(pd.getName()) || (jsonIgnore = pd.getReadMethod().getAnnotation(JsonIgnore.class)) != null && jsonIgnore.value()) continue;
                    try {
                        propertyTypeInfo = Types.getTypeInfo(pd.getReadMethod().getReturnType(), pd.getReadMethod().getGenericReturnType());
                    }
                    catch (UnsupportedTypeException e) {
                        LOGGER.warning("Could not add property " + pd.getName() + " of representation " + typeInfo.getRepresentationClazz().getName() + ". " + e.getMessage());
                        continue;
                    }
                    JsonProperty jsonProperty = pd.getReadMethod().getAnnotation(JsonProperty.class);
                    String propertyName = jsonProperty != null && !StringUtils.isNullOrEmpty((String)jsonProperty.value()) ? jsonProperty.value() : pd.getName();
                    JsonPropertyDescription jsonPropertyDescription = pd.getReadMethod().getAnnotation(JsonPropertyDescription.class);
                    Property property = new Property();
                    property.setName(propertyName);
                    property.setDescription(jsonPropertyDescription != null ? jsonPropertyDescription.value() : "");
                    property.setType(propertyTypeInfo.getRepresentationName());
                    property.setMinOccurs(jsonProperty != null && jsonProperty.required() ? 1 : 0);
                    property.setMaxOccurs(propertyTypeInfo.isList() ? -1 : 1);
                    RepresentationCollector.addRepresentation(collectInfo, propertyTypeInfo, introspectionHelper);
                    for (IntrospectionHelper introspectionHelper2 : introspectionHelper) {
                        introspectionHelper2.processProperty(property, pd.getReadMethod());
                    }
                    representation.getProperties().add(property);
                }
            }
            for (IntrospectionHelper introspectionHelper3 : introspectionHelper) {
                introspectionHelper3.processRepresentation(representation, typeInfo.getRepresentationClazz());
            }
        }
    }
}

