/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark.internal.introspection.helper;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiImplicitParam;
import com.wordnik.swagger.annotations.ApiImplicitParams;
import com.wordnik.swagger.annotations.ApiModel;
import com.wordnik.swagger.annotations.ApiModelProperty;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.restlet.ext.apispark.internal.introspection.IntrospectionHelper;
import org.restlet.ext.apispark.internal.introspection.helper.SwaggerAnnotationUtils;
import org.restlet.ext.apispark.internal.model.Definition;
import org.restlet.ext.apispark.internal.model.Operation;
import org.restlet.ext.apispark.internal.model.Property;
import org.restlet.ext.apispark.internal.model.Representation;
import org.restlet.ext.apispark.internal.model.Resource;

public class SwaggerAnnotationIntrospectionHelper
implements IntrospectionHelper {
    @Override
    public void processDefinition(Definition definition, Class<?> applicationClass) {
    }

    @Override
    public List<Class<?>> processOperation(Resource resource, Operation operation, Class<?> resourceClass, Method javaMethod) {
        ApiImplicitParam apiImplicitParam;
        ApiImplicitParams apiImplicitParams;
        ApiResponse apiResponse;
        ApiResponses apiResponses;
        ArrayList representationsUsed = new ArrayList();
        ApiOperation apiOperation = javaMethod.getAnnotation(ApiOperation.class);
        if (apiOperation != null) {
            SwaggerAnnotationUtils.processApiOperation(apiOperation, resource, operation);
        }
        if ((apiResponses = javaMethod.getAnnotation(ApiResponses.class)) != null) {
            SwaggerAnnotationUtils.processApiResponses(apiResponses, operation, representationsUsed);
        }
        if ((apiResponse = javaMethod.getAnnotation(ApiResponse.class)) != null) {
            SwaggerAnnotationUtils.processApiResponse(apiResponse, operation, representationsUsed);
        }
        if ((apiImplicitParams = javaMethod.getAnnotation(ApiImplicitParams.class)) != null) {
            SwaggerAnnotationUtils.processApiImplicitParams(apiImplicitParams, operation);
        }
        if ((apiImplicitParam = javaMethod.getAnnotation(ApiImplicitParam.class)) != null) {
            SwaggerAnnotationUtils.processApiImplicitParam(apiImplicitParam, operation);
        }
        return representationsUsed;
    }

    @Override
    public void processProperty(Property property, Method readMethod) {
        ApiModelProperty apiModelProperty = readMethod.getAnnotation(ApiModelProperty.class);
        if (apiModelProperty != null) {
            SwaggerAnnotationUtils.processApiModelProperty(apiModelProperty, property);
        }
    }

    @Override
    public void processRepresentation(Representation representation, Class<?> representationClass) {
        ApiModel apiModel = this.getAnnotation(representationClass, ApiModel.class);
        if (apiModel != null) {
            SwaggerAnnotationUtils.processApiModel(apiModel, representation);
        }
    }

    @Override
    public void processResource(Resource resource, Class<?> resourceClass) {
        Api api = this.getAnnotation(resourceClass, Api.class);
        if (api != null) {
            SwaggerAnnotationUtils.processApi(api, resource);
        }
    }

    public <T extends Annotation> T getAnnotation(Class<?> resourceClass, Class<T> annotationClass) {
        T annotation = resourceClass.getAnnotation(annotationClass);
        if (annotation == null) {
            Class<?> i;
            Class<?>[] arr$ = resourceClass.getInterfaces();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (annotation = (i = arr$[i$]).getAnnotation(annotationClass)) == null; ++i$) {
            }
        }
        return annotation;
    }
}

