/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark.internal.introspection.helper;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiImplicitParam;
import com.wordnik.swagger.annotations.ApiImplicitParams;
import com.wordnik.swagger.annotations.ApiModel;
import com.wordnik.swagger.annotations.ApiModelProperty;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.restlet.data.Status;
import org.restlet.engine.util.StringUtils;
import org.restlet.ext.apispark.internal.introspection.util.Types;
import org.restlet.ext.apispark.internal.model.Operation;
import org.restlet.ext.apispark.internal.model.Parameter;
import org.restlet.ext.apispark.internal.model.PayLoad;
import org.restlet.ext.apispark.internal.model.Property;
import org.restlet.ext.apispark.internal.model.QueryParameter;
import org.restlet.ext.apispark.internal.model.Representation;
import org.restlet.ext.apispark.internal.model.Resource;
import org.restlet.ext.apispark.internal.model.Response;

public class SwaggerAnnotationUtils {
    protected static Logger LOGGER = Logger.getLogger(SwaggerAnnotationUtils.class.getName());

    public static void processApi(Api api, Resource resource) {
        if (!StringUtils.isNullOrEmpty((String)api.value())) {
            resource.setName(api.value());
        }
        if (!StringUtils.isNullOrEmpty((String)api.description())) {
            resource.setDescription(api.description());
        }
    }

    public static void processApiImplicitParam(ApiImplicitParam apiImplicitParam, Operation operation) {
        QueryParameter parameter = new QueryParameter();
        if (!StringUtils.isNullOrEmpty((String)apiImplicitParam.name())) {
            parameter.setName(apiImplicitParam.name());
        }
        if (!StringUtils.isNullOrEmpty((String)apiImplicitParam.value())) {
            parameter.setDescription(apiImplicitParam.value());
        }
        if (!StringUtils.isNullOrEmpty((String)apiImplicitParam.defaultValue())) {
            parameter.setDefaultValue(apiImplicitParam.defaultValue());
        }
        parameter.setRequired(apiImplicitParam.required());
        parameter.setAllowMultiple(apiImplicitParam.allowMultiple());
        operation.getQueryParameters().add(parameter);
    }

    public static void processApiImplicitParams(ApiImplicitParams apiImplicitParams, Operation operation) {
        for (ApiImplicitParam apiImplicitParam : apiImplicitParams.value()) {
            SwaggerAnnotationUtils.processApiImplicitParam(apiImplicitParam, operation);
        }
    }

    public static void processApiModel(ApiModel apiModel, Representation representation) {
        if (!StringUtils.isNullOrEmpty((String)apiModel.value())) {
            representation.setName(apiModel.value());
        }
        if (!StringUtils.isNullOrEmpty((String)apiModel.description())) {
            representation.setDescription(apiModel.description());
        }
        if (apiModel.parent() != null) {
            representation.setExtendedType(Types.convertPrimitiveType(apiModel.parent()));
        }
    }

    public static void processApiModelProperty(ApiModelProperty apiModelProperty, Property property) {
        if (!StringUtils.isNullOrEmpty((String)apiModelProperty.value())) {
            property.setDescription(apiModelProperty.value());
        }
        if (!StringUtils.isNullOrEmpty((String)apiModelProperty.dataType())) {
            property.setType(apiModelProperty.dataType());
        }
        if (!StringUtils.isNullOrEmpty((String)apiModelProperty.allowableValues())) {
            property.setMinOccurs(1);
            property.setMaxOccurs(1);
        }
    }

    public static void processApiOperation(ApiOperation apiOperation, Resource resource, Operation operation) {
        if (!StringUtils.isNullOrEmpty((String)apiOperation.nickname())) {
            operation.setName(apiOperation.nickname());
        }
        if (!StringUtils.isNullOrEmpty((String)apiOperation.value())) {
            operation.setDescription(apiOperation.value());
        }
        if (!StringUtils.isNullOrEmpty((String)apiOperation.httpMethod())) {
            operation.setMethod(apiOperation.httpMethod());
        }
        if (!StringUtils.isNullOrEmpty((String)apiOperation.tags())) {
            List tags = StringUtils.splitAndTrim((String)apiOperation.tags());
            for (String tag : tags) {
                if (resource.getSections().contains(tag)) continue;
                resource.getSections().add(tag);
            }
        }
        if (!StringUtils.isNullOrEmpty((String)apiOperation.consumes())) {
            operation.setConsumes(StringUtils.splitAndTrim((String)apiOperation.consumes()));
        }
        if (!StringUtils.isNullOrEmpty((String)apiOperation.produces())) {
            operation.setProduces(StringUtils.splitAndTrim((String)apiOperation.produces()));
        }
    }

    public static void processApiParameter(ApiParam apiParam, Parameter parameter) {
        if (!StringUtils.isNullOrEmpty((String)apiParam.name())) {
            parameter.setName(apiParam.name());
        }
        if (!StringUtils.isNullOrEmpty((String)apiParam.value())) {
            parameter.setDescription(apiParam.value());
        }
        if (!StringUtils.isNullOrEmpty((String)apiParam.defaultValue())) {
            parameter.setDefaultValue(apiParam.defaultValue());
        }
        parameter.setRequired(apiParam.required());
        parameter.setAllowMultiple(apiParam.allowMultiple());
    }

    public static void processApiResponse(ApiResponse apiResponse, Operation operation, List<Class<?>> representationsUsed) {
        Class responseClazz;
        Response response;
        int code;
        Optional existingResponse;
        boolean responseExists;
        List<Response> responses = operation.getResponses();
        if (responses == null) {
            responses = new ArrayList<Response>();
            operation.setResponses(responses);
        }
        if (responseExists = (existingResponse = Iterables.tryFind(responses, (Predicate)new Predicate<Response>(code = apiResponse.code()){
            final /* synthetic */ int val$code;
            {
                this.val$code = n;
            }

            public boolean apply(Response response) {
                return response.getCode() == this.val$code;
            }
        })).isPresent()) {
            response = (Response)existingResponse.get();
        } else {
            response = new Response();
            response.setCode(code);
        }
        response.setCode(code);
        response.setName(Status.valueOf((int)code).getReasonPhrase());
        if (!StringUtils.isNullOrEmpty((String)apiResponse.message())) {
            response.setDescription(apiResponse.message());
        }
        if ((responseClazz = apiResponse.response()) != null && responseClazz != Void.TYPE && responseClazz != Void.class) {
            representationsUsed.add(responseClazz);
            PayLoad payLoad = new PayLoad();
            payLoad.setType(Types.convertPrimitiveType(responseClazz));
            response.setOutputPayLoad(payLoad);
        }
        if (!responseExists) {
            responses.add(response);
        }
    }

    public static void processApiResponses(ApiResponses apiResponses, Operation operation, List<Class<?>> representationsUsed) {
        for (ApiResponse apiResponse : apiResponses.value()) {
            SwaggerAnnotationUtils.processApiResponse(apiResponse, operation, representationsUsed);
        }
    }
}

