/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark.internal.introspection.jaxrs;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Consumes;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.engine.util.BeanInfoUtils;
import org.restlet.engine.util.StringUtils;
import org.restlet.ext.apispark.internal.introspection.DocumentedApplication;
import org.restlet.ext.apispark.internal.introspection.IntrospectionHelper;
import org.restlet.ext.apispark.internal.introspection.util.TypeInfo;
import org.restlet.ext.apispark.internal.introspection.util.Types;
import org.restlet.ext.apispark.internal.introspection.util.UnsupportedTypeException;
import org.restlet.ext.apispark.internal.model.Contract;
import org.restlet.ext.apispark.internal.model.Definition;
import org.restlet.ext.apispark.internal.model.Endpoint;
import org.restlet.ext.apispark.internal.model.Header;
import org.restlet.ext.apispark.internal.model.Operation;
import org.restlet.ext.apispark.internal.model.PathVariable;
import org.restlet.ext.apispark.internal.model.PayLoad;
import org.restlet.ext.apispark.internal.model.Property;
import org.restlet.ext.apispark.internal.model.QueryParameter;
import org.restlet.ext.apispark.internal.model.Representation;
import org.restlet.ext.apispark.internal.model.Resource;
import org.restlet.ext.apispark.internal.model.Section;
import org.restlet.ext.apispark.internal.reflect.ReflectUtils;
import org.restlet.ext.apispark.internal.utils.IntrospectionUtils;

public class JaxRsIntrospector
extends IntrospectionUtils {
    protected static Logger LOGGER = Logger.getLogger(JaxRsIntrospector.class.getName());
    private static final String SUFFIX_RESOURCE = "Resource";
    private static final String SUFFIX_SERVER_RESOURCE = "ServerResource";

    private static void addEndpoints(String applicationPath, Definition definition) {
        if (applicationPath != null) {
            Endpoint endpoint = new Endpoint(applicationPath);
            definition.getEndpoints().add(endpoint);
        }
    }

    private static void addRepresentation(CollectInfo collectInfo, TypeInfo typeInfo, List<? extends IntrospectionHelper> introspectionHelper) {
        boolean notInCache;
        JsonRootName jsonType;
        Representation representation = new Representation();
        representation.setDescription("");
        if (typeInfo.isList()) {
            JaxRsIntrospector.addRepresentation(collectInfo, typeInfo.getComponentTypeInfo(), introspectionHelper);
            return;
        }
        if (typeInfo.isPrimitive() || typeInfo.isFile()) {
            return;
        }
        representation.setDescription("Java type: " + typeInfo.getRepresentationClazz().getName());
        String packageName = typeInfo.getClazz().getPackage().getName();
        representation.getSections().add(packageName);
        if (collectInfo.getSection(packageName) == null) {
            collectInfo.addSection(new Section(packageName));
        }
        String typeName = (jsonType = typeInfo.getClazz().getAnnotation(JsonRootName.class)) == null ? typeInfo.getRepresentationClazz().getSimpleName() : jsonType.value();
        representation.setName(typeName);
        representation.setRaw(false);
        boolean bl = notInCache = collectInfo.getRepresentation(representation.getName()) == null;
        if (notInCache) {
            collectInfo.addRepresentation(representation);
            if (typeInfo.isPojo()) {
                BeanInfo beanInfo = BeanInfoUtils.getBeanInfo(typeInfo.getRepresentationClazz());
                JsonIgnoreProperties jsonIgnoreProperties = (JsonIgnoreProperties)AnnotatedClass.construct(typeInfo.getRepresentationClazz(), (AnnotationIntrospector)new JacksonAnnotationIntrospector(), null).getAnnotation(JsonIgnoreProperties.class);
                List<String> jsonIgnoreProperties2 = jsonIgnoreProperties == null ? null : Arrays.asList(jsonIgnoreProperties.value());
                for (PropertyDescriptor pd : beanInfo.getPropertyDescriptors()) {
                    TypeInfo propertyTypeInfo;
                    JsonIgnore jsonIgnore;
                    if (jsonIgnoreProperties2 != null && jsonIgnoreProperties2.contains(pd.getName()) || (jsonIgnore = pd.getReadMethod().getAnnotation(JsonIgnore.class)) != null && jsonIgnore.value()) continue;
                    try {
                        propertyTypeInfo = Types.getTypeInfo(pd.getReadMethod().getReturnType(), pd.getReadMethod().getGenericReturnType());
                    }
                    catch (UnsupportedTypeException e) {
                        LOGGER.warning("Could not add property " + pd.getName() + " of representation " + typeInfo.getRepresentationClazz().getName() + ". " + e.getMessage());
                        continue;
                    }
                    JsonProperty jsonProperty = pd.getReadMethod().getAnnotation(JsonProperty.class);
                    String propertyName = jsonProperty != null && !StringUtils.isNullOrEmpty((String)jsonProperty.value()) ? jsonProperty.value() : pd.getName();
                    JsonPropertyDescription jsonPropertyDescription = pd.getReadMethod().getAnnotation(JsonPropertyDescription.class);
                    Property property = new Property();
                    property.setName(propertyName);
                    property.setDescription(jsonPropertyDescription != null ? jsonPropertyDescription.value() : "");
                    property.setType(propertyTypeInfo.getRepresentationName());
                    property.setMinOccurs(jsonProperty != null && jsonProperty.required() ? 1 : 0);
                    property.setMaxOccurs(propertyTypeInfo.isList() ? -1 : 1);
                    JaxRsIntrospector.addRepresentation(collectInfo, propertyTypeInfo, introspectionHelper);
                    for (IntrospectionHelper introspectionHelper2 : introspectionHelper) {
                        introspectionHelper2.processProperty(property, pd.getReadMethod());
                    }
                    representation.getProperties().add(property);
                }
            }
            for (IntrospectionHelper introspectionHelper3 : introspectionHelper) {
                introspectionHelper3.processRepresentation(representation, typeInfo.getRepresentationClazz());
            }
        }
    }

    private static String cleanPath(String path) {
        if (path != null) {
            StringBuilder sb = new StringBuilder();
            boolean inVariable = false;
            boolean endVariable = false;
            StringBuilder varBuffer = null;
            for (int i = 0; i < path.length(); ++i) {
                char next = path.charAt(i);
                if (inVariable) {
                    if (next == '}') {
                        if (varBuffer.length() == 0) {
                            LOGGER.warning("Empty pattern variables are not allowed : " + path);
                        } else {
                            sb.append(varBuffer.toString());
                            varBuffer = new StringBuilder();
                        }
                        endVariable = false;
                        inVariable = false;
                        sb.append(next);
                        continue;
                    }
                    if (endVariable) continue;
                    if (Reference.isUnreserved((int)next)) {
                        varBuffer.append(next);
                        continue;
                    }
                    if (next != ':') continue;
                    endVariable = true;
                    continue;
                }
                sb.append(next);
                if (next == '{') {
                    inVariable = true;
                    varBuffer = new StringBuilder();
                    continue;
                }
                if (next != '}') continue;
                LOGGER.warning("An invalid character was detected inside a pattern variable : " + path);
            }
            return sb.toString();
        }
        return null;
    }

    public static Application getApplication(String className) {
        return ReflectUtils.newInstance(className, Application.class);
    }

    public static Definition getDefinition(Application application, Reference baseRef, boolean useSectionNamingPackageStrategy) {
        return JaxRsIntrospector.getDefinition(application, null, null, baseRef, useSectionNamingPackageStrategy);
    }

    public static Definition getDefinition(Application application, String applicationName, List<Class> resources, Reference baseRef, boolean useSectionNamingPackageStrategy) {
        ApplicationPath applicationPath;
        List<IntrospectionHelper> introspectionHelpers = IntrospectionUtils.getIntrospectionHelpers();
        Definition definition = new Definition();
        CollectInfo collectInfo = new CollectInfo();
        collectInfo.setUseSectionNamingPackageStrategy(useSectionNamingPackageStrategy);
        if (baseRef != null) {
            collectInfo.setApplicationPath(baseRef.getPath());
        } else if (application != null && (applicationPath = application.getClass().getAnnotation(ApplicationPath.class)) != null) {
            collectInfo.setApplicationPath(applicationPath.value());
        }
        List<Class> allResources = JaxRsIntrospector.getAllResources(application, resources);
        JaxRsIntrospector.scanResources(collectInfo, allResources, introspectionHelpers);
        if (applicationName != null) {
            collectInfo.setApplicationName(applicationName);
        } else if (application != null) {
            collectInfo.setApplicationName(application.getClass().getName());
        } else {
            collectInfo.setApplicationName("JAXRS-Application");
        }
        JaxRsIntrospector.updateDefinitionContract(collectInfo, application, definition);
        Contract contract = definition.getContract();
        contract.setResources(collectInfo.getResources());
        contract.setRepresentations(collectInfo.getRepresentations());
        contract.setSections(collectInfo.getSections());
        JaxRsIntrospector.addEndpoints(collectInfo.getApplicationPath(), definition);
        JaxRsIntrospector.sortDefinition(definition);
        JaxRsIntrospector.updateRepresentationsSectionsFromResources(definition);
        if (application != null) {
            for (IntrospectionHelper helper : introspectionHelpers) {
                helper.processDefinition(definition, application.getClass());
            }
        }
        return definition;
    }

    public static List<Class> getAllResources(Application application, List<Class> resources) {
        ArrayList<Class> allResources = new ArrayList<Class>();
        if (application != null) {
            if (application.getClasses() != null) {
                allResources.addAll(application.getClasses());
            }
            if (application.getSingletons() != null) {
                for (Object singleton : application.getSingletons()) {
                    if (singleton == null) continue;
                    allResources.add(singleton.getClass());
                }
            }
        }
        if (resources != null) {
            allResources.addAll(resources);
        }
        return allResources;
    }

    private static Header getHeader(TypeInfo typeInfo, String defaultValue, HeaderParam headerParam) {
        Header header = new Header();
        header.setName(headerParam.value());
        header.setType(typeInfo.getRepresentationName());
        header.setAllowMultiple(typeInfo.isList());
        header.setRequired(false);
        header.setDescription(StringUtils.isNullOrEmpty((String)defaultValue) ? "" : "Value: " + defaultValue);
        header.setDefaultValue(defaultValue);
        return header;
    }

    private static String getPathOrNull(Path path) {
        if (path != null) {
            return path.value();
        }
        return null;
    }

    private static PathVariable getPathVariable(TypeInfo typeInfo, PathParam pathParam) {
        PathVariable pathVariable = new PathVariable();
        pathVariable.setName(pathParam.value());
        pathVariable.setType(typeInfo.getRepresentationName());
        return pathVariable;
    }

    private static QueryParameter getQueryParameter(TypeInfo typeInfo, String defaultValue, QueryParam queryParam) {
        QueryParameter queryParameter = new QueryParameter();
        queryParameter.setName(queryParam.value());
        queryParameter.setType(typeInfo.getRepresentationName());
        queryParameter.setAllowMultiple(typeInfo.isList());
        queryParameter.setRequired(false);
        queryParameter.setDescription(StringUtils.isNullOrEmpty((String)defaultValue) ? "" : "Value: " + defaultValue);
        queryParameter.setDefaultValue(defaultValue);
        return queryParameter;
    }

    private static String getResourceMethod(Method method) {
        if (method.getAnnotation(HEAD.class) != null) {
            return org.restlet.data.Method.HEAD.getName();
        }
        if (method.getAnnotation(OPTIONS.class) != null) {
            return org.restlet.data.Method.OPTIONS.getName();
        }
        if (method.getAnnotation(GET.class) != null) {
            return org.restlet.data.Method.GET.getName();
        }
        if (method.getAnnotation(PUT.class) != null) {
            return org.restlet.data.Method.PUT.getName();
        }
        if (method.getAnnotation(POST.class) != null) {
            return org.restlet.data.Method.POST.getName();
        }
        if (method.getAnnotation(DELETE.class) != null) {
            return org.restlet.data.Method.DELETE.getName();
        }
        if (method.getAnnotation(HttpMethod.class) != null) {
            return method.getAnnotation(HttpMethod.class).value();
        }
        return null;
    }

    private static boolean isResourceMethod(Method method) {
        return method.getAnnotation(HEAD.class) != null || method.getAnnotation(OPTIONS.class) != null || method.getAnnotation(GET.class) != null || method.getAnnotation(PUT.class) != null || method.getAnnotation(POST.class) != null || method.getAnnotation(DELETE.class) != null || method.getAnnotation(HttpMethod.class) != null;
    }

    private static String joinPaths(String ... nullablePaths) {
        StringBuilder result = new StringBuilder();
        ArrayList<String> paths = new ArrayList<String>();
        for (String path : nullablePaths) {
            if (StringUtils.isNullOrEmpty((String)path)) continue;
            paths.add(path);
        }
        int lastPathIndex = paths.size() - 1;
        for (int i = 0; i < paths.size(); ++i) {
            String path = (String)paths.get(i);
            if (!path.startsWith("/")) {
                result.append("/");
            }
            if (i != lastPathIndex && path.endsWith("/")) {
                result.append(path.substring(0, path.length() - 1));
                continue;
            }
            result.append(path);
        }
        if (result.length() == 0) {
            result.append("/");
        }
        return result.toString();
    }

    private static void scanClazz(CollectInfo collectInfo, Class<?> clazz, List<? extends IntrospectionHelper> introspectionHelper) {
        Method[] methods;
        ClazzInfo clazzInfo = new ClazzInfo();
        clazzInfo.setClazz(clazz);
        Path path = clazz.getAnnotation(Path.class);
        clazzInfo.setPath(path);
        Consumes consumes = clazz.getAnnotation(Consumes.class);
        clazzInfo.setConsumes(consumes);
        Produces produces = clazz.getAnnotation(Produces.class);
        clazzInfo.setProduces(produces);
        Constructor<?>[] constructors = clazz.getConstructors();
        if (constructors.length == 1) {
            JaxRsIntrospector.scanConstructor(constructors[0], clazzInfo);
        } else if (constructors.length > 1) {
            Constructor<?> selectedConstructor = null;
            int fieldsCount = -1;
            for (Constructor<?> constructor : constructors) {
                if (constructor.getParameterTypes().length <= fieldsCount) continue;
                selectedConstructor = constructor;
                fieldsCount = constructor.getParameterTypes().length;
            }
            JaxRsIntrospector.scanConstructor(selectedConstructor, clazzInfo);
        }
        Field[] fields = ReflectUtils.getAllDeclaredFields(clazz);
        if (fields != null) {
            for (Field field : fields) {
                JaxRsIntrospector.scanField(field, clazzInfo);
            }
        }
        ArrayList<Method> resourceMethods = new ArrayList<Method>();
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (!Modifier.isPublic(method.getModifiers())) continue;
            if (JaxRsIntrospector.isResourceMethod(method)) {
                resourceMethods.add(method);
                continue;
            }
            JaxRsIntrospector.scanSimpleMethod(collectInfo, method, clazzInfo);
        }
        for (Method resourceMethod : resourceMethods) {
            JaxRsIntrospector.scanResourceMethod(collectInfo, clazzInfo, resourceMethod, introspectionHelper);
        }
    }

    private static void scanConstructor(Constructor<?> constructor, ClazzInfo clazzInfo) {
        Annotation[][] parameterAnnotations = constructor.getParameterAnnotations();
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        Type[] genericParameterTypes = constructor.getGenericParameterTypes();
        JaxRsIntrospector.scanParameters(clazzInfo, parameterAnnotations, parameterTypes, genericParameterTypes);
    }

    private static void scanField(Field field, ClazzInfo clazzInfo) {
        QueryParam queryParam;
        PathParam pathParam;
        TypeInfo typeInfo;
        try {
            typeInfo = Types.getTypeInfo(field.getType(), field.getGenericType());
        }
        catch (UnsupportedTypeException e) {
            LOGGER.warning("Could not add field " + field + ". " + e.getMessage());
            return;
        }
        DefaultValue defaultvalue = field.getAnnotation(DefaultValue.class);
        String defaultValueString = defaultvalue != null ? defaultvalue.value() : null;
        HeaderParam headerParam = field.getAnnotation(HeaderParam.class);
        if (headerParam != null) {
            Header header = JaxRsIntrospector.getHeader(typeInfo, defaultValueString, headerParam);
            clazzInfo.addHeader(header);
        }
        if ((pathParam = field.getAnnotation(PathParam.class)) != null) {
            PathVariable pathVariable = JaxRsIntrospector.getPathVariable(typeInfo, pathParam);
            clazzInfo.addPathVariable(pathVariable);
        }
        if ((queryParam = field.getAnnotation(QueryParam.class)) != null) {
            QueryParameter queryParameter = JaxRsIntrospector.getQueryParameter(typeInfo, defaultValueString, queryParam);
            clazzInfo.addQueryParameter(queryParameter);
        }
    }

    private static void scanParameters(ClazzInfo clazzInfo, Annotation[][] parameterAnnotations, Class<?>[] parameterTypes, Type[] genericParameterTypes) {
        for (int i = 0; i < parameterTypes.length; ++i) {
            TypeInfo typeInfo;
            Annotation[] annotations = parameterAnnotations[i];
            try {
                typeInfo = Types.getTypeInfo(parameterTypes[i], genericParameterTypes[i]);
            }
            catch (UnsupportedTypeException e) {
                LOGGER.warning("Could not scan parameter " + Types.toString(parameterTypes[i], genericParameterTypes[i]) + ". " + e.getMessage());
                continue;
            }
            for (Annotation annotation : annotations) {
                String defaultValue = null;
                if (annotation instanceof DefaultValue) {
                    defaultValue = ((DefaultValue)annotation).value();
                }
                if (annotation instanceof HeaderParam) {
                    Header header = JaxRsIntrospector.getHeader(typeInfo, defaultValue, (HeaderParam)annotation);
                    clazzInfo.addHeader(header);
                }
                if (annotation instanceof PathParam) {
                    PathVariable pathVariable = JaxRsIntrospector.getPathVariable(typeInfo, (PathParam)annotation);
                    clazzInfo.addPathVariable(pathVariable);
                }
                if (!(annotation instanceof QueryParam)) continue;
                QueryParameter queryParameter = JaxRsIntrospector.getQueryParameter(typeInfo, defaultValue, (QueryParam)annotation);
                clazzInfo.addQueryParameter(queryParameter);
            }
        }
    }

    private static void scanResourceMethod(CollectInfo collectInfo, ClazzInfo clazzInfo, Method method, List<? extends IntrospectionHelper> introspectionHelper) {
        Consumes consumes;
        Path path = method.getAnnotation(Path.class);
        String fullPath = JaxRsIntrospector.joinPaths(collectInfo.getApplicationPath(), JaxRsIntrospector.getPathOrNull(clazzInfo.getPath()), JaxRsIntrospector.getPathOrNull(path));
        String cleanPath = JaxRsIntrospector.cleanPath(fullPath);
        Operation operation = new Operation();
        operation.setMethod(JaxRsIntrospector.getResourceMethod(method));
        if (StringUtils.isNullOrEmpty((String)operation.getName())) {
            LOGGER.warning("Java method " + method.getName() + " has no Method name.");
            operation.setName(method.getName());
        }
        if ((consumes = method.getAnnotation(Consumes.class)) != null) {
            operation.setConsumes(Arrays.asList(consumes.value()));
        } else if (clazzInfo.getConsumes() != null) {
            operation.setConsumes(Arrays.asList(clazzInfo.getConsumes().value()));
        }
        Produces produces = method.getAnnotation(Produces.class);
        if (produces != null) {
            operation.setProduces(Arrays.asList(produces.value()));
        } else if (clazzInfo.getProduces() != null) {
            operation.setProduces(Arrays.asList(clazzInfo.getProduces().value()));
        }
        Map<String, Header> headers = clazzInfo.getHeadersCopy();
        Map<String, PathVariable> pathVariables = clazzInfo.getPathVariablesCopy();
        Map<String, QueryParameter> queryParameters = clazzInfo.getQueryParametersCopy();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        Class<?>[] parameterTypes = method.getParameterTypes();
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            TypeInfo typeInfo;
            Annotation[] annotations = parameterAnnotations[i];
            try {
                typeInfo = Types.getTypeInfo(parameterTypes[i], genericParameterTypes[i]);
            }
            catch (UnsupportedTypeException unsupportedTypeException) {
                LOGGER.warning("Could not scan parameter " + Types.toString(parameterTypes[i], genericParameterTypes[i]) + " of method " + method + ". " + unsupportedTypeException.getMessage());
                continue;
            }
            for (Annotation annotation : annotations) {
                String defaultValue = null;
                boolean isEntity = true;
                if (annotation instanceof DefaultValue) {
                    defaultValue = ((DefaultValue)annotation).value();
                }
                if (annotation instanceof FormParam) {
                    isEntity = false;
                    JaxRsIntrospector.addRepresentation(collectInfo, typeInfo, introspectionHelper);
                }
                if (annotation instanceof HeaderParam) {
                    isEntity = false;
                    Header header = JaxRsIntrospector.getHeader(typeInfo, defaultValue, (HeaderParam)annotation);
                    headers.put(header.getName(), header);
                }
                if (annotation instanceof PathParam) {
                    isEntity = false;
                    PathVariable pathVariable = JaxRsIntrospector.getPathVariable(typeInfo, (PathParam)annotation);
                    pathVariables.put(pathVariable.getName(), pathVariable);
                }
                if (annotation instanceof QueryParam) {
                    isEntity = false;
                    QueryParameter queryParameter = JaxRsIntrospector.getQueryParameter(typeInfo, defaultValue, (QueryParam)annotation);
                    queryParameters.put(queryParameter.getName(), queryParameter);
                }
                if (annotation instanceof MatrixParam) {
                    isEntity = false;
                }
                if (annotation instanceof CookieParam) {
                    isEntity = false;
                }
                if (annotation instanceof Context) {
                    isEntity = false;
                }
                if (!isEntity) continue;
                JaxRsIntrospector.addRepresentation(collectInfo, typeInfo, introspectionHelper);
                PayLoad inputEntity = new PayLoad();
                inputEntity.setType(typeInfo.getRepresentationName());
                inputEntity.setArray(ReflectUtils.isListType(parameterTypes[i]));
                operation.setInputPayLoad(inputEntity);
            }
        }
        operation.getQueryParameters().addAll(queryParameters.values());
        org.restlet.ext.apispark.internal.model.Response response = new org.restlet.ext.apispark.internal.model.Response();
        if (method.getReturnType() != Void.TYPE) {
            TypeInfo outputTypeInfo = Types.getTypeInfo(method.getReturnType(), method.getGenericReturnType());
            JaxRsIntrospector.addRepresentation(collectInfo, outputTypeInfo, introspectionHelper);
            PayLoad outputEntity = new PayLoad();
            if (Response.class.isAssignableFrom(outputTypeInfo.getRepresentationClazz())) {
                outputEntity.setType("file");
            } else {
                outputEntity.setType(outputTypeInfo.getRepresentationName());
            }
            outputEntity.setArray(outputTypeInfo.isList());
            response.setOutputPayLoad(outputEntity);
        }
        response.setCode(Status.SUCCESS_OK.getCode());
        response.setName("Success");
        response.setDescription("");
        response.setMessage(Status.SUCCESS_OK.getDescription());
        operation.getResponses().add(response);
        Resource resource = collectInfo.getResource(cleanPath);
        if (resource == null) {
            resource = new Resource();
            resource.setResourcePath(cleanPath);
            String name = clazzInfo.getClazz().getSimpleName();
            if (name.endsWith(SUFFIX_SERVER_RESOURCE) && name.length() > SUFFIX_SERVER_RESOURCE.length()) {
                name = name.substring(0, name.length() - SUFFIX_SERVER_RESOURCE.length());
            }
            if (name.endsWith(SUFFIX_RESOURCE) && name.length() > SUFFIX_RESOURCE.length()) {
                name = name.substring(0, name.length() - SUFFIX_RESOURCE.length());
            }
            resource.setName(name);
            resource.getPathVariables().addAll(pathVariables.values());
            if (collectInfo.isUseSectionNamingPackageStrategy()) {
                String string = clazzInfo.getClazz().getPackage().getName();
                resource.getSections().add(string);
            }
            collectInfo.addResource(resource);
            for (IntrospectionHelper introspectionHelper2 : introspectionHelper) {
                introspectionHelper2.processResource(resource, clazzInfo.getClazz());
            }
        }
        resource.getOperations().add(operation);
        for (IntrospectionHelper introspectionHelper3 : introspectionHelper) {
            introspectionHelper3.processOperation(resource, operation, clazzInfo.getClazz(), method);
        }
    }

    public static void scanResources(CollectInfo collectInfo, List<Class> resources, List<? extends IntrospectionHelper> introspectionHelper) {
        for (Class clazz : resources) {
            JaxRsIntrospector.scanClazz(collectInfo, clazz, introspectionHelper);
        }
    }

    private static void scanSimpleMethod(CollectInfo collectInfo, Method method, ClazzInfo clazzInfo) {
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        Class<?>[] parameterTypes = method.getParameterTypes();
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        JaxRsIntrospector.scanParameters(clazzInfo, parameterAnnotations, parameterTypes, genericParameterTypes);
    }

    private static void updateDefinitionContract(CollectInfo collectInfo, Application application, Definition definition) {
        DocumentedApplication documentedApplication;
        Contract contract = new Contract();
        contract.setName(collectInfo.getApplicationName());
        if (application instanceof DocumentedApplication && (documentedApplication = (DocumentedApplication)application).getSections() != null) {
            collectInfo.setSections(documentedApplication.getSections());
        }
        definition.setContract(contract);
    }

    public static class CollectInfo {
        private String applicationName;
        private String applicationPath;
        private Map<String, Representation> representations = new HashMap<String, Representation>();
        private Map<String, Resource> resourcesByPath = new LinkedHashMap<String, Resource>();
        private Map<String, Section> sections = new HashMap<String, Section>();
        private boolean useSectionNamingPackageStrategy;

        public void addRepresentation(Representation representation) {
            this.representations.put(representation.getName(), representation);
        }

        public void addResource(Resource resource) {
            this.resourcesByPath.put(resource.getResourcePath(), resource);
        }

        public void addSection(Section section) {
            this.sections.put(section.getName(), section);
        }

        public String getApplicationName() {
            return this.applicationName;
        }

        public void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public String getApplicationPath() {
            return this.applicationPath;
        }

        public Representation getRepresentation(String identifier) {
            return this.representations.get(identifier);
        }

        public List<Representation> getRepresentations() {
            return new ArrayList<Representation>(this.representations.values());
        }

        public Resource getResource(String operationPath) {
            return this.resourcesByPath.get(operationPath);
        }

        public List<Resource> getResources() {
            return new ArrayList<Resource>(this.resourcesByPath.values());
        }

        public Section getSection(String identifier) {
            return this.sections.get(identifier);
        }

        public List<Section> getSections() {
            return new ArrayList<Section>(this.sections.values());
        }

        public boolean isUseSectionNamingPackageStrategy() {
            return this.useSectionNamingPackageStrategy;
        }

        public void setApplicationPath(String applicationPath) {
            this.applicationPath = applicationPath;
        }

        public void setSections(Map<String, Section> sections) {
            this.sections = sections;
        }

        public void setUseSectionNamingPackageStrategy(boolean useSectionNamingPackageStrategy) {
            this.useSectionNamingPackageStrategy = useSectionNamingPackageStrategy;
        }
    }

    private static class ClazzInfo {
        private Class<?> clazz;
        private Consumes consumes;
        private Map<String, Header> headers = new LinkedHashMap<String, Header>();
        private Path path;
        private Map<String, PathVariable> pathVariables = new LinkedHashMap<String, PathVariable>();
        private Produces produces;
        private Map<String, QueryParameter> queryParameters = new LinkedHashMap<String, QueryParameter>();
        private Resource resource;

        private ClazzInfo() {
        }

        public void addHeader(Header header) {
            this.headers.put(header.getName(), header);
        }

        public void addPathVariable(PathVariable pathVariable) {
            this.pathVariables.put(pathVariable.getName(), pathVariable);
        }

        public void addQueryParameter(QueryParameter queryParameter) {
            this.queryParameters.put(queryParameter.getName(), queryParameter);
        }

        public Class<?> getClazz() {
            return this.clazz;
        }

        public Consumes getConsumes() {
            return this.consumes;
        }

        public Map<String, Header> getHeadersCopy() {
            return new LinkedHashMap<String, Header>(this.headers);
        }

        public Path getPath() {
            return this.path;
        }

        public Map<String, PathVariable> getPathVariablesCopy() {
            return new LinkedHashMap<String, PathVariable>(this.pathVariables);
        }

        public Produces getProduces() {
            return this.produces;
        }

        public Map<String, QueryParameter> getQueryParametersCopy() {
            return new LinkedHashMap<String, QueryParameter>(this.queryParameters);
        }

        public Resource getResource() {
            return this.resource;
        }

        public void setClazz(Class<?> clazz) {
            this.clazz = clazz;
        }

        public void setConsumes(Consumes consumes) {
            this.consumes = consumes;
        }

        public void setPath(Path path) {
            this.path = path;
        }

        public void setProduces(Produces produces) {
            this.produces = produces;
        }

        public void setResource(Resource resource) {
            this.resource = resource;
        }
    }
}

