/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark.internal.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.restlet.ext.apispark.internal.introspection.util.UnsupportedTypeException;

public class ReflectUtils {
    public static Field[] getAllDeclaredFields(Class type) {
        ArrayList fields = new ArrayList();
        Class currentType = type;
        while (currentType != null) {
            Field[] currentFields = currentType.getDeclaredFields();
            Collections.addAll(fields, currentFields);
            if ((currentType = currentType.getSuperclass()) == null || !currentType.equals(Object.class)) continue;
            currentType = null;
        }
        return fields.toArray(new Field[fields.size()]);
    }

    public static String getFirstSegment(String path) {
        String segment = null;
        if (path != null) {
            int start = path.startsWith("/") ? 1 : 0;
            int index = path.indexOf("/", start);
            segment = index != -1 ? "/" + path.substring(start, index) : "/" + path.substring(start);
        }
        return segment;
    }

    public static Class<?> getComponentClass(Type type) {
        if (type instanceof Class) {
            Class c = (Class)type;
            if (c.isArray()) {
                return c.getComponentType();
            }
            if (Collection.class.isAssignableFrom(c)) {
                return ReflectUtils.getComponentClass(c.getGenericSuperclass());
            }
            return c;
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType gat = (GenericArrayType)type;
            return ReflectUtils.getComponentClass(gat.getGenericComponentType());
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType t = (ParameterizedType)type;
            if (t.getActualTypeArguments().length != 1) {
                throw new UnsupportedTypeException("Type " + type + " is a generic type with zero or several arguments. This is not supported.");
            }
            if (t.getActualTypeArguments()[0] instanceof TypeVariable) {
                throw new UnsupportedTypeException("Type " + type + " is a generic type with unkwnown type. This is not supported.");
            }
            return ReflectUtils.getComponentClass(t.getActualTypeArguments()[0]);
        }
        return type != null ? type.getClass() : null;
    }

    public static boolean isJdkClass(Class<?> clazz) {
        if (clazz != null) {
            if (clazz.isPrimitive()) {
                return true;
            }
            if (clazz.getPackage() != null) {
                return clazz.getPackage().getName().startsWith("java.") || clazz.getPackage().getName().startsWith("javax.");
            }
        }
        return false;
    }

    public static boolean isListType(Class<?> type) {
        return Collection.class.isAssignableFrom(type) || type.isArray();
    }

    public static <T> T newInstance(String className, Class<? extends T> instanceClazz) {
        if (className == null) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(className);
            if (instanceClazz.isAssignableFrom(clazz)) {
                return (T)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            throw new RuntimeException(className + " does not seem to be a valid subclass of " + instanceClazz.getName() + " class.");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Cannot locate the class " + className + " in the classpath.", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot instantiate the class. Check that the class has an empty constructor.", e);
        }
    }

    public String buildParameterTypeName(Class<?> parameterType, Type genericParameterType, ParameterizedType parameterizedType) {
        Type type = parameterizedType != null ? parameterizedType.getActualTypeArguments()[0] : null;
        StringBuilder sb = new StringBuilder();
        if (type == null) {
            this.buildTypeName(parameterType, sb);
        } else {
            this.buildTypeName(genericParameterType, sb);
        }
        return sb.toString();
    }

    private void buildTypeName(Type type, StringBuilder sb) {
        if (type instanceof Class) {
            if (((Class)type).isArray()) {
                this.buildTypeName(((Class)type).getComponentType(), sb);
                sb.append("[]");
            } else {
                sb.append(((Class)type).getName());
            }
        } else if (type instanceof GenericArrayType) {
            this.buildTypeName(((GenericArrayType)type).getGenericComponentType(), sb);
            sb.append("[]");
        } else if (type instanceof ParameterizedType) {
            ParameterizedType t = (ParameterizedType)type;
            this.buildTypeName(t.getRawType(), sb);
            sb.append("<");
            if (t.getActualTypeArguments().length >= 1) {
                this.buildTypeName(t.getActualTypeArguments()[0], sb);
                for (int i = 1; i < t.getActualTypeArguments().length; ++i) {
                    sb.append(", ");
                    this.buildTypeName(t.getActualTypeArguments()[i], sb);
                }
            }
            sb.append(">");
        } else {
            sb.append(type.toString());
        }
    }
}

