/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark.internal.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.MediaType;
import org.restlet.ext.apispark.internal.introspection.IntrospectionHelper;
import org.restlet.ext.apispark.internal.model.Definition;
import org.restlet.ext.apispark.internal.model.Operation;
import org.restlet.ext.apispark.internal.model.Representation;
import org.restlet.ext.apispark.internal.model.Resource;
import org.restlet.ext.apispark.internal.model.Response;
import org.restlet.ext.apispark.internal.model.Section;
import org.restlet.resource.ClientResource;
import org.restlet.resource.ResourceException;

public class IntrospectionUtils {
    public static List<String> STRATEGIES = Arrays.asList("update", "replace");

    public static List<IntrospectionHelper> getIntrospectionHelpers() {
        ArrayList<IntrospectionHelper> introspectionHelpers = new ArrayList<IntrospectionHelper>();
        ServiceLoader<IntrospectionHelper> ihLoader = ServiceLoader.load(IntrospectionHelper.class);
        for (IntrospectionHelper helper : ihLoader) {
            introspectionHelpers.add(helper);
        }
        return introspectionHelpers;
    }

    public static boolean isEmpty(String value) {
        return value == null || value.isEmpty();
    }

    public static void sendDefinition(Definition definition, String ulogin, String upwd, String serviceUrl, String cellType, String cellId, String cellVersion, boolean createNewCell, boolean createNewVersion, boolean updateCell, String updateStrategy, Logger logger) {
        String url = serviceUrl + "api/";
        IntrospectionUtils.sortDefinition(definition);
        ClientResource cr = new ClientResource(url);
        try {
            cr.setChallengeResponse(ChallengeScheme.HTTP_BASIC, ulogin, upwd);
            cr.addQueryParameter("type", "rwadef");
            if (createNewCell) {
                cr.addQueryParameter("cellType", cellType);
                cr.addSegment("apis").addSegment("");
                logger.info("Create a new cell of type " + cellType);
                cr.post((Object)definition, MediaType.APPLICATION_JSON);
            } else if (createNewVersion) {
                cr.addSegment("apis").addSegment(cellId).addSegment("versions").addSegment("");
                logger.info("Create a new version of the cell " + cellId);
                cr.post((Object)definition, MediaType.APPLICATION_JSON);
            } else if (updateCell) {
                cr.addSegment("apis").addSegment(cellId).addSegment("versions").addSegment(cellVersion);
                logger.info("Update version " + cellVersion + " of cell " + cellId + " with strategy " + updateStrategy);
                cr.addQueryParameter("strategy", updateStrategy);
                cr.put((Object)definition, MediaType.APPLICATION_JSON);
            } else {
                throw new RuntimeException("No action error");
            }
            logger.fine("Call success to " + cr.getRequest());
            if (!cr.getResponse().getStatus().isSuccess()) {
                throw new RuntimeException("Request failed with following status: " + cr.getResponse().getStatus());
            }
            if (cr.getResponseEntity() != null && cr.getResponseEntity().isAvailable()) {
                try {
                    cr.getResponseEntity().write((OutputStream)System.out);
                    System.out.println();
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Request successfully achieved by the server, but it's response cannot be printed", e);
                }
            }
            if (cr.getLocationRef() != null) {
                System.out.println("Your Web API documentation is accessible at this URL: " + cr.getLocationRef());
            }
        }
        catch (ResourceException e) {
            logger.fine("Error during call to " + cr.getRequest());
            if (e.getStatus().isConnectorError()) {
                throw new RuntimeException("APISpark communication error. Please check the root cause below.", e);
            }
            if (e.getStatus().isClientError()) {
                if (e.getStatus().getCode() == 403) {
                    throw new RuntimeException("APISpark Authentication fails. Check that you provide valid credentials.", e);
                }
                if (e.getStatus().getCode() == 404) {
                    throw new RuntimeException("Resource not found. Check that you provide valid cell id and cell version.", e);
                }
                throw new RuntimeException("APISpark returns client error. Please check the root cause below.", e);
            }
            throw new RuntimeException("APISpark server encounters some issues, please try later", e);
        }
    }

    public static void sortDefinition(Definition definition) {
        Collections.sort(definition.getContract().getSections(), new Comparator<Section>(){

            @Override
            public int compare(Section o1, Section o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        Collections.sort(definition.getContract().getRepresentations(), new Comparator<Representation>(){

            @Override
            public int compare(Representation o1, Representation o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        Collections.sort(definition.getContract().getResources(), new Comparator<Resource>(){

            @Override
            public int compare(Resource o1, Resource o2) {
                return o1.getResourcePath().compareTo(o2.getResourcePath());
            }
        });
    }

    public static void updateRepresentationsSectionsFromResources(Definition definition) {
        HashMap resourcesLinks = new HashMap();
        HashMap representationsSections = new HashMap();
        for (Resource resource : definition.getContract().getResources()) {
            HashSet<String> representations = new HashSet<String>();
            for (Operation operation : resource.getOperations()) {
                if (operation.getInputPayLoad() != null && operation.getInputPayLoad().getType() != null) {
                    representations.add(operation.getInputPayLoad().getType());
                }
                for (Response response : operation.getResponses()) {
                    if (response.getOutputPayLoad() == null || response.getOutputPayLoad().getType() == null) continue;
                    representations.add(response.getOutputPayLoad().getType());
                }
            }
            resourcesLinks.put(resource, representations);
        }
        for (Map.Entry entry : resourcesLinks.entrySet()) {
            for (String representationIdentifier : (Collection)entry.getValue()) {
                Representation representation = definition.getContract().getRepresentation(representationIdentifier);
                if (representation == null) continue;
                if (representationsSections.get(representation) != null) {
                    ((Collection)representationsSections.get(representation)).addAll(((Resource)entry.getKey()).getSections());
                    continue;
                }
                HashSet<String> representationSections = new HashSet<String>();
                representationSections.addAll(representation.getSections());
                representationSections.addAll(((Resource)entry.getKey()).getSections());
                representationsSections.put(representation, representationSections);
            }
        }
        for (Map.Entry entry : representationsSections.entrySet()) {
            ((Representation)entry.getKey()).setSections(new ArrayList<String>((Collection)entry.getValue()));
        }
    }
}

