/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark.internal.utils;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.ext.apispark.internal.model.Property;
import org.restlet.ext.apispark.internal.model.Representation;
import org.restlet.ext.jackson.JacksonRepresentation;
import org.restlet.service.MetadataService;

public class SampleUtils {
    private static final List<String> supportedExtensions = Arrays.asList("xml", "yaml", "json", "jsonsmile");
    private static final List<String> numberTypes = Arrays.asList("byte", "short", "integer", "long");
    private static final List<String> decimalTypes = Arrays.asList("float", "double");

    public static String convertSampleAccordingToMediaType(Object content, String mediaTypeAsString, String representationName) {
        String text;
        MetadataService ms = new MetadataService();
        MediaType mediaType = MediaType.valueOf((String)mediaTypeAsString);
        if (!supportedExtensions.contains(ms.getExtension((Metadata)mediaType))) {
            return null;
        }
        try {
            text = new JacksonRepresentation(mediaType, content).getText();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (ms.getAllMediaTypes("xml").contains(mediaType)) {
            text = text.replaceAll("HashMap", representationName);
        }
        return text;
    }

    public static Map<String, Object> getRepresentationSample(Representation representation) {
        return SampleUtils.getPropertiesSample(representation.getProperties());
    }

    public static Map<String, Object> getPropertiesSample(List<Property> properties) {
        HashMap<String, Object> content = new HashMap<String, Object>();
        for (Property property : properties) {
            if ("composite".equals(property.getType())) {
                content.put(property.getName(), SampleUtils.getPropertiesSample(property.getProperties()));
                continue;
            }
            List<Object> sampleValue = SampleUtils.getPropertyExampleValue(property);
            if (property.getMaxOccurs() != null && property.getMaxOccurs() != 1) {
                sampleValue = sampleValue != null ? Arrays.asList(sampleValue) : Arrays.asList(new Object[0]);
            }
            content.put(property.getName(), sampleValue);
        }
        return content;
    }

    public static Object getPropertyExampleValue(Property property) {
        return property.getExample() != null ? SampleUtils.convertExampleValue(property.getType(), property.getExample()) : SampleUtils.getPropertyDefaultExampleValue(property.getType(), property.getName());
    }

    public static Object getPropertyDefaultExampleValue(String propertyType, String propertyName) {
        if ("string".equals(propertyType)) {
            return "sample " + propertyName;
        }
        if (numberTypes.contains(propertyType)) {
            return 1;
        }
        if (decimalTypes.contains(propertyType)) {
            return Float.valueOf(1.1f);
        }
        if ("boolean".equals(propertyType)) {
            return false;
        }
        if ("date".equals(propertyType)) {
            return null;
        }
        return null;
    }

    public static Object convertExampleValue(String propertyType, String exampleValue) {
        if ("string".equals(propertyType)) {
            return exampleValue;
        }
        if (numberTypes.contains(propertyType)) {
            return Long.parseLong(exampleValue);
        }
        if (decimalTypes.contains(propertyType)) {
            return Double.parseDouble(exampleValue);
        }
        if ("boolean".equals(propertyType)) {
            return Boolean.parseBoolean(exampleValue);
        }
        if ("date".equals(propertyType)) {
            return exampleValue;
        }
        return null;
    }
}

