/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.atom;

import java.io.IOException;
import java.util.List;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Preference;
import org.restlet.engine.converter.ConverterHelper;
import org.restlet.engine.resource.VariantInfo;
import org.restlet.ext.atom.Feed;
import org.restlet.ext.atom.Service;
import org.restlet.ext.xml.SaxRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.Resource;

public class AtomConverter
extends ConverterHelper {
    private static final VariantInfo VARIANT_ATOM = new VariantInfo(MediaType.APPLICATION_ATOM);
    private static final VariantInfo VARIANT_ATOMPUB_SERVICE = new VariantInfo(MediaType.APPLICATION_ATOMPUB_SERVICE);

    public List<Class<?>> getObjectClasses(Variant source) {
        List result = null;
        if (VARIANT_ATOM.isCompatible(source)) {
            result = this.addObjectClass(result, Feed.class);
        } else if (VARIANT_ATOMPUB_SERVICE.isCompatible(source)) {
            result = this.addObjectClass(result, Service.class);
        }
        return result;
    }

    public List<VariantInfo> getVariants(Class<?> source) {
        List result = null;
        if (Feed.class.isAssignableFrom(source)) {
            result = this.addVariant(result, VARIANT_ATOM);
        } else if (Service.class.isAssignableFrom(source)) {
            result = this.addVariant(result, VARIANT_ATOMPUB_SERVICE);
        }
        return result;
    }

    public float score(Object source, Variant target, Resource resource) {
        float result = -1.0f;
        if (source instanceof Feed) {
            result = target == null ? 0.5f : (MediaType.APPLICATION_ATOM.isCompatible((Metadata)target.getMediaType()) ? 1.0f : 0.5f);
        } else if (source instanceof Service) {
            result = target != null && MediaType.APPLICATION_ATOMPUB_SERVICE.isCompatible((Metadata)target.getMediaType()) ? 1.0f : 0.5f;
        }
        return result;
    }

    public <T> float score(Representation source, Class<T> target, Resource resource) {
        float result = -1.0f;
        if (target != null) {
            if (Feed.class.isAssignableFrom(target)) {
                result = MediaType.APPLICATION_ATOM.isCompatible((Metadata)source.getMediaType()) ? 1.0f : 0.5f;
            } else if (Service.class.isAssignableFrom(target)) {
                result = MediaType.APPLICATION_ATOMPUB_SERVICE.isCompatible((Metadata)source.getMediaType()) ? 1.0f : 0.5f;
            }
        }
        return result;
    }

    public <T> T toObject(Representation source, Class<T> target, Resource resource) throws IOException {
        SaxRepresentation result = null;
        if (Feed.class.isAssignableFrom(target)) {
            result = new Feed(source);
        } else if (Service.class.isAssignableFrom(target)) {
            result = new Service(source);
        }
        return (T)result;
    }

    public Representation toRepresentation(Object source, Variant target, Resource resource) {
        Representation result = null;
        if (source instanceof Representation) {
            result = (Representation)source;
        }
        return result;
    }

    public <T> void updatePreferences(List<Preference<MediaType>> preferences, Class<T> entity) {
        if (Feed.class.isAssignableFrom(entity)) {
            this.updatePreferences(preferences, MediaType.APPLICATION_ATOM, 1.0f);
        } else if (Service.class.isAssignableFrom(entity)) {
            this.updatePreferences(preferences, MediaType.APPLICATION_ATOMPUB_SERVICE, 1.0f);
        }
    }
}

