/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.emf;

import java.io.IOException;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.restlet.data.MediaType;
import org.restlet.data.Preference;
import org.restlet.engine.converter.ConverterHelper;
import org.restlet.engine.resource.VariantInfo;
import org.restlet.ext.emf.EmfRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.Resource;

public class EmfConverter
extends ConverterHelper {
    private static final VariantInfo VARIANT_APPLICATION_ALL_XML = new VariantInfo(MediaType.APPLICATION_ALL_XML);
    private static final VariantInfo VARIANT_APPLICATION_ECORE = new VariantInfo(MediaType.APPLICATION_ECORE);
    private static final VariantInfo VARIANT_APPLICATION_XMI = new VariantInfo(MediaType.APPLICATION_XMI);
    private static final VariantInfo VARIANT_APPLICATION_XML = new VariantInfo(MediaType.APPLICATION_XML);
    private static final VariantInfo VARIANT_TEXT_HTML = new VariantInfo(MediaType.TEXT_HTML);
    private static final VariantInfo VARIANT_TEXT_XML = new VariantInfo(MediaType.TEXT_XML);

    protected <T extends EObject> EmfRepresentation<T> create(MediaType mediaType, T source) {
        return new EmfRepresentation<T>(mediaType, source);
    }

    protected <T extends EObject> EmfRepresentation<T> create(Representation source) {
        return new EmfRepresentation(source);
    }

    public List<Class<?>> getObjectClasses(Variant source) {
        List result = null;
        if (this.isCompatible(source)) {
            result = this.addObjectClass(result, EObject.class);
            result = this.addObjectClass(result, EmfRepresentation.class);
        }
        return result;
    }

    public List<VariantInfo> getVariants(Class<?> source) {
        List result = null;
        if (source != null && EObject.class.isAssignableFrom(source)) {
            result = this.addVariant(result, VARIANT_APPLICATION_ALL_XML);
            result = this.addVariant(result, VARIANT_APPLICATION_XML);
            result = this.addVariant(result, VARIANT_APPLICATION_XMI);
            result = this.addVariant(result, VARIANT_APPLICATION_ECORE);
            result = this.addVariant(result, VARIANT_TEXT_XML);
            result = this.addVariant(result, VARIANT_TEXT_HTML);
        }
        return result;
    }

    protected boolean isCompatible(Variant variant) {
        return variant != null && (VARIANT_APPLICATION_ALL_XML.isCompatible(variant) || VARIANT_APPLICATION_XML.isCompatible(variant) || VARIANT_APPLICATION_XMI.isCompatible(variant) || VARIANT_APPLICATION_ECORE.isCompatible(variant) || VARIANT_TEXT_HTML.isCompatible(variant) || VARIANT_TEXT_XML.isCompatible(variant));
    }

    public float score(Object source, Variant target, Resource resource) {
        float result = -1.0f;
        result = source instanceof EmfRepresentation ? 1.0f : (target == null ? 0.5f : (this.isCompatible(target) ? 0.8f : 0.5f));
        return result;
    }

    public <T> float score(Representation source, Class<T> target, Resource resource) {
        float result = -1.0f;
        if (target != null) {
            if (this.isCompatible((Variant)source)) {
                result = 0.8f;
            }
        } else {
            result = 0.5f;
        }
        return result;
    }

    public <T> T toObject(Representation source, Class<T> target, Resource resource) throws IOException {
        EmfRepresentation<T> emfSource = null;
        if (source instanceof EmfRepresentation) {
            emfSource = (EmfRepresentation<T>)source;
        } else if (this.isCompatible((Variant)source)) {
            emfSource = this.create(source);
        }
        EmfRepresentation<T> result = null;
        if (emfSource != null) {
            result = target != null && EmfRepresentation.class.isAssignableFrom(target) ? emfSource : (EmfRepresentation<T>)((Object)emfSource.getObject());
        }
        return (T)((Object)result);
    }

    public Representation toRepresentation(Object source, Variant target, Resource resource) {
        EmfRepresentation<EObject> result = null;
        if (source instanceof EmfRepresentation) {
            result = (EmfRepresentation<EObject>)((Object)source);
        } else {
            if (target.getMediaType() == null) {
                target.setMediaType(MediaType.TEXT_XML);
            }
            if (this.isCompatible(target)) {
                result = this.create(target.getMediaType(), (EObject)source);
            }
        }
        return result;
    }

    public <T> void updatePreferences(List<Preference<MediaType>> preferences, Class<T> entity) {
        if (EObject.class.isAssignableFrom(entity) || EmfRepresentation.class.isAssignableFrom(entity)) {
            this.updatePreferences(preferences, MediaType.APPLICATION_ALL_XML, 1.0f);
            this.updatePreferences(preferences, MediaType.APPLICATION_XML, 1.0f);
            this.updatePreferences(preferences, MediaType.APPLICATION_XMI, 1.0f);
            this.updatePreferences(preferences, MediaType.APPLICATION_ECORE, 1.0f);
            this.updatePreferences(preferences, MediaType.TEXT_HTML, 1.0f);
            this.updatePreferences(preferences, MediaType.TEXT_XML, 1.0f);
        }
    }
}

