/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.emf;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.EMOFResourceImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLOptionsImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.restlet.data.CharacterSet;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.ext.emf.internal.EmfHtmlWriter;
import org.restlet.representation.OutputRepresentation;
import org.restlet.representation.Representation;

public class EmfRepresentation<T extends EObject>
extends OutputRepresentation {
    private volatile int lineWidth;
    private volatile T object;
    private volatile Representation representation;
    private volatile boolean usingEncodedAttributeStyle;

    public EmfRepresentation(MediaType mediaType, T object) {
        super(mediaType);
        this.object = object;
        this.representation = null;
        this.usingEncodedAttributeStyle = true;
        this.lineWidth = 80;
    }

    public EmfRepresentation(Representation representation) {
        super(representation.getMediaType());
        this.object = null;
        this.representation = representation;
    }

    protected Resource createEmfResource(MediaType mediaType) {
        return this.createEmfXmlResource(mediaType);
    }

    protected XMLResource createEmfXmlResource(MediaType mediaType) {
        Object result = null;
        result = MediaType.APPLICATION_ECORE.isCompatible((Metadata)this.getMediaType()) ? new EMOFResourceImpl() : (MediaType.APPLICATION_XMI.isCompatible((Metadata)this.getMediaType()) ? new XMIResourceImpl() : new XMLResourceImpl());
        if (this.getCharacterSet() != null) {
            result.setEncoding(this.getCharacterSet().getName());
        } else {
            result.setEncoding(CharacterSet.UTF_8.getName());
        }
        result.getDefaultLoadOptions().put("EXTENDED_META_DATA", Boolean.TRUE);
        result.getDefaultLoadOptions().put("USE_LEXICAL_HANDLER", Boolean.TRUE);
        result.getDefaultLoadOptions().put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.TRUE);
        result.getDefaultSaveOptions().put("EXTENDED_META_DATA", Boolean.TRUE);
        result.getDefaultSaveOptions().put("LINE_WIDTH", this.getLineWidth());
        result.getDefaultSaveOptions().put("USE_ENCODED_ATTRIBUTE_STYLE", this.isUsingEncodedAttributeStyle());
        result.getDefaultSaveOptions().put("SCHEMA_LOCATION", Boolean.TRUE);
        XMLOptionsImpl xmlOptions = new XMLOptionsImpl();
        xmlOptions.setProcessAnyXML(true);
        xmlOptions.setProcessSchemaLocations(true);
        result.getDefaultLoadOptions().put("XML_OPTIONS", xmlOptions);
        return result;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    protected Map<?, ?> getLoadOptions() {
        return null;
    }

    public T getObject() throws IOException {
        EObject result = null;
        if (this.object != null) {
            result = (EObject)this.object;
        } else if (this.representation != null) {
            Resource emfResource = this.createEmfResource(this.representation.getMediaType());
            emfResource.load(this.representation.getStream(), this.getLoadOptions());
            result = (EObject)emfResource.getContents().get(0);
        }
        return (T)result;
    }

    protected Map<?, ?> getSaveOptions() {
        return null;
    }

    public boolean isUsingEncodedAttributeStyle() {
        return this.usingEncodedAttributeStyle;
    }

    public void setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
    }

    public void setUsingEncodedAttributeStyle(boolean usingEncodedAttributeStyle) {
        this.usingEncodedAttributeStyle = usingEncodedAttributeStyle;
    }

    public void write(EObject object, OutputStream outputStream) throws IOException {
        if (MediaType.TEXT_HTML.isCompatible((Metadata)this.getMediaType())) {
            EmfHtmlWriter htmlWriter = new EmfHtmlWriter(object);
            htmlWriter.write(new OutputStreamWriter(outputStream, this.getCharacterSet() == null ? CharacterSet.ISO_8859_1.getName() : this.getCharacterSet().getName()));
        } else {
            Resource emfResource = this.createEmfResource(this.getMediaType());
            emfResource.getContents().add((Object)object);
            emfResource.save(outputStream, this.getSaveOptions());
        }
    }

    public void write(OutputStream outputStream) throws IOException {
        if (this.representation != null) {
            this.representation.write(outputStream);
        } else if (this.object != null) {
            this.write((EObject)this.object, outputStream);
        }
    }
}

