/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.emf.internal;

import java.io.IOException;
import java.io.Writer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class EmfHtmlWriter {
    public static final String ANNOTATION_URI = "http://restlet.org/schemas/2011/emf/html";
    private final EObject object;

    public EmfHtmlWriter(EObject object) {
        this.object = object;
    }

    public EObject getObject() {
        return this.object;
    }

    public void write(Writer writer) throws IOException {
        String title = null;
        EClass eClass = this.getObject().eClass();
        EAnnotation annotation = eClass.getEAnnotation(ANNOTATION_URI);
        if (annotation != null) {
            title = (String)annotation.getDetails().get((Object)"label");
        }
        title = title == null ? eClass.getName() : title;
        writer.write("<html>\n");
        writer.write("<body style=\"font-family: sans-serif;\">\n");
        writer.write("<h2>" + title + "</h2>\n");
        writer.write("<table border=\"0\">\n");
        writer.write("<thead>\n");
        writer.write("<tr>");
        writer.write("<td><b>Property</b></td>\n");
        writer.write("<td><b>Value</b></td>\n");
        writer.write("</tr>\n");
        writer.write("</thead>\n");
        writer.write("<tbody>\n");
        for (EObject content : eClass.eContents()) {
            if (!(content instanceof EStructuralFeature)) continue;
            EStructuralFeature sf = (EStructuralFeature)content;
            String label = null;
            boolean hyperlink = false;
            annotation = sf.getEAnnotation(ANNOTATION_URI);
            if (annotation != null) {
                label = (String)annotation.getDetails().get((Object)"label");
                hyperlink = Boolean.parseBoolean((String)annotation.getDetails().get((Object)"linked"));
            }
            label = label == null ? sf.getName() : label;
            Object value = this.getObject().eGet(sf);
            if (value instanceof EList) {
                EList items = (EList)value;
                for (Object item : items) {
                    this.writeRow(writer, label, item.toString(), hyperlink);
                }
                continue;
            }
            this.writeRow(writer, label, value == null ? "null" : value.toString(), hyperlink);
        }
        writer.write("</tbody>\n");
        writer.write("</table>\n");
        writer.write("</body>\n");
        writer.write("</html>\n");
        writer.flush();
    }

    private void writeRow(Writer writer, String name, String value, boolean hyperlink) throws IOException {
        writer.write("<tr>");
        writer.write("<td>");
        writer.write(name);
        writer.write("</td>\n");
        writer.write("<td>");
        if (hyperlink) {
            writer.write("<a href=\"" + value + "\">");
        }
        writer.write(value);
        if (hyperlink) {
            writer.write("</a>");
        }
        writer.write("</td>\n");
        writer.write("</tr>\n");
    }
}

