/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.Date;
import org.joda.time.DateTime;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;
import org.restlet.representation.WriterRepresentation;

public class GsonRepresentation<T>
extends WriterRepresentation {
    private GsonBuilder builder;
    private Representation jsonRepresentation;
    private T object;
    private Class<T> objectClass;

    public GsonRepresentation(Representation representation, Class<T> objectClass) {
        super(representation.getMediaType());
        this.object = null;
        this.objectClass = objectClass;
        this.jsonRepresentation = representation;
        this.builder = null;
    }

    public GsonRepresentation(T object) {
        super(MediaType.APPLICATION_JSON);
        this.object = object;
        this.objectClass = object == null ? null : object.getClass();
        this.jsonRepresentation = null;
        this.builder = null;
    }

    protected GsonBuilder createBuilder() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.setDateFormat(0);
        return gsonBuilder;
    }

    public GsonBuilder getBuilder() {
        if (this.builder == null) {
            this.builder = this.createBuilder().registerTypeAdapter(Date.class, (Object)new ISODateSerializer()).registerTypeAdapter(Date.class, (Object)new ISODateDeserializer());
        }
        return this.builder;
    }

    public T getObject() throws IOException {
        Object result = null;
        if (this.object != null) {
            result = this.object;
        } else if (this.jsonRepresentation != null) {
            Gson gson = this.getBuilder().create();
            result = gson.fromJson(new JsonReader(this.jsonRepresentation.getReader()), this.objectClass);
        }
        return (T)result;
    }

    public Class<T> getObjectClass() {
        return this.objectClass;
    }

    public void setBuilder(GsonBuilder builder) {
        this.builder = builder;
    }

    public void setObject(T object) {
        this.object = object;
    }

    public void setObjectClass(Class<T> objectClass) {
        this.objectClass = objectClass;
    }

    public void write(Writer writer) throws IOException {
        if (this.jsonRepresentation != null) {
            this.jsonRepresentation.write(writer);
        } else {
            Gson gson = this.getBuilder().create();
            gson.toJson(this.object, this.objectClass, new JsonWriter(writer));
        }
    }

    private class ISODateSerializer
    implements JsonSerializer<Date> {
        private ISODateSerializer() {
        }

        public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
            DateTime dt = new DateTime((Object)src);
            return new JsonPrimitive(dt.toString());
        }
    }

    private class ISODateDeserializer
    implements JsonDeserializer<Date> {
        private ISODateDeserializer() {
        }

        public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return new DateTime((Object)json.getAsJsonPrimitive().getAsString()).toDate();
        }
    }
}

