/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.html;

import java.io.IOException;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.data.Disposition;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.util.NamedValue;

public class FormData
implements NamedValue<String> {
    private volatile String name;
    private volatile Representation valueRepresentation;

    public FormData(NamedValue<String> namedValue) {
        this(namedValue.getName(), (String)namedValue.getValue());
    }

    public FormData(String name, Representation valueRepresentation) {
        this.name = name;
        this.valueRepresentation = valueRepresentation;
    }

    public FormData(String name, String value) {
        this.name = name;
        this.setValue(value);
    }

    public String encode(boolean queryString) throws IOException {
        StringBuilder sb = new StringBuilder();
        this.encode(sb, queryString);
        return sb.toString();
    }

    public void encode(Appendable buffer, boolean queryString) throws IOException {
        if (this.getName() != null) {
            buffer.append(Reference.encode((String)this.getName(), (boolean)queryString));
            if (this.getValue() != null) {
                buffer.append('=');
                buffer.append(Reference.encode((String)this.getValue(), (boolean)queryString));
            }
        }
    }

    public Disposition getDisposition() {
        return this.getValueRepresentation() == null ? null : this.getValueRepresentation().getDisposition();
    }

    public String getFilename() {
        return this.getDisposition() == null ? "" : this.getDisposition().getFilename();
    }

    public MediaType getMediaType() {
        return this.getValueRepresentation() == null ? null : this.getValueRepresentation().getMediaType();
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        try {
            return this.getValueRepresentation().getText();
        }
        catch (IOException e) {
            Context.getCurrentLogger().log(Level.INFO, "Unable to get the textual value of the form data value representation", e);
            return null;
        }
    }

    public Representation getValueRepresentation() {
        return this.valueRepresentation;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(String value) {
        if (this.getValueRepresentation() instanceof StringRepresentation) {
            ((StringRepresentation)this.getValueRepresentation()).setText(value);
        } else {
            this.setValueRepresentation((Representation)new StringRepresentation((CharSequence)value));
        }
    }

    public void setValueRepresentation(Representation valueRepresentation) {
        this.valueRepresentation = valueRepresentation;
    }

    public String toString() {
        return "(" + this.getName() + "," + this.getValueRepresentation() + ")";
    }
}

