/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.httpclient.internal;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.logging.Level;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.message.BasicHeader;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Uniform;
import org.restlet.data.Header;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.data.Status;
import org.restlet.engine.adapter.ClientCall;
import org.restlet.ext.httpclient.HttpClientHelper;
import org.restlet.representation.Representation;
import org.restlet.util.Series;

public class HttpMethodCall
extends ClientCall {
    private volatile HttpClientHelper clientHelper;
    private volatile HttpUriRequest httpRequest;
    private volatile HttpResponse httpResponse;
    private volatile boolean responseHeadersAdded;

    public HttpMethodCall(HttpClientHelper helper, final String method, final String requestUri, boolean hasEntity) throws IOException {
        super((org.restlet.engine.adapter.HttpClientHelper)helper, method, requestUri);
        this.clientHelper = helper;
        if (requestUri.startsWith("http")) {
            if (method.equalsIgnoreCase(Method.GET.getName())) {
                this.httpRequest = new HttpGet(requestUri);
            } else if (method.equalsIgnoreCase(Method.POST.getName())) {
                this.httpRequest = new HttpPost(requestUri);
            } else if (method.equalsIgnoreCase(Method.PUT.getName())) {
                this.httpRequest = new HttpPut(requestUri);
            } else if (method.equalsIgnoreCase(Method.HEAD.getName())) {
                this.httpRequest = new HttpHead(requestUri);
            } else if (method.equalsIgnoreCase(Method.DELETE.getName())) {
                this.httpRequest = new HttpDelete(requestUri);
                if (hasEntity) {
                    this.getLogger().warning("The current DELETE request provides an entity that may be not supported by the Apache HTTP Client library. If you face such issues, you can still move to another HTTP client connector.");
                }
            } else {
                this.httpRequest = method.equalsIgnoreCase(Method.OPTIONS.getName()) ? new HttpOptions(requestUri) : (method.equalsIgnoreCase(Method.TRACE.getName()) ? new HttpTrace(requestUri) : new HttpEntityEnclosingRequestBase(){

                    public String getMethod() {
                        return method;
                    }

                    public URI getURI() {
                        try {
                            return new URI(requestUri);
                        }
                        catch (URISyntaxException e) {
                            HttpMethodCall.this.getLogger().log(Level.WARNING, "Invalid URI syntax", e);
                            return null;
                        }
                    }
                });
            }
        } else {
            throw new IllegalArgumentException("Only HTTP or HTTPS resource URIs are allowed here");
        }
        this.responseHeadersAdded = false;
        this.setConfidential(this.httpRequest.getURI().getScheme().equalsIgnoreCase(Protocol.HTTPS.getSchemeName()));
    }

    public HttpUriRequest getHttpRequest() {
        return this.httpRequest;
    }

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    public String getReasonPhrase() {
        if (this.getHttpResponse() != null && this.getHttpResponse().getStatusLine() != null) {
            return this.getHttpResponse().getStatusLine().getReasonPhrase();
        }
        return null;
    }

    public WritableByteChannel getRequestEntityChannel() {
        return null;
    }

    public OutputStream getRequestEntityStream() {
        return null;
    }

    public OutputStream getRequestHeadStream() {
        return null;
    }

    public ReadableByteChannel getResponseEntityChannel(long size) {
        return null;
    }

    public InputStream getResponseEntityStream(long size) {
        FilterInputStream result = null;
        try {
            InputStream responseStream;
            InputStream inputStream = this.getHttpResponse() == null ? null : (responseStream = this.getHttpResponse().getEntity() == null ? null : this.getHttpResponse().getEntity().getContent());
            if (responseStream != null) {
                result = new FilterInputStream(responseStream){

                    @Override
                    public void close() throws IOException {
                        super.close();
                        HttpMethodCall.this.getHttpResponse().getEntity().consumeContent();
                    }
                };
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return result;
    }

    public Series<Header> getResponseHeaders() {
        Series result = super.getResponseHeaders();
        if (!this.responseHeadersAdded) {
            if (this.getHttpResponse() != null && this.getHttpResponse().getAllHeaders() != null) {
                for (org.apache.http.Header header : this.getHttpResponse().getAllHeaders()) {
                    result.add(header.getName(), header.getValue());
                }
            }
            this.responseHeadersAdded = true;
        }
        return result;
    }

    public String getServerAddress() {
        return this.getHttpRequest().getURI().getHost();
    }

    public int getStatusCode() {
        if (this.getHttpResponse() != null && this.getHttpResponse().getStatusLine() != null) {
            return this.getHttpResponse().getStatusLine().getStatusCode();
        }
        return Status.CONNECTOR_ERROR_COMMUNICATION.getCode();
    }

    public Status sendRequest(Request request) {
        Status result = null;
        try {
            final Representation entity = request.getEntity();
            for (Header header : this.getRequestHeaders()) {
                if (header.getName().equals("Content-Length")) continue;
                this.getHttpRequest().addHeader(header.getName(), header.getValue());
            }
            if (entity != null && this.getHttpRequest() instanceof HttpEntityEnclosingRequestBase) {
                HttpEntityEnclosingRequestBase eem = (HttpEntityEnclosingRequestBase)this.getHttpRequest();
                eem.setEntity((HttpEntity)new AbstractHttpEntity(){

                    public InputStream getContent() throws IOException, IllegalStateException {
                        return entity.getStream();
                    }

                    public long getContentLength() {
                        return entity.getSize();
                    }

                    public org.apache.http.Header getContentType() {
                        return new BasicHeader("Content-Type", entity.getMediaType() != null ? entity.getMediaType().toString() : null);
                    }

                    public boolean isRepeatable() {
                        return !entity.isTransient();
                    }

                    public boolean isStreaming() {
                        return entity.getSize() == -1L;
                    }

                    public void writeTo(OutputStream os) throws IOException {
                        entity.write(os);
                        os.flush();
                    }
                });
            }
            this.httpResponse = this.clientHelper.getHttpClient().execute(this.getHttpRequest());
            result = new Status(this.getStatusCode(), this.getReasonPhrase());
        }
        catch (IOException ioe) {
            this.clientHelper.getLogger().log(Level.WARNING, "An error occurred during the communication with the remote HTTP server.", ioe);
            result = new Status(Status.CONNECTOR_ERROR_COMMUNICATION, (Throwable)ioe);
            this.getHttpRequest().abort();
        }
        return result;
    }

    public void sendRequest(Request request, Response response, Uniform callback) throws Exception {
        this.sendRequest(request);
        if (request.getOnSent() != null) {
            request.getOnSent().handle(request, response);
        }
        if (callback != null) {
            callback.handle(request, response);
        }
    }
}

