/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaas;

import java.security.AccessControlContext;
import java.security.Principal;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import org.restlet.data.ClientInfo;
import org.restlet.security.Role;

public final class JaasUtils {
    public static Subject createSubject(ClientInfo clientInfo) {
        Subject result = new Subject();
        if (clientInfo != null) {
            if (clientInfo.getUser() != null) {
                result.getPrincipals().add((Principal)clientInfo.getUser());
            }
            for (Role role : clientInfo.getRoles()) {
                result.getPrincipals().add((Principal)role);
            }
            for (Principal principal : clientInfo.getPrincipals()) {
                result.getPrincipals().add(principal);
            }
        }
        return result;
    }

    public static <T> T doAsPriviledged(ClientInfo clientInfo, PrivilegedAction<T> action) {
        return JaasUtils.doAsPriviledged(clientInfo, action, null);
    }

    public static <T> T doAsPriviledged(ClientInfo clientInfo, PrivilegedAction<T> action, AccessControlContext acc) {
        Subject subject = JaasUtils.createSubject(clientInfo);
        T result = Subject.doAsPrivileged(subject, action, acc);
        return result;
    }
}

