/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jackson.internal;

import java.util.logging.Level;
import org.codehaus.stax2.osgi.Stax2InputFactoryProvider;
import org.codehaus.stax2.osgi.Stax2OutputFactoryProvider;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.restlet.Context;
import org.restlet.ext.jackson.internal.XmlFactoryProvider;

public class Activator
implements BundleActivator {
    public void start(final BundleContext bundleContext) throws Exception {
        ServiceReference outputFactoryServiceReference;
        ServiceReference inputFactoryServiceReference = bundleContext.getServiceReference("org.codehaus.stax2.osgi.Stax2InputFactoryProvider");
        if (inputFactoryServiceReference != null) {
            Stax2InputFactoryProvider inputFactoryProvider = (Stax2InputFactoryProvider)bundleContext.getService(inputFactoryServiceReference);
            this.registerInputFactory(inputFactoryProvider);
        }
        if ((outputFactoryServiceReference = bundleContext.getServiceReference("org.codehaus.stax2.osgi.Stax2OutputFactoryProvider")) != null) {
            Stax2OutputFactoryProvider outputFactoryProvider = (Stax2OutputFactoryProvider)bundleContext.getService(outputFactoryServiceReference);
            this.registerOutputFactory(outputFactoryProvider);
        }
        bundleContext.addServiceListener(new ServiceListener(){

            public void serviceChanged(ServiceEvent serviceEvent) {
                switch (serviceEvent.getType()) {
                    case 1: 
                    case 2: {
                        ServiceReference serviceReference = serviceEvent.getServiceReference();
                        Stax2InputFactoryProvider factoryProvider = (Stax2InputFactoryProvider)bundleContext.getService(serviceReference);
                        Activator.this.registerInputFactory(factoryProvider);
                        break;
                    }
                    case 4: {
                        Activator.this.unregisterInputFactory();
                    }
                }
            }
        }, "(objectclass=org.codehaus.stax2.osgi.Stax2InputFactoryProvider)");
        bundleContext.addServiceListener(new ServiceListener(){

            public void serviceChanged(ServiceEvent serviceEvent) {
                switch (serviceEvent.getType()) {
                    case 1: 
                    case 2: {
                        ServiceReference serviceReference = serviceEvent.getServiceReference();
                        Stax2OutputFactoryProvider factoryProvider = (Stax2OutputFactoryProvider)bundleContext.getService(serviceReference);
                        Activator.this.registerOutputFactory(factoryProvider);
                        break;
                    }
                    case 4: {
                        Activator.this.unregisterOutputFactory();
                    }
                }
            }
        }, "(objectclass=org.codehaus.stax2.osgi.Stax2OutputFactoryProvider)");
    }

    private void registerInputFactory(Stax2InputFactoryProvider inputFactoryProvider) {
        Context.getCurrentLogger().log(Level.INFO, "Register Stax2InputFactoryProvider");
        XmlFactoryProvider.inputFactoryProvider = inputFactoryProvider;
    }

    private void unregisterInputFactory() {
        Context.getCurrentLogger().log(Level.INFO, "Unregister Stax2InputFactoryProvider");
        XmlFactoryProvider.inputFactoryProvider = null;
    }

    private void registerOutputFactory(Stax2OutputFactoryProvider outputFactoryProvider) {
        Context.getCurrentLogger().log(Level.INFO, "Register Stax2OutputFactoryProvider");
        XmlFactoryProvider.outputFactoryProvider = outputFactoryProvider;
    }

    private void unregisterOutputFactory() {
        Context.getCurrentLogger().log(Level.INFO, "Unregister Stax2OutputFactoryProvider");
        XmlFactoryProvider.outputFactoryProvider = null;
    }

    public void stop(BundleContext bundleContext) throws Exception {
    }
}

