/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.javamail;

import com.sun.mail.pop3.POP3Folder;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.UIDFolder;
import javax.mail.internet.AddressException;
import org.restlet.Client;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.data.Status;
import org.restlet.engine.connector.ClientHelper;
import org.restlet.ext.javamail.MessageRepresentation;
import org.restlet.ext.javamail.MessagesRepresentation;
import org.restlet.ext.javamail.RepresentationMessage;
import org.restlet.representation.Representation;
import org.w3c.dom.DOMException;

public class JavaMailClientHelper
extends ClientHelper {
    public JavaMailClientHelper(Client client) {
        super(client);
        this.getProtocols().add(Protocol.SMTP);
        this.getProtocols().add(Protocol.SMTPS);
        this.getProtocols().add(Protocol.POP);
        this.getProtocols().add(Protocol.POPS);
    }

    protected Message createMessage(Representation xmlMessage, Session session) throws IOException, AddressException, MessagingException {
        String representationMessageClassName = this.getRepresentationMessageClass();
        if (representationMessageClassName == null) {
            return new RepresentationMessage(xmlMessage, session);
        }
        try {
            Class<?> representationMessageClass = Class.forName(representationMessageClassName);
            return (Message)representationMessageClass.getConstructor(Representation.class, Session.class).newInstance(xmlMessage, session);
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Unable to create a new instance of " + representationMessageClassName, e);
            return new RepresentationMessage(xmlMessage, session);
        }
    }

    protected Representation createRepresentation(Message message) throws DOMException, IOException, MessagingException {
        return new MessageRepresentation(message);
    }

    protected Representation createRepresentation(Message[] messages, POP3Folder inbox) throws IOException, MessagingException {
        return new MessagesRepresentation(messages, inbox);
    }

    private String getLogin(Request request) {
        if (request != null && request.getChallengeResponse() != null) {
            return request.getChallengeResponse().getIdentifier();
        }
        return null;
    }

    private String getPassword(Request request) {
        if (request != null && request.getChallengeResponse() != null) {
            return new String(request.getChallengeResponse().getSecret());
        }
        return null;
    }

    public String getRepresentationMessageClass() {
        return this.getHelpedParameters().getFirstValue("representationMessageClass");
    }

    public void handle(Request request, Response response) {
        try {
            Protocol protocol = request.getProtocol();
            if (Protocol.SMTP.equals((Object)protocol) || Protocol.SMTPS.equals((Object)protocol)) {
                this.handleSmtp(request, response);
            } else if (Protocol.POP.equals((Object)protocol) || Protocol.POPS.equals((Object)protocol)) {
                this.handlePop(request, response);
            }
        }
        catch (IOException e) {
            this.getLogger().log(Level.WARNING, "JavaMail client error", e);
            response.setStatus(Status.CONNECTOR_ERROR_INTERNAL, e.getMessage());
        }
        catch (NoSuchProviderException e) {
            this.getLogger().log(Level.WARNING, "JavaMail client error", e);
            response.setStatus(Status.SERVER_ERROR_INTERNAL, e.getMessage());
        }
        catch (AddressException e) {
            this.getLogger().log(Level.WARNING, "JavaMail client error", e);
            response.setStatus(Status.CLIENT_ERROR_BAD_REQUEST, e.getMessage());
        }
        catch (MessagingException e) {
            this.getLogger().log(Level.WARNING, "JavaMail client error", e);
            response.setStatus(Status.SERVER_ERROR_INTERNAL, e.getMessage());
        }
    }

    private void handlePop(Request request, Response response) throws MessagingException, IOException {
        String popHost = request.getResourceRef().getHostDomain();
        int popPort = request.getResourceRef().getHostPort();
        String path = request.getResourceRef().getPath();
        if (popPort == -1) {
            popPort = request.getProtocol().getDefaultPort();
        }
        if (popHost == null || popHost.equals("")) {
            throw new IllegalArgumentException("Invalid POP host specified");
        }
        boolean authenticate = this.getLogin(request) != null && this.getPassword(request) != null;
        boolean apop = authenticate && ChallengeScheme.POP_DIGEST.equals((Object)request.getChallengeResponse().getScheme());
        String transport = null;
        if (Protocol.POP.equals((Object)request.getProtocol())) {
            transport = "pop3";
        } else if (Protocol.POPS.equals((Object)request.getProtocol())) {
            transport = "pop3s";
        }
        Properties props = System.getProperties();
        props.put("mail." + transport + ".host", popHost);
        props.put("mail." + transport + ".port", Integer.toString(popPort));
        props.put("mail." + transport + ".apop.enable", Boolean.toString(apop));
        boolean updateFolder = false;
        Session session = Session.getDefaultInstance((Properties)props);
        session.setDebug(this.isDebug());
        Store store = session.getStore(transport);
        store.connect(this.getLogin(request), this.getPassword(request));
        POP3Folder inbox = (POP3Folder)store.getFolder("INBOX");
        inbox.open(2);
        FetchProfile profile = new FetchProfile();
        profile.add((FetchProfile.Item)UIDFolder.FetchProfileItem.UID);
        Message[] messages = inbox.getMessages();
        inbox.fetch(messages, profile);
        if (path == null || path.equals("") || path.equals("/")) {
            if (Method.GET.equals((Object)request.getMethod()) || Method.HEAD.equals((Object)request.getMethod())) {
                response.setEntity(this.createRepresentation(messages, inbox));
            } else {
                response.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
                response.getAllowedMethods().add(Method.GET);
                response.getAllowedMethods().add(Method.HEAD);
            }
        } else if (path.startsWith("/")) {
            String mailUid = path.substring(1);
            Message message = null;
            for (int i = 0; message == null && i < messages.length; ++i) {
                String uid = inbox.getUID(messages[i]);
                if (!mailUid.equals(uid)) continue;
                message = messages[i];
            }
            if (message == null) {
                response.setStatus(Status.CLIENT_ERROR_NOT_FOUND, "No message matches the given UID: " + mailUid);
            } else if (Method.GET.equals((Object)request.getMethod()) || Method.HEAD.equals((Object)request.getMethod())) {
                response.setEntity(this.createRepresentation(message));
            } else if (Method.DELETE.equals((Object)request.getMethod())) {
                message.setFlag(Flags.Flag.DELETED, true);
                updateFolder = true;
            } else {
                response.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
                response.getAllowedMethods().add(Method.GET);
                response.getAllowedMethods().add(Method.HEAD);
                response.getAllowedMethods().add(Method.DELETE);
            }
        }
        inbox.close(updateFolder);
        store.close();
    }

    private void handleSmtp(Request request, Response response) throws IOException, MessagingException {
        if (!Method.POST.equals((Object)request.getMethod())) {
            response.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
            response.getAllowedMethods().add(Method.POST);
        } else {
            String smtpHost = request.getResourceRef().getHostDomain();
            int smtpPort = request.getResourceRef().getHostPort();
            if (smtpPort == -1) {
                smtpPort = request.getProtocol().getDefaultPort();
            }
            if (smtpHost == null || smtpHost.equals("")) {
                throw new IllegalArgumentException("Invalid SMTP host specified");
            }
            boolean authenticate = this.getLogin(request) != null && this.getPassword(request) != null;
            String transport = null;
            if (Protocol.SMTP.equals((Object)request.getProtocol())) {
                transport = "smtp";
            } else if (Protocol.SMTPS.equals((Object)request.getProtocol())) {
                transport = "smtps";
            }
            Properties props = System.getProperties();
            props.put("mail." + transport + ".host", smtpHost);
            props.put("mail." + transport + ".port", Integer.toString(smtpPort));
            props.put("mail." + transport + ".auth", Boolean.toString(authenticate).toLowerCase());
            props.put("mail." + transport + ".starttls.enable", Boolean.toString(this.isStartTls()));
            Session session = Session.getDefaultInstance((Properties)props);
            session.setDebug(this.isDebug());
            Transport tr = session.getTransport(transport);
            if (tr != null) {
                if (authenticate) {
                    tr.connect(smtpHost, this.getLogin(request), this.getPassword(request));
                } else {
                    tr.connect();
                }
                if (tr.isConnected()) {
                    this.getLogger().info("JavaMail client connection successfully established. Attempting to send the message");
                    Message msg = this.createMessage(request.getEntity(), session);
                    tr.sendMessage(msg, msg.getAllRecipients());
                    tr.close();
                    this.getLogger().info("JavaMail client successfully sent the message.");
                }
            }
        }
    }

    public boolean isDebug() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("debug", "false"));
    }

    public boolean isStartTls() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("startTls", "false"));
    }
}

