/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaxrs.internal.core;

import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.restlet.Response;
import org.restlet.data.Dimension;
import org.restlet.ext.jaxrs.internal.core.ResponseImpl;
import org.restlet.ext.jaxrs.internal.util.Converter;
import org.restlet.ext.jaxrs.internal.util.Util;

public class ResponseBuilderImpl
extends Response.ResponseBuilder {
    private MultivaluedMap<String, Object> metadata;
    private Map<String, NewCookie> newCookies;
    private ResponseImpl response;

    public javax.ws.rs.core.Response build() {
        if (this.response == null) {
            return new ResponseImpl();
        }
        ResponseImpl r = this.response;
        if (this.newCookies != null) {
            MultivaluedMap<String, Object> metadata = this.getMetadata();
            for (NewCookie cookie : this.newCookies.values()) {
                metadata.add((Object)"Set-Cookie", (Object)cookie);
            }
            this.newCookies = null;
        }
        this.response = null;
        this.metadata = null;
        return r;
    }

    public Response.ResponseBuilder cacheControl(CacheControl cacheControl) {
        if (cacheControl == null) {
            this.getMetadata().remove((Object)"Cache-Control");
        } else {
            this.getMetadata().putSingle((Object)"Cache-Control", (Object)cacheControl);
        }
        return this;
    }

    public ResponseBuilderImpl clone() {
        ResponseBuilderImpl newRb = new ResponseBuilderImpl();
        newRb.response = this.response.clone();
        newRb.newCookies = new HashMap<String, NewCookie>(this.newCookies);
        return newRb;
    }

    public Response.ResponseBuilder contentLocation(URI location) {
        if (location == null) {
            this.getMetadata().remove((Object)"Content-Location");
        } else {
            this.getMetadata().putSingle((Object)"Content-Location", (Object)location.toASCIIString());
        }
        return this;
    }

    public Response.ResponseBuilder cookie(NewCookie ... cookies) {
        Map<String, NewCookie> newCookies = this.getNewCookies();
        for (NewCookie cookie : cookies) {
            if (cookie == null) continue;
            newCookies.put(cookie.getName(), cookie);
        }
        return this;
    }

    public Response.ResponseBuilder encoding(String encoding) {
        if (encoding == null) {
            this.getMetadata().remove((Object)"Content-Encoding");
        } else {
            this.getMetadata().putSingle((Object)"Content-Encoding", (Object)encoding);
        }
        return this;
    }

    public Response.ResponseBuilder entity(Object entity) {
        this.getResponse().setEntity(entity);
        return this;
    }

    public Response.ResponseBuilder expires(Date expires) {
        if (expires == null) {
            this.getMetadata().remove((Object)"Expires");
        } else {
            this.getMetadata().putSingle((Object)"Expires", (Object)expires);
        }
        return this;
    }

    MultivaluedMap<String, Object> getMetadata() {
        if (this.metadata == null) {
            this.metadata = this.getResponse().getMetadata();
        }
        return this.metadata;
    }

    Map<String, NewCookie> getNewCookies() {
        if (this.newCookies == null) {
            this.newCookies = new HashMap<String, NewCookie>();
        }
        return this.newCookies;
    }

    ResponseImpl getResponse() {
        if (this.response == null) {
            this.response = new ResponseImpl();
        }
        return this.response;
    }

    public Response.ResponseBuilder header(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("You must give a name of the header");
        }
        if (name.equals("Set-Cookie")) {
            if (value == null) {
                this.newCookies.clear();
            } else if (value instanceof NewCookie) {
                this.cookie((NewCookie)value);
            } else if (value instanceof Cookie) {
                this.cookie(new NewCookie((Cookie)value));
            } else {
                this.cookie(NewCookie.valueOf((String)value.toString()));
            }
        } else if (value == null) {
            this.getMetadata().remove((Object)name);
        } else {
            this.getMetadata().add((Object)name, value);
        }
        return this;
    }

    public Response.ResponseBuilder language(Locale language) {
        if (language == null) {
            this.getMetadata().remove((Object)"Content-Language");
        } else {
            this.getMetadata().putSingle((Object)"Content-Language", (Object)language);
        }
        return this;
    }

    public Response.ResponseBuilder language(String language) {
        if (language == null) {
            this.getMetadata().remove((Object)"Content-Language");
        } else {
            this.getMetadata().putSingle((Object)"Content-Language", (Object)language);
        }
        return this;
    }

    public Response.ResponseBuilder lastModified(Date lastModified) {
        if (lastModified == null) {
            this.getMetadata().remove((Object)"Last-Modified");
        } else {
            this.getMetadata().putSingle((Object)"Last-Modified", (Object)lastModified);
        }
        return this;
    }

    public Response.ResponseBuilder location(URI location) {
        if (location == null) {
            this.getMetadata().remove((Object)"Location");
        } else {
            this.getMetadata().putSingle((Object)"Location", (Object)location);
        }
        return this;
    }

    public Response.ResponseBuilder status(int status) {
        if (status < 100 || status >= 600) {
            throw new IllegalArgumentException("The status must be between 100 (inclusive) and 600 (exclusive), but is " + status);
        }
        if (this.response == null) {
            this.response = new ResponseImpl(status);
        } else {
            this.response.setStatus(status);
        }
        return this;
    }

    public Response.ResponseBuilder tag(EntityTag tag) {
        if (tag == null) {
            this.getMetadata().remove((Object)"ETag");
        } else {
            this.getMetadata().putSingle((Object)"ETag", (Object)tag);
        }
        return this;
    }

    public Response.ResponseBuilder tag(String tag) {
        if (tag == null) {
            this.tag((EntityTag)null);
        } else {
            this.tag(new EntityTag(tag, false));
        }
        return this;
    }

    public Response.ResponseBuilder type(MediaType type) {
        if (type == null) {
            this.getMetadata().remove((Object)"Content-Type");
        } else {
            this.getMetadata().putSingle((Object)"Content-Type", (Object)type);
        }
        return this;
    }

    public Response.ResponseBuilder type(String type) {
        if (type == null) {
            return this.type((MediaType)null);
        }
        return this.type(MediaType.valueOf((String)type));
    }

    public Response.ResponseBuilder variant(Variant variant) {
        if (variant == null) {
            this.language((String)null);
            this.encoding(null);
            this.type((MediaType)null);
        } else {
            this.language(variant.getLanguage());
            this.encoding(variant.getEncoding());
            this.type(variant.getMediaType());
        }
        return this;
    }

    public Response.ResponseBuilder variants(List<Variant> variants) {
        String vary;
        if (variants == null) {
            this.getMetadata().remove((Object)"Vary");
            return this;
        }
        HashSet<String> encodings = new HashSet<String>();
        HashSet<Locale> languages = new HashSet<Locale>();
        HashSet<MediaType> mediaTypes = new HashSet<MediaType>();
        HashSet<String> charsets = new HashSet<String>();
        for (Variant variant : variants) {
            String charset;
            MediaType mediaType;
            Locale language;
            String encoding = variant.getEncoding();
            if (encoding != null) {
                encodings.add(encoding);
            }
            if ((language = variant.getLanguage()) != null) {
                languages.add(language);
            }
            if ((mediaType = variant.getMediaType()) != null) {
                mediaTypes.add(Converter.getMediaTypeWithoutParams(mediaType));
            }
            if ((charset = Converter.getCharset(mediaType)) == null) continue;
            charsets.add(charset);
        }
        Set dimensions = Response.getCurrent().getDimensions();
        if (encodings.size() > 1) {
            dimensions.add(Dimension.ENCODING);
        }
        if (languages.size() > 1) {
            dimensions.add(Dimension.LANGUAGE);
        }
        if (mediaTypes.size() > 1) {
            dimensions.add(Dimension.MEDIA_TYPE);
        }
        if (charsets.size() > 1) {
            dimensions.add(Dimension.CHARACTER_SET);
        }
        if ((vary = Util.formatDimensions(dimensions)) != null) {
            this.getMetadata().putSingle((Object)"Vary", (Object)vary);
        }
        return this;
    }
}

