/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaxrs.internal.wrappers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Encoded;
import javax.ws.rs.Path;
import org.restlet.data.Method;
import org.restlet.engine.util.SystemUtils;
import org.restlet.ext.jaxrs.internal.core.ThreadLocalizedContext;
import org.restlet.ext.jaxrs.internal.exceptions.IllegalMethodParamTypeException;
import org.restlet.ext.jaxrs.internal.exceptions.IllegalParamTypeException;
import org.restlet.ext.jaxrs.internal.exceptions.IllegalPathOnClassException;
import org.restlet.ext.jaxrs.internal.exceptions.IllegalPathOnMethodException;
import org.restlet.ext.jaxrs.internal.exceptions.MissingAnnotationException;
import org.restlet.ext.jaxrs.internal.util.PathRegExp;
import org.restlet.ext.jaxrs.internal.util.RemainingPath;
import org.restlet.ext.jaxrs.internal.wrappers.AbstractJaxRsWrapper;
import org.restlet.ext.jaxrs.internal.wrappers.ResourceMethod;
import org.restlet.ext.jaxrs.internal.wrappers.ResourceMethodOrLocator;
import org.restlet.ext.jaxrs.internal.wrappers.SubResourceLocator;
import org.restlet.ext.jaxrs.internal.wrappers.WrapperUtil;
import org.restlet.ext.jaxrs.internal.wrappers.provider.ExtensionBackwardMapping;
import org.restlet.ext.jaxrs.internal.wrappers.provider.JaxRsProviders;

public class ResourceClass
extends AbstractJaxRsWrapper {
    private final Map<RemainingPath, Set<Method>> allowedMethods = new HashMap<RemainingPath, Set<Method>>();
    protected final Class<?> jaxRsClass;
    private final boolean leaveEncoded;
    private final Collection<ResourceMethod> resourceMethods = new ArrayList<ResourceMethod>();
    private final Collection<ResourceMethodOrLocator> resourceMethodsAndLocators = new ArrayList<ResourceMethodOrLocator>();
    private final Collection<SubResourceLocator> subResourceLocators = new ArrayList<SubResourceLocator>();

    protected ResourceClass(Class<?> jaxRsClass, JaxRsProviders jaxRsProviders, ThreadLocalizedContext tlContext, ExtensionBackwardMapping extensionBackwardMapping, Logger logger) throws IllegalArgumentException, IllegalPathOnClassException, MissingAnnotationException {
        super(PathRegExp.createForClass(jaxRsClass));
        this.leaveEncoded = jaxRsClass.isAnnotationPresent(Encoded.class);
        this.jaxRsClass = jaxRsClass;
        this.initResourceMethodsAndLocators(tlContext, jaxRsProviders, extensionBackwardMapping, logger);
    }

    ResourceClass(Class<?> jaxRsClass, ThreadLocalizedContext tlContext, JaxRsProviders jaxRsProviders, ExtensionBackwardMapping extensionBackwardMapping, Logger logger) throws IllegalArgumentException, MissingAnnotationException {
        this.leaveEncoded = jaxRsClass.isAnnotationPresent(Encoded.class);
        this.jaxRsClass = jaxRsClass;
        this.initResourceMethodsAndLocators(tlContext, jaxRsProviders, extensionBackwardMapping, logger);
    }

    private void checkForPrimitiveParameters(java.lang.reflect.Method execMethod, Logger logger) {
        Class<?>[] paramTypes;
        for (Class<?> paramType : paramTypes = execMethod.getParameterTypes()) {
            if (!paramType.isPrimitive()) continue;
            logger.config("The method " + execMethod + " contains a primitive parameter " + paramType + ".");
            logger.config("It is recommended to use it's wrapper class. If no value could be read from the request, now you would got the default value. If you use the wrapper class, you would get null.");
            break;
        }
    }

    public boolean equals(Object anotherObject) {
        if (this == anotherObject) {
            return true;
        }
        if (!(anotherObject instanceof ResourceClass)) {
            return false;
        }
        ResourceClass otherResourceClass = (ResourceClass)anotherObject;
        return this.jaxRsClass.equals(otherResourceClass.jaxRsClass);
    }

    public Set<Method> getAllowedMethods(RemainingPath remainingPath) {
        Set<Method> allowedMethods = this.allowedMethods.get(remainingPath);
        if (allowedMethods != null) {
            return allowedMethods;
        }
        allowedMethods = new HashSet<Method>(6);
        for (ResourceMethod rm : this.getMethodsForPath(remainingPath)) {
            allowedMethods.add(rm.getHttpMethod());
        }
        if (!allowedMethods.isEmpty() && allowedMethods.contains(Method.GET)) {
            allowedMethods.add(Method.HEAD);
        }
        Set<Method> unmodifiable = Collections.unmodifiableSet(allowedMethods);
        this.allowedMethods.put(remainingPath, unmodifiable);
        return unmodifiable;
    }

    private java.lang.reflect.Method getAnnotatedJavaMethod(java.lang.reflect.Method javaMethod) {
        Class<?>[] interfaces;
        if (javaMethod == null) {
            return null;
        }
        boolean useMethod = WrapperUtil.checkForJaxRsAnnotations(javaMethod);
        if (useMethod) {
            return javaMethod;
        }
        Class<?> methodClass = javaMethod.getDeclaringClass();
        Class<?> superclass = methodClass.getSuperclass();
        java.lang.reflect.Method scMethod = this.getMethodFromClass(superclass, javaMethod);
        java.lang.reflect.Method annotatedMeth = this.getAnnotatedJavaMethod(scMethod);
        if (annotatedMeth != null) {
            return annotatedMeth;
        }
        for (Class<?> interfaze : interfaces = methodClass.getInterfaces()) {
            java.lang.reflect.Method ifMethod = this.getMethodFromClass(interfaze, javaMethod);
            annotatedMeth = this.getAnnotatedJavaMethod(ifMethod);
            if (annotatedMeth == null) continue;
            return annotatedMeth;
        }
        return null;
    }

    public final Class<?> getJaxRsClass() {
        return this.jaxRsClass;
    }

    private java.lang.reflect.Method getMethodFromClass(Class<?> clazz, java.lang.reflect.Method subClassMethod) {
        if (clazz == null) {
            return null;
        }
        String methodName = subClassMethod.getName();
        Class<?>[] parameterTypes = subClassMethod.getParameterTypes();
        try {
            return clazz.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public Collection<ResourceMethod> getMethodsForPath(RemainingPath remainingPath) {
        ArrayList<ResourceMethod> resourceMethods = new ArrayList<ResourceMethod>();
        for (ResourceMethod method : this.resourceMethods) {
            PathRegExp methodPath = method.getPathRegExp();
            if (remainingPath.isEmptyOrSlash()) {
                if (!methodPath.isEmptyOrSlash()) continue;
                resourceMethods.add(method);
                continue;
            }
            if (!methodPath.matchesWithEmpty(remainingPath)) continue;
            resourceMethods.add(method);
        }
        return resourceMethods;
    }

    public String getName() {
        return this.jaxRsClass.getName();
    }

    public final Iterable<ResourceMethod> getResourceMethods() {
        return this.resourceMethods;
    }

    public final Collection<ResourceMethodOrLocator> getResourceMethodsAndLocators() {
        return this.resourceMethodsAndLocators;
    }

    public final Iterable<SubResourceLocator> getSubResourceLocators() {
        return this.subResourceLocators;
    }

    public int hashCode() {
        return SystemUtils.hashCode((Object[])new Object[]{this.jaxRsClass});
    }

    public final boolean hasSubResourceMethodsOrLocators() {
        return !this.resourceMethodsAndLocators.isEmpty();
    }

    private void initResourceMethodsAndLocators(ThreadLocalizedContext tlContext, JaxRsProviders jaxRsProviders, ExtensionBackwardMapping extensionBackwardMapping, Logger logger) throws IllegalArgumentException, MissingAnnotationException {
        for (java.lang.reflect.Method execMethod : this.jaxRsClass.getMethods()) {
            java.lang.reflect.Method annotatedMethod = this.getAnnotatedJavaMethod(execMethod);
            if (annotatedMethod == null) continue;
            Path path = annotatedMethod.getAnnotation(Path.class);
            Method httpMethod = WrapperUtil.getHttpMethod(annotatedMethod);
            try {
                SubResourceLocator subResLoc;
                String message;
                if (httpMethod != null) {
                    ResourceMethod subResMeth;
                    if (WrapperUtil.isVolatile(execMethod)) continue;
                    try {
                        subResMeth = new ResourceMethod(execMethod, annotatedMethod, this, httpMethod, tlContext, jaxRsProviders, extensionBackwardMapping, logger);
                    }
                    catch (IllegalMethodParamTypeException e) {
                        message = "Ignore method " + execMethod + ": An annotated parameter of the resource method " + annotatedMethod + " is has an illegal type";
                        logger.log(Level.WARNING, message, e);
                        continue;
                    }
                    catch (IllegalParamTypeException e) {
                        message = "Ignore method " + execMethod + ": " + e.getMessage();
                        logger.log(Level.WARNING, message, e);
                        continue;
                    }
                    this.resourceMethods.add(subResMeth);
                    this.resourceMethodsAndLocators.add(subResMeth);
                    this.checkForPrimitiveParameters(execMethod, logger);
                    continue;
                }
                if (path == null || WrapperUtil.isVolatile(execMethod)) continue;
                try {
                    subResLoc = new SubResourceLocator(execMethod, annotatedMethod, this, tlContext, jaxRsProviders, extensionBackwardMapping, logger);
                }
                catch (IllegalMethodParamTypeException e) {
                    message = "Ignore method " + execMethod + ": An annotated parameter of the resource method " + annotatedMethod + " is has an illegal type";
                    logger.log(Level.WARNING, message, e);
                    continue;
                }
                catch (IllegalParamTypeException e) {
                    message = "Ignore method " + execMethod + ": " + e.getMessage();
                    logger.log(Level.WARNING, message, e);
                    continue;
                }
                this.subResourceLocators.add(subResLoc);
                this.resourceMethodsAndLocators.add(subResLoc);
                this.checkForPrimitiveParameters(execMethod, logger);
            }
            catch (IllegalPathOnMethodException e) {
                logger.warning("The method " + annotatedMethod + " is annotated with an illegal path: " + e.getPath() + ". Ignoring this method. (" + e.getMessage() + ")");
            }
        }
    }

    boolean isLeaveEncoded() {
        return this.leaveEncoded;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.jaxRsClass + "]";
    }
}

