/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaxrs.internal.core;

import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.restlet.Application;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.CharacterSet;
import org.restlet.data.Dimension;
import org.restlet.data.Form;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.engine.util.SystemUtils;
import org.restlet.ext.jaxrs.ExtendedUriBuilder;
import org.restlet.ext.jaxrs.internal.core.MultivaluedMapImpl;
import org.restlet.ext.jaxrs.internal.core.PathSegmentImpl;
import org.restlet.ext.jaxrs.internal.core.UnmodifiableMultivaluedMap;
import org.restlet.ext.jaxrs.internal.core.UriBuilderImpl;
import org.restlet.ext.jaxrs.internal.todo.NotYetImplementedException;
import org.restlet.ext.jaxrs.internal.util.Converter;
import org.restlet.ext.jaxrs.internal.util.EmptyIterator;
import org.restlet.ext.jaxrs.internal.util.SecurityUtil;
import org.restlet.ext.jaxrs.internal.util.SortedMetadata;
import org.restlet.ext.jaxrs.internal.util.Util;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.security.Role;
import org.restlet.service.ConnegService;
import org.restlet.service.MetadataService;

public class CallContext
implements javax.ws.rs.core.Request,
HttpHeaders,
SecurityContext {
    private static final int STATUS_PREC_FAILED = Status.CLIENT_ERROR_PRECONDITION_FAILED.getCode();
    private static final Logger unexpectedLogger = Context.getCurrentLogger();
    private List<Locale> acceptedLanguages;
    private List<javax.ws.rs.core.MediaType> acceptedMediaTypes;
    private final SortedMetadata<MediaType> accMediaTypes;
    private String baseUri;
    private Map<String, Cookie> cookies;
    private Locale language;
    private final LinkedList<Object> matchedResources = new LinkedList();
    private final LinkedList<String> matchedURIs = new LinkedList();
    private javax.ws.rs.core.MediaType mediaType;
    private MultivaluedMap<String, String> pathParametersDecoded;
    private MultivaluedMap<String, String> pathParametersEncoded;
    private List<PathSegment> pathSegmentsDecoded = null;
    private List<PathSegment> pathSegmentsEncoded = null;
    private MultivaluedMap<String, String> queryParametersDecoded;
    private MultivaluedMap<String, String> queryParametersEncoded;
    private boolean readOnly = false;
    private final Reference referenceCut;
    private final Reference referenceOriginal;
    private final Request request;
    private UnmodifiableMultivaluedMap<String, String> requestHeaders;
    private final Response response;

    public CallContext(Request request, Response response) {
        if (request == null) {
            throw new IllegalArgumentException("The Restlet Request must not be null");
        }
        if (response == null) {
            throw new IllegalArgumentException("The Restlet Response must not be null");
        }
        Reference referenceCut = request.getResourceRef();
        if (referenceCut == null) {
            throw new IllegalArgumentException("The request reference must not be null");
        }
        if (referenceCut.getBaseRef() == null) {
            throw new IllegalArgumentException("The request reference must contains a baseRef");
        }
        Reference referenceOriginal = request.getOriginalRef();
        if (referenceOriginal == null) {
            throw new IllegalArgumentException("The request.originalRef must not be null");
        }
        Reference appRootRef = request.getRootRef();
        if (appRootRef == null) {
            throw new IllegalArgumentException("The root reference of the request must not be null");
        }
        referenceOriginal.setBaseRef(appRootRef);
        this.referenceCut = referenceCut;
        this.referenceOriginal = referenceOriginal;
        this.readOnly = false;
        this.request = request;
        this.response = response;
        this.accMediaTypes = SortedMetadata.getForMediaTypes(request.getClientInfo().getAcceptedMediaTypes());
    }

    public void addForMatched(Object resourceObject, String newUriPart) {
        if (resourceObject == null) {
            throw new IllegalArgumentException("The resource object must not be null");
        }
        if (newUriPart == null) {
            throw new IllegalArgumentException("The new URI part must not be null");
        }
        StringBuilder newUri = this.matchedURIs.isEmpty() ? new StringBuilder() : new StringBuilder(this.matchedURIs.getFirst());
        if (newUriPart.length() == 0 || newUriPart.charAt(0) != '/') {
            newUri.append('/');
        }
        newUri.append(newUriPart);
        this.matchedResources.addFirst(resourceObject);
        this.matchedURIs.addFirst(newUri.toString());
    }

    public void addPathParamsEnc(String varName, String varValue) {
        this.checkChangeable();
        this.interalGetPathParamsEncoded().add((Object)varName, (Object)varValue);
    }

    protected void checkChangeable() throws IllegalStateException {
        if (!this.isChangeable()) {
            throw new IllegalStateException("The CallContext is no longer changeable");
        }
    }

    private ExtendedUriBuilder createExtendedUriBuilder(Reference ref) {
        ExtendedUriBuilder b = new ExtendedUriBuilder();
        this.fillUriBuilder(ref, b);
        String extension = ref.getExtensions();
        b.extension(extension);
        return b;
    }

    private List<PathSegment> createPathSegments(boolean decode) {
        List segmentsEnc = this.referenceOriginal.getRelativeRef().getSegments();
        int l = segmentsEnc.size();
        ArrayList<PathSegmentImpl> pathSegments = new ArrayList<PathSegmentImpl>(l);
        for (int i = 0; i < l; ++i) {
            String segmentEnc = (String)segmentsEnc.get(i);
            pathSegments.add(new PathSegmentImpl(segmentEnc, decode, i));
        }
        return Collections.unmodifiableList(pathSegments);
    }

    private UriBuilder createUriBuilder(Reference ref) {
        UriBuilderImpl b = new UriBuilderImpl();
        return this.fillUriBuilder(ref, b);
    }

    public boolean equals(Object anotherObject) {
        if (this == anotherObject) {
            return true;
        }
        if (!(anotherObject instanceof UriInfo)) {
            return false;
        }
        UriInfo other = (UriInfo)anotherObject;
        if (!this.getBaseUri().equals(other.getBaseUri())) {
            return false;
        }
        if (!this.getPathSegments().equals(other.getPathSegments())) {
            return false;
        }
        return Util.equals(this.getPathParameters(), other.getPathParameters());
    }

    public Response.ResponseBuilder evaluatePreconditions() {
        return null;
    }

    public Response.ResponseBuilder evaluatePreconditions(Date lastModified) {
        if (lastModified == null) {
            throw new IllegalArgumentException("The last modification date must not be null");
        }
        return this.evaluatePreconditionsInternal(lastModified, null);
    }

    public Response.ResponseBuilder evaluatePreconditions(Date lastModified, EntityTag entityTag) {
        if (lastModified == null) {
            throw new IllegalArgumentException("The last modification date must not be null");
        }
        if (entityTag == null) {
            throw new IllegalArgumentException("The entity tag must not be null");
        }
        return this.evaluatePreconditionsInternal(lastModified, entityTag);
    }

    public Response.ResponseBuilder evaluatePreconditions(EntityTag entityTag) {
        if (entityTag == null) {
            throw new IllegalArgumentException("The entity tag must not be null");
        }
        return this.evaluatePreconditionsInternal(null, entityTag);
    }

    private Response.ResponseBuilder evaluatePreconditionsInternal(Date lastModified, EntityTag entityTag) {
        Status status = this.request.getConditions().getStatus(this.request.getMethod(), true, Converter.toRestletTag(entityTag), lastModified);
        if (status == null) {
            return null;
        }
        if (status.equals((Object)Status.REDIRECTION_NOT_MODIFIED)) {
            Response.ResponseBuilder rb = javax.ws.rs.core.Response.notModified();
            rb.lastModified(lastModified);
            rb.tag(entityTag);
            return rb;
        }
        return javax.ws.rs.core.Response.status((int)STATUS_PREC_FAILED);
    }

    private UriBuilder fillUriBuilder(Reference ref, UriBuilder b) throws IllegalArgumentException {
        b.scheme(ref.getScheme(false));
        b.userInfo(ref.getUserInfo(false));
        b.host(ref.getHostDomain(false));
        b.port(ref.getHostPort());
        b.path(ref.getPath(false));
        b.replaceQuery(ref.getQuery(false));
        b.fragment(ref.getFragment(false));
        return b;
    }

    public URI getAbsolutePath() {
        try {
            return new URI(this.referenceOriginal.toString(false, false));
        }
        catch (URISyntaxException e) {
            throw this.wrapUriSyntaxExc(e, unexpectedLogger, "Could not create URI");
        }
    }

    public UriBuilder getAbsolutePathBuilder() {
        return this.createUriBuilder(this.referenceOriginal);
    }

    ExtendedUriBuilder getAbsolutePathBuilderExtended() {
        return this.createExtendedUriBuilder(this.referenceOriginal);
    }

    public List<Locale> getAcceptableLanguages() {
        if (this.acceptedLanguages == null) {
            SortedMetadata<Language> accLangages = SortedMetadata.getForLanguages(this.request.getClientInfo().getAcceptedLanguages());
            ArrayList<Locale> accLangs = new ArrayList<Locale>();
            for (Language language : accLangages) {
                accLangs.add(Converter.toLocale(language));
            }
            this.acceptedLanguages = Collections.unmodifiableList(accLangs);
        }
        return this.acceptedLanguages;
    }

    public List<javax.ws.rs.core.MediaType> getAcceptableMediaTypes() {
        if (this.acceptedMediaTypes == null) {
            ArrayList<javax.ws.rs.core.MediaType> accMediaTypes = new ArrayList<javax.ws.rs.core.MediaType>();
            for (MediaType mediaType : this.accMediaTypes) {
                accMediaTypes.add(Converter.toJaxRsMediaType(mediaType));
            }
            this.acceptedMediaTypes = Collections.unmodifiableList(accMediaTypes);
        }
        return this.acceptedMediaTypes;
    }

    public SortedMetadata<MediaType> getAccMediaTypes() {
        return this.accMediaTypes;
    }

    public String getAuthenticationScheme() {
        if (SecurityUtil.isSslClientCertAuth(this.request)) {
            return "CLIENT_CERT";
        }
        ChallengeResponse challengeResponse = this.request.getChallengeResponse();
        if (challengeResponse == null) {
            return null;
        }
        if (!this.request.getClientInfo().isAuthenticated()) {
            return null;
        }
        ChallengeScheme authScheme = challengeResponse.getScheme();
        if (authScheme == null) {
            return null;
        }
        if (authScheme.equals((Object)ChallengeScheme.HTTP_BASIC)) {
            return "BASIC";
        }
        if (authScheme.equals((Object)ChallengeScheme.HTTP_DIGEST)) {
            return "DIGEST";
        }
        return authScheme.getName();
    }

    public URI getBaseUri() {
        try {
            return new URI(this.getBaseUriStr());
        }
        catch (URISyntaxException e) {
            throw this.wrapUriSyntaxExc(e, unexpectedLogger, "Could not create URI");
        }
    }

    public UriBuilder getBaseUriBuilder() {
        return UriBuilder.fromUri((String)this.getBaseUriStr());
    }

    ExtendedUriBuilder getBaseUriBuilderExtended() {
        ExtendedUriBuilder uriBuilder = ExtendedUriBuilder.fromUri(this.getBaseUriStr());
        ExtendedUriBuilder originalRef = this.createExtendedUriBuilder(this.referenceOriginal);
        uriBuilder.extension(originalRef.getExtension());
        return uriBuilder;
    }

    private String getBaseUriStr() {
        Reference baseRef;
        if (this.baseUri == null && (baseRef = this.referenceCut.getBaseRef()) != null) {
            this.baseUri = baseRef.toString(false, false);
        }
        return this.baseUri;
    }

    public String getConnegExtension() {
        return this.referenceOriginal.getExtensions();
    }

    public Map<String, Cookie> getCookies() {
        if (this.cookies == null) {
            HashMap<String, Cookie> cookies = new HashMap<String, Cookie>();
            for (org.restlet.data.Cookie rc : this.request.getCookies()) {
                Cookie cookie = Converter.toJaxRsCookie(rc);
                cookies.put(cookie.getName(), cookie);
            }
            this.cookies = Collections.unmodifiableMap(cookies);
        }
        return this.cookies;
    }

    public Locale getLanguage() {
        if (this.language == null) {
            Representation entity = this.request.getEntity();
            if (entity == null) {
                return null;
            }
            List languages = entity.getLanguages();
            if (languages.isEmpty()) {
                return null;
            }
            this.language = Converter.toLocale((Language)Util.getFirstElement(languages));
        }
        return this.language;
    }

    public String getLastMatrixParamEnc(MatrixParam matrixParamAnnot) {
        String mpName = matrixParamAnnot.value();
        List<PathSegment> pathSegments = this.getPathSegments(false);
        for (int i = pathSegments.size() - 1; i >= 0; --i) {
            PathSegment pathSegment = pathSegments.get(i);
            List mpValues = (List)pathSegment.getMatrixParameters().get((Object)mpName);
            if (mpValues == null || mpValues.isEmpty()) continue;
            String result = (String)Util.getLastElement(mpValues);
            if (result == null) {
                return "";
            }
            return result;
        }
        return null;
    }

    public String getLastPathParamEnc(PathParam annotation) {
        String varName = annotation.value();
        List values = (List)this.interalGetPathParamsEncoded().get((Object)varName);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return (String)Util.getLastElement(values);
    }

    public String getLastPathSegmentEnc(PathParam pathParam) {
        pathParam.annotationType();
        throw new NotYetImplementedException();
    }

    List<Object> getMatchedResources() {
        return this.matchedResources;
    }

    List<String> getMatchedURIs() {
        return this.matchedURIs;
    }

    public javax.ws.rs.core.MediaType getMediaType() {
        if (this.mediaType == null) {
            MediaType rmt = this.request.getEntity().getMediaType();
            CharacterSet rCharSet = this.request.getEntity().getCharacterSet();
            this.mediaType = Converter.toJaxRsMediaType(rmt, rCharSet);
        }
        return this.mediaType;
    }

    public String getMethod() {
        return this.request.getMethod().getName();
    }

    public String getPath() {
        return this.getPath(true);
    }

    public String getPath(boolean decode) {
        String path = this.referenceOriginal.getRelativeRef().toString(true, true);
        if (!decode) {
            return path;
        }
        return Reference.decode((String)path);
    }

    public MultivaluedMap<String, String> getPathParameters() {
        if (this.pathParametersDecoded == null) {
            MultivaluedMapImpl<String, String> pathParamsDec = new MultivaluedMapImpl<String, String>();
            for (Map.Entry entryEnc : this.interalGetPathParamsEncoded().entrySet()) {
                String keyDec = Reference.decode((String)((String)entryEnc.getKey()));
                List valuesEnc = (List)entryEnc.getValue();
                ArrayList<String> valuesDec = new ArrayList<String>(valuesEnc.size());
                for (String valueEnc : valuesEnc) {
                    valuesDec.add(Reference.decode((String)valueEnc));
                }
                pathParamsDec.put(keyDec, (String)((Object)valuesDec));
            }
            UnmodifiableMultivaluedMap<String, String> ppd = UnmodifiableMultivaluedMap.get(pathParamsDec, false);
            if (this.isChangeable()) {
                return ppd;
            }
            this.pathParametersDecoded = ppd;
        }
        return this.pathParametersDecoded;
    }

    public MultivaluedMap<String, String> getPathParameters(boolean decode) {
        if (decode) {
            return this.getPathParameters();
        }
        return UnmodifiableMultivaluedMap.get(this.interalGetPathParamsEncoded());
    }

    public List<PathSegment> getPathSegments() {
        return this.getPathSegments(true);
    }

    public List<PathSegment> getPathSegments(boolean decode) {
        if (decode) {
            if (this.pathSegmentsDecoded == null) {
                this.pathSegmentsDecoded = this.createPathSegments(true);
            }
            return this.pathSegmentsDecoded;
        }
        if (this.pathSegmentsEncoded == null) {
            this.pathSegmentsEncoded = this.createPathSegments(false);
        }
        return this.pathSegmentsEncoded;
    }

    public MultivaluedMap<String, String> getQueryParameters() {
        if (this.queryParametersDecoded == null) {
            this.queryParametersDecoded = UnmodifiableMultivaluedMap.getFromSeries(this.referenceOriginal.getQueryAsForm(), false);
        }
        return this.queryParametersDecoded;
    }

    public MultivaluedMap<String, String> getQueryParameters(boolean decode) {
        if (decode) {
            return this.getQueryParameters();
        }
        if (this.queryParametersEncoded == null) {
            Form queryForm = Converter.toFormEncoded(this.referenceOriginal.getQuery());
            this.queryParametersEncoded = UnmodifiableMultivaluedMap.getFromSeries(queryForm, false);
        }
        return this.queryParametersEncoded;
    }

    public Request getRequest() {
        return this.request;
    }

    public List<String> getRequestHeader(String headerName) {
        String[] values = Util.getHttpHeaders(this.request).getValuesArray(headerName, true);
        return Collections.unmodifiableList(Arrays.asList(values));
    }

    public MultivaluedMap<String, String> getRequestHeaders() {
        if (this.requestHeaders == null) {
            this.requestHeaders = UnmodifiableMultivaluedMap.getFromSeries(Util.getHttpHeaders(this.request), false);
        }
        return this.requestHeaders;
    }

    public URI getRequestUri() {
        try {
            return new URI(this.referenceOriginal.toString(true, true));
        }
        catch (URISyntaxException e) {
            throw this.wrapUriSyntaxExc(e, unexpectedLogger, "Could not create URI");
        }
    }

    public UriBuilder getRequestUriBuilder() {
        return UriBuilder.fromUri((URI)this.getRequestUri());
    }

    ExtendedUriBuilder getRequestUriBuilderExtended() {
        return ExtendedUriBuilder.fromUri(this.getRequestUri());
    }

    public Response getResponse() {
        return this.response;
    }

    public Principal getUserPrincipal() {
        Principal foundPrincipal;
        Principal principal = foundPrincipal = this.request.getChallengeResponse() == null ? null : this.request.getChallengeResponse().getPrincipal();
        if (foundPrincipal != null) {
            return foundPrincipal;
        }
        return SecurityUtil.getSslClientCertPrincipal(this.request);
    }

    public int hashCode() {
        return SystemUtils.hashCode((Object[])new Object[]{this.getBaseUriStr(), this.getPathSegments(), this.getPathParameters()});
    }

    protected MultivaluedMap<String, String> interalGetPathParamsEncoded() {
        if (this.pathParametersEncoded == null) {
            this.pathParametersEncoded = new MultivaluedMapImpl<String, String>();
        }
        return this.pathParametersEncoded;
    }

    protected boolean isChangeable() {
        return !this.readOnly;
    }

    public boolean isSecure() {
        return this.request.isConfidential();
    }

    public boolean isUserInRole(String roleName) {
        Role role = Application.getCurrent().getRole(roleName);
        return role != null && this.request.getClientInfo().getRoles().contains(role);
    }

    public Iterator<String> matrixParamEncIter(MatrixParam matrixParamAnnot) {
        String mpName = matrixParamAnnot.value();
        return new MatrixParamEncIter(mpName, this.getPathSegments(false));
    }

    public Iterator<String> pathParamEncIter(PathParam pathParamAnnot) {
        String ppName = pathParamAnnot.value();
        List pathParamValues = (List)this.interalGetPathParamsEncoded().get((Object)ppName);
        if (pathParamValues == null) {
            return EmptyIterator.get();
        }
        return pathParamValues.iterator();
    }

    public Iterator<String> pathSegementEncIter(PathParam pathParam) {
        pathParam.annotationType();
        throw new NotYetImplementedException();
    }

    public javax.ws.rs.core.Variant selectVariant(List<javax.ws.rs.core.Variant> variants) throws IllegalArgumentException {
        if (variants == null || variants.isEmpty()) {
            throw new IllegalArgumentException();
        }
        List<Variant> restletVariants = Converter.toRestletVariants(variants);
        ConnegService connegService = null;
        MetadataService metadataService = null;
        Application app = Application.getCurrent();
        if (app == null) {
            connegService = new ConnegService();
            metadataService = new MetadataService();
        } else {
            connegService = app.getConnegService();
            metadataService = app.getMetadataService();
        }
        Variant bestRestlVar = connegService.getPreferredVariant(restletVariants, this.request, metadataService);
        javax.ws.rs.core.Variant bestVariant = Converter.toJaxRsVariant(bestRestlVar);
        Set dimensions = this.response.getDimensions();
        if (bestRestlVar.getCharacterSet() != null) {
            dimensions.add(Dimension.CHARACTER_SET);
        }
        if (bestRestlVar.getEncodings() != null) {
            dimensions.add(Dimension.ENCODING);
        }
        if (bestRestlVar.getLanguages() != null) {
            dimensions.add(Dimension.LANGUAGE);
        }
        if (bestRestlVar.getMediaType() != null) {
            dimensions.add(Dimension.MEDIA_TYPE);
        }
        return bestVariant;
    }

    public void setReadOnly() {
        this.readOnly = true;
    }

    public String toString() {
        return this.referenceOriginal.toString(true, false);
    }

    private WebApplicationException wrapUriSyntaxExc(URISyntaxException exc, Logger logger, String logMessage) throws WebApplicationException {
        logger.log(Level.WARNING, logMessage, exc);
        throw new WebApplicationException((Throwable)exc, Response.Status.INTERNAL_SERVER_ERROR);
    }

    private static class MatrixParamEncIter
    implements Iterator<String> {
        private Iterator<Map.Entry<String, List<String>>> matrixParamIter;
        private final String mpName;
        private Iterator<String> mpValueIter;
        private String nextMpValue;
        private final Iterator<PathSegment> pathSegmentIter;

        MatrixParamEncIter(String mpName, List<PathSegment> pathSegmentsEnc) {
            this.pathSegmentIter = pathSegmentsEnc.iterator();
            this.mpName = mpName;
        }

        @Override
        public boolean hasNext() {
            if (this.nextMpValue != null) {
                return true;
            }
            if (this.mpValueIter != null && this.mpValueIter.hasNext()) {
                this.nextMpValue = this.mpValueIter.next();
                return true;
            }
            while (this.matrixParamIter != null && this.matrixParamIter.hasNext()) {
                Map.Entry<String, List<String>> entry = this.matrixParamIter.next();
                if (!entry.getKey().equals(this.mpName)) continue;
                this.mpValueIter = entry.getValue().iterator();
                return this.hasNext();
            }
            if (this.pathSegmentIter.hasNext()) {
                this.matrixParamIter = this.pathSegmentIter.next().getMatrixParameters().entrySet().iterator();
                return this.hasNext();
            }
            return false;
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String nextMpValue = this.nextMpValue;
            this.nextMpValue = null;
            return nextMpValue;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("unmodifiable");
        }
    }
}

